/*
 * #%L
 * SGQ :: Business
 * $Id: SearchColumn.java 114 2012-10-02 15:10:18Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/SearchColumn.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import static org.nuiton.i18n.I18n._;

import com.herbocailleau.sgq.business.SgqUtils;

/**
 * Liste des colonnes selectionnables et affichable dans les resultats de
 * recherche (aussi bien web que export csv).
 * 
 * Elle est dynamique pour la génération du tableau ou du fichier csv,
 * l'enumeration doit donc être capable d'afficher toute seule les données
 * d'un {@link BatchModel}.
 * 
 * @author echatellier
 */
public enum SearchColumn {
    PRODUCT_CODE(_("Code Produit"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getCode();
        }
    }, true),
    PRODUCT_NAME(_("Nom Produit"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getName();
        }
    }, true),
    PRODUCT_LATIN_NAME(_("Nom latin"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getLatinName();
        }
    }, false),
    PRODUCT_CATEGORY(_("Cat\u00E9gorie"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getCategory();
        }
    }, false),
    BATCH_NUMBER(_("Lot"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return String.valueOf(batchModel.getBatch().getNumber());
        }
    }, true),
    BATCH_SUPPLIER(_("Fournisseur"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getSupplier() != null) {
                result = batchModel.getBatch().getSupplier().getName();
            }
            return result;
        }
    }, false),
    BATCH_CLIENT(_("Client"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDedicatedClient() != null) {
                result = batchModel.getBatch().getDedicatedClient().getName();
            }
            return result;
        }
    }, false),
    BATCH_ORIGIN(_("Origine"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getOrigin() != null) {
                result = batchModel.getBatch().getOrigin().getCountry();
            }
            return result;
        }
    }, false),
    BATCH_TOTAL_PRESENTATION(_("Quantité disponible"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return String.valueOf(batchModel.getTotalPresentation());
        }
    }, true),
    BATCH_TOTAL_SALE(_("Cumul vente"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            return String.valueOf(batchModel.getTotalSale());
        }
    }, false),
    BATCH_ENTRY_DATE(_("Date d'entrée"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getEntryDate() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getEntryDate());
            }
            return result;
        }
    }, false),
    BATCH_DPMES(_("DPMES"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDpmes() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDpmes());
            }
            return result;
        }
    }, false),
    BATCHDMES(_("DMES"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getDmes() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getDmes());
            }
            return result;
        }
    }, false),
    BATCH_DMESD(_("DMESD"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDmesd() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDmesd());
            }
            return result;
        }
    }, false),
    BATCH_DLUO(_("DLUO"), new BatchModelFunction() {
        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDluo() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDluo());
            }
            return result;
        }
    }, true);

    protected String description;

    protected boolean defaultSelected;

    protected BatchModelFunction function;

    private SearchColumn(String description, BatchModelFunction function, boolean defaultSelected) {
        this.description = description;
        this.function = function;
        this.defaultSelected = defaultSelected;
    }

    public String getDescription() {
        return description;
    }

    public boolean isDefaultSelected() {
        return defaultSelected;
    }

    public String getValueFor(BatchModel batchModel) {
        return function.apply(batchModel);
    }
}

interface BatchModelFunction {
    public String apply(BatchModel batchModel);
}