/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.BatchImpl;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class DataRecoveryService
extends SgqService {
    private static final Log log = LogFactory.getLog(DataRecoveryService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importBatchFile(File batchFile) {
        FileInputStream batchStream = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            batchStream = new FileInputStream(batchFile);
            POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)batchStream);
            HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
            HSSFSheet mySheet = myWorkBook.getSheet("Entr\u00e9es pdts");
            Iterator rowIter = mySheet.rowIterator();
            rowIter.next();
            while (rowIter.hasNext()) {
                HSSFRow myRow = (HSSFRow)rowIter.next();
                String codeProduit = myRow.getCell(0).getStringCellValue();
                double numeroLot = myRow.getCell(1).getNumericCellValue();
                Date dmes = null;
                if (myRow.getCell(2).getCellType() == 0) {
                    dmes = myRow.getCell(2).getDateCellValue();
                }
                Date dateEntree = myRow.getCell(4).getDateCellValue();
                double poids = myRow.getCell(6).getNumericCellValue();
                String unite = myRow.getCell(7).getStringCellValue();
                String fournisseur = myRow.getCell(8).getStringCellValue();
                Date dluo = myRow.getCell(9).getDateCellValue();
                int indexOfSlash = codeProduit.indexOf(47);
                if (indexOfSlash >= 0) {
                    codeProduit = codeProduit.substring(0, indexOfSlash);
                }
                BatchImpl batch = new BatchImpl();
                batch.setNumber((int)numeroLot);
                batch.setEntryDate(dateEntree);
                batch.setDluo(dluo);
                batch.setProduct((Product)productDAO.findByCode(codeProduit));
                batchDAO.create(batch);
            }
            batchStream.close();
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't import numero lot file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't import numero lot file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(batchStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)batchStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importProductFile(File productsFile) {
        FileInputStream batchStream = null;
        try {
            HSSFRow myRow;
            HSSFCell cell;
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            batchStream = new FileInputStream(productsFile);
            POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)batchStream);
            HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
            HSSFSheet mySheet = myWorkBook.getSheetAt(0);
            Iterator rowIter = mySheet.rowIterator();
            rowIter.next();
            rowIter.next();
            while (rowIter.hasNext() && (cell = (myRow = (HSSFRow)rowIter.next()).getCell(0)) != null) {
                String codeProduit = cell.getStringCellValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Importing product " + codeProduit));
                }
                String nom = myRow.getCell(1).toString();
                String category = myRow.getCell(2).getStringCellValue();
                String latinName = myRow.getCell(3).getStringCellValue();
                String family = myRow.getCell(4).getStringCellValue();
                String status = "";
                if ("Oui".equals(myRow.getCell(5).getStringCellValue())) {
                    status = status + "Liste A Pharmacop\u00e9e,";
                }
                if ("Oui".equals(myRow.getCell(6).getStringCellValue())) {
                    status = status + "Alimentaire Pharmacop\u00e9e,";
                }
                if ("Oui".equals(myRow.getCell(7).getStringCellValue())) {
                    status = status + "Toxique Pharmacop\u00e9e,";
                }
                if ("Oui".equals(myRow.getCell(8).getStringCellValue())) {
                    status = status + "Liste B Pharmacop\u00e9e,";
                }
                if (StringUtils.isNotBlank((CharSequence)myRow.getCell(9).getStringCellValue())) {
                    status = status + myRow.getCell(9).getStringCellValue() + ",";
                }
                if ("Oui".equals(myRow.getCell(10).getStringCellValue())) {
                    status = status + "Monopole Pharmacop\u00e9e,";
                }
                if ("Oui".equals(myRow.getCell(11).getStringCellValue())) {
                    status = status + "D\u00e9cret n\u00b02008-841 - Plantes m\u00e9dicinales lib\u00e9r\u00e9es pour les compl\u00e9ments alimentaires,";
                }
                if ("Oui".equals(myRow.getCell(12).getStringCellValue())) {
                    status = status + "Norme AFNOR - NF EN ISO 676,";
                }
                if ("Oui".equals(myRow.getCell(13).getStringCellValue())) {
                    status = status + "EHIA,";
                }
                if ("Oui".equals(myRow.getCell(14).getStringCellValue())) {
                    status = status + "Arr\u00eat\u00e9 Belge,";
                }
                if (StringUtils.isNotBlank((CharSequence)myRow.getCell(15).getStringCellValue())) {
                    status = status + myRow.getCell(15).getStringCellValue() + ",";
                }
                String analyze = "";
                if (StringUtils.isNotBlank((CharSequence)myRow.getCell(16).getStringCellValue())) {
                    analyze = analyze + myRow.getCell(16).getStringCellValue() + ",";
                }
                if ("Oui".equals(myRow.getCell(18).getStringCellValue())) {
                    analyze = analyze + "Bact\u00e9rio Cat\u00e9gorie 4A,";
                }
                if ("Oui".equals(myRow.getCell(18).getStringCellValue())) {
                    analyze = analyze + "Bact\u00e9rio Cat\u00e9gorie C,";
                }
                if ("Oui".equals(myRow.getCell(18).getStringCellValue())) {
                    analyze = analyze + "Bact\u00e9rio EHIA,";
                }
                if ("Oui".equals(myRow.getCell(18).getStringCellValue())) {
                    analyze = analyze + "Analyse,";
                }
                if ("Oui".equals(myRow.getCell(18).getStringCellValue())) {
                    analyze = analyze + "M\u00e9taux lourds,";
                }
                boolean botanicControl = false;
                if ("Oui".equals(myRow.getCell(19).getStringCellValue())) {
                    botanicControl = true;
                }
                boolean identificationControl = false;
                if ("Oui".equals(myRow.getCell(20).getStringCellValue())) {
                    identificationControl = true;
                }
                Object product = productDAO.createByNaturalId(codeProduit);
                product.setName(nom);
                product.setCategory(category);
                product.setLatinName(latinName);
                product.setFamily(family);
                product.setStatus(status);
                product.setAnalyzes(analyze);
                product.setBotanicControl(botanicControl);
                product.setIdentificationControl(identificationControl);
                productDAO.update((TopiaEntity)product);
            }
            batchStream.close();
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't import product file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't import product file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(batchStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)batchStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportInventory(File inventoryFile) {
        FileOutputStream fileOut = null;
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet();
            HSSFRow headerRow = sheet.createRow(0);
            headerRow.createCell(0).setCellValue("Lot");
            HSSFRow row = sheet.createRow(1);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(1.0);
            row = sheet.createRow(2);
            cell = row.createCell(0);
            cell.setCellValue(2.0);
            fileOut = new FileOutputStream(inventoryFile);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            IOUtils.closeQuietly((OutputStream)fileOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(fileOut);
        }
    }
}

