/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.Supplier;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.NumField;

public class BatchService
extends SgqService {
    private static final Log log = LogFactory.getLog(BatchService.class);

    public long getBatchCount() {
        long count = 0L;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            count = batchDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return count;
    }

    public List<BatchModel> searchBatch(SearchModel search) {
        List<BatchModel> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.findAllWithQuantity(search);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    public List<Batch> findAllBetweenNumbers(int startNumber, int endNumber) {
        List<Batch> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.findAllBetweenNumbers(startNumber, endNumber);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    public Batch getBatchById(String batchId) {
        Batch result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = (Batch)batchDAO.findByTopiaId(batchId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    protected Batch getBatchByNumber(int batchNumer) {
        Batch result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = (Batch)batchDAO.findByNumber(batchNumer);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by number", ex);
        }
        return result;
    }

    public List<Presentation> findAllPresentationsByBatch(Batch batch) {
        List<Presentation> presentations = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            presentations = presentationDAO.findAllByBatch(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return presentations;
    }

    public Presentation getPresentationById(String presentationId) {
        Presentation result = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            result = (Presentation)presentationDAO.findByTopiaId(presentationId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public void updatePresentation(Presentation presentation) {
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            presentationDAO.update(presentation);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't update", ex);
        }
    }

    public List<Analyze> findAllAnalyzesByBatch(Batch batch) {
        List<Analyze> analyzes = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            analyzes = analyzeDAO.findAllByBatch(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return analyzes;
    }

    public int getNextBioBatchNumber() {
        int result = 0;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getNextRangeIdBetween(this.config.getBatchRangeBioStart(), this.config.getBatchRangeBioEnd());
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public int getNextNonBioBatchNumber() {
        int result = 0;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getNextRangeIdBetween(this.config.getBatchRangeNonBioStart(), this.config.getBatchRangeNonBioEnd());
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public Analyze getAnalyzeById(String analyzeId) {
        Analyze result = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            result = (Analyze)analyzeDAO.findByTopiaId(analyzeId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public void addAnalyze(Analyze analyze) {
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            analyzeDAO.create(analyze);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't create analyze", ex);
        }
    }

    public List<Analyze> getAnalysisToSend(AnalyzeType analyzeType) {
        List<Analyze> result = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            result = analyzeDAO.findAllAnalyzeToSend(analyzeType);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analysis", ex);
        }
        return result;
    }

    public List<Analyze> getAnalysisToReceive(AnalyzeType analyzeType) {
        List<Analyze> result = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            result = analyzeDAO.findAllAnalyzeToReceive(analyzeType);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analysis", ex);
        }
        return result;
    }

    public void importBatchFile(File batchFile) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing batch from file " + batchFile));
        }
        DBF fileDB = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            int nonBioStart = this.getNextNonBioBatchNumber();
            int nonBioEnd = this.config.getBatchRangeNonBioEnd();
            int bioStart = this.getNextBioBatchNumber();
            int bioEnd = this.config.getBatchRangeBioEnd();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
            fileDB = new DBF(batchFile.getAbsolutePath(), 'r', "UTF-8");
            DateField dateEntreeField = (DateField)fileDB.getField("DATE_R");
            NumField colisField = (NumField)fileDB.getField("COLIS_R");
            NumField poidsField = (NumField)fileDB.getField("POIDS_R");
            CharField codeProduitField = (CharField)fileDB.getField("PROD_R");
            NumField lotField = (NumField)fileDB.getField("LOT_R");
            CharField dluoField = (CharField)fileDB.getField("DLUO_R");
            for (int i = 0; i < fileDB.getRecordCount(); ++i) {
                fileDB.read();
                int num = (int)Double.parseDouble(lotField.get().trim());
                if (nonBioStart <= num && num <= nonBioEnd || bioStart <= num && num <= bioEnd) {
                    String codeProduit = codeProduitField.get().trim();
                    PresentationCode codePres = null;
                    if (codeProduit.length() != 6) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Invalid product code " + codeProduit));
                        continue;
                    }
                    codePres = PresentationCode.getPresentationCodeFor(codeProduit.charAt(0));
                    codeProduit = codeProduit.substring(1);
                    String dluo = dluoField.get();
                    if (!dluo.matches("\\d\\d/\\d\\d/\\d\\d")) continue;
                    double quantity = Double.parseDouble(poidsField.get());
                    Object product = productDAO.findByCode(codeProduit);
                    if (product == null) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't find product " + codeProduit));
                        continue;
                    }
                    Object batch = batchDAO.createByNaturalId(num);
                    batch.setProduct((Product)product);
                    batch.setDluo(df.parse(dluo));
                    batch.setEntryDate(dateEntreeField.getCalendar().getTime());
                    batch.setQuantity(quantity);
                    batch.setPackageCount((int)Double.parseDouble(colisField.get().trim()));
                    batch = (Batch)batchDAO.update((TopiaEntity)batch);
                    Presentation presentation = (Presentation)presentationDAO.create(new Object[0]);
                    presentation.setQuantity(quantity);
                    presentation.setBatch((Batch)batch);
                    presentation.setName(product.getName());
                    presentation.setPresentationCode(codePres);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping product " + num + " (out of range)"));
            }
            this.daoHelper.commit();
        }
        catch (Exception ex) {
            try {
                throw new SgqBusinessException("Can't read dbf file", ex);
            }
            catch (Throwable throwable) {
                SgqUtils.closeFile(fileDB);
                throw throwable;
            }
        }
        SgqUtils.closeFile(fileDB);
    }

    public void sendAnalyzeToSupplier(Analyze analyze, Supplier supplier) {
        block2: {
            try {
                AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
                analyze.setSupplier(supplier);
                analyze.setSentDate(new Date());
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't send analyze to supplier");
            }
        }
    }

    public void receiveAnalyzeFromSupplier(Analyze analyze, Supplier supplier) {
        block2: {
            try {
                AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
                analyze.setSupplier(supplier);
                analyze.setReceiptDate(new Date());
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't send analyze to supplier");
            }
        }
    }
}

