/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq;

import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;
import com.herbocailleau.sgq.entities.AnalyzeDAO;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.AnalyzeFileDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeDAO;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PlaceDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.Sale;
import com.herbocailleau.sgq.entities.SaleDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierDAO;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public class SGQDAOHelper {
    protected SGQDAOHelper() {
    }

    public static String getModelVersion() {
        return "";
    }

    public static String getModelName() {
        return "SGQ";
    }

    public static AnalyzeDAO getAnalyzeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        AnalyzeDAO result = (AnalyzeDAO)ci.getDAO(Analyze.class, AnalyzeDAO.class);
        return result;
    }

    public static AnalyzeCategoryDAO getAnalyzeCategoryDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        AnalyzeCategoryDAO result = (AnalyzeCategoryDAO)ci.getDAO(AnalyzeCategory.class, AnalyzeCategoryDAO.class);
        return result;
    }

    public static AnalyzeFileDAO getAnalyzeFileDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        AnalyzeFileDAO result = (AnalyzeFileDAO)ci.getDAO(AnalyzeFile.class, AnalyzeFileDAO.class);
        return result;
    }

    public static AnalyzeTypeDAO getAnalyzeTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        AnalyzeTypeDAO result = (AnalyzeTypeDAO)ci.getDAO(AnalyzeType.class, AnalyzeTypeDAO.class);
        return result;
    }

    public static BatchDAO getBatchDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        BatchDAO result = (BatchDAO)ci.getDAO(Batch.class, BatchDAO.class);
        return result;
    }

    public static ClientDAO getClientDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        ClientDAO result = (ClientDAO)ci.getDAO(Client.class, ClientDAO.class);
        return result;
    }

    public static PlaceDAO getPlaceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        PlaceDAO result = (PlaceDAO)ci.getDAO(Place.class, PlaceDAO.class);
        return result;
    }

    public static PresentationDAO getPresentationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        PresentationDAO result = (PresentationDAO)ci.getDAO(Presentation.class, PresentationDAO.class);
        return result;
    }

    public static ProductDAO getProductDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        ProductDAO result = (ProductDAO)ci.getDAO(Product.class, ProductDAO.class);
        return result;
    }

    public static SaleDAO getSaleDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SaleDAO result = (SaleDAO)ci.getDAO(Sale.class, SaleDAO.class);
        return result;
    }

    public static SupplierDAO getSupplierDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SupplierDAO result = (SupplierDAO)ci.getDAO(Supplier.class, SupplierDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SGQEntityEnum constant = SGQEntityEnum.valueOf(klass);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        SGQEntityEnum constant = SGQEntityEnum.valueOf(entity);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        SGQEntityEnum constant = SGQEntityEnum.valueOf(klass);
        return constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        SGQEntityEnum constant = SGQEntityEnum.valueOf(klass);
        return constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        SGQEntityEnum[] values = SGQEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        SGQEntityEnum[] values = SGQEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : SGQDAOHelper.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static SGQEntityEnum[] getContracts() {
        return SGQEntityEnum.values();
    }

    public static enum SGQEntityEnum implements TopiaEntityEnum
    {
        Analyze(Analyze.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        AnalyzeCategory(AnalyzeCategory.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        AnalyzeFile(AnalyzeFile.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        AnalyzeType(AnalyzeType.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        Batch(Batch.class, new String[]{"number"}, "number"),
        Client(Client.class, new String[]{"code"}, "code"),
        Place(Place.class, new String[]{"name"}, "name"),
        Presentation(Presentation.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        Product(Product.class, new String[]{"code"}, "code"),
        Sale(Sale.class, ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
        Supplier(Supplier.class, new String[]{"code"}, "code");

        protected Class<? extends TopiaEntity> contract;
        protected String implementationFQN;
        protected Class<? extends TopiaEntity> implementation;
        protected String[] naturalIds;
        protected String[] notNulls;

        private SGQEntityEnum(Class<? extends TopiaEntity> contract, String[] notNulls, String ... naturalIds) {
            this.contract = contract;
            this.notNulls = notNulls;
            this.naturalIds = naturalIds;
            this.implementationFQN = contract.getName() + "Impl";
        }

        public Class<? extends TopiaEntity> getContract() {
            return this.contract;
        }

        public String[] getNaturalIds() {
            return this.naturalIds;
        }

        public boolean isUseNaturalIds() {
            return this.naturalIds.length > 0;
        }

        public String[] getNotNulls() {
            return this.notNulls;
        }

        public boolean isUseNotNulls() {
            return this.notNulls.length > 0;
        }

        public String getImplementationFQN() {
            return this.implementationFQN;
        }

        public void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
        }

        public boolean accept(Class<? extends TopiaEntity> klass) {
            return SGQDAOHelper.getContractClass(klass) == this.contract;
        }

        public Class<? extends TopiaEntity> getImplementation() {
            if (this.implementation == null) {
                try {
                    this.implementation = Class.forName(this.implementationFQN);
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaRuntimeException("could not find class " + this.implementationFQN, (Throwable)e);
                }
            }
            return this.implementation;
        }

        public static SGQEntityEnum valueOf(TopiaEntity entity) {
            return SGQEntityEnum.valueOf(entity.getClass());
        }

        public static SGQEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return SGQEntityEnum.valueOf(klass.getSimpleName());
            }
            for (SGQEntityEnum entityEnum : SGQEntityEnum.values()) {
                if (!entityEnum.getContract().isAssignableFrom(klass)) continue;
                return entityEnum;
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])SGQEntityEnum.values()));
        }
    }
}

