package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class BatchAbstract extends TopiaEntityAbstract implements Batch {

    /**
     * Nom de l'attribut en BD : number
     */
    protected int number;

    /**
     * Nom de l'attribut en BD : entryDate
     */
    protected Date entryDate;

    /**
     * Nom de l'attribut en BD : dmes
     */
    protected Date dmes;

    /**
     * Nom de l'attribut en BD : dpmes
     */
    protected Date dpmes;

    /**
     * Nom de l'attribut en BD : dluo
     */
    protected Date dluo;

    /**
     * Nom de l'attribut en BD : spentDate
     */
    protected Date spentDate;

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : packageCount
     */
    protected int packageCount;

    /**
     * Nom de l'attribut en BD : supplier
     */
    protected Supplier supplier;

    /**
     * Nom de l'attribut en BD : product
     */
    protected Product product;

    /**
     * Nom de l'attribut en BD : dedicatedClient
     */
    protected Client dedicatedClient;

    /**
     * Nom de l'attribut en BD : analyzeFile
     */
    protected Collection<AnalyzeFile> analyzeFile;

    private static final long serialVersionUID = 7234243577027901745L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NUMBER, int.class, number);
        visitor.visit(this, PROPERTY_ENTRY_DATE, Date.class, entryDate);
        visitor.visit(this, PROPERTY_DMES, Date.class, dmes);
        visitor.visit(this, PROPERTY_DPMES, Date.class, dpmes);
        visitor.visit(this, PROPERTY_DLUO, Date.class, dluo);
        visitor.visit(this, PROPERTY_SPENT_DATE, Date.class, spentDate);
        visitor.visit(this, PROPERTY_QUANTITY, double.class, quantity);
        visitor.visit(this, PROPERTY_PACKAGE_COUNT, int.class, packageCount);
        visitor.visit(this, PROPERTY_SUPPLIER, Supplier.class, supplier);
        visitor.visit(this, PROPERTY_PRODUCT, Product.class, product);
        visitor.visit(this, PROPERTY_DEDICATED_CLIENT, Client.class, dedicatedClient);
        visitor.visit(this, PROPERTY_ANALYZE_FILE, Collection.class, AnalyzeFile.class, analyzeFile);
        visitor.end(this);
    }

    @Override
    public void setNumber(int number) {
        int oldValue = this.number;
        fireOnPreWrite(PROPERTY_NUMBER, oldValue, number);
        this.number = number;
        fireOnPostWrite(PROPERTY_NUMBER, oldValue, number);
    }

    @Override
    public int getNumber() {
        fireOnPreRead(PROPERTY_NUMBER, number);
        int result = this.number;
        fireOnPostRead(PROPERTY_NUMBER, number);
        return result;
    }

    @Override
    public void setEntryDate(Date entryDate) {
        Date oldValue = this.entryDate;
        fireOnPreWrite(PROPERTY_ENTRY_DATE, oldValue, entryDate);
        this.entryDate = entryDate;
        fireOnPostWrite(PROPERTY_ENTRY_DATE, oldValue, entryDate);
    }

    @Override
    public Date getEntryDate() {
        fireOnPreRead(PROPERTY_ENTRY_DATE, entryDate);
        Date result = this.entryDate;
        fireOnPostRead(PROPERTY_ENTRY_DATE, entryDate);
        return result;
    }

    @Override
    public void setDmes(Date dmes) {
        Date oldValue = this.dmes;
        fireOnPreWrite(PROPERTY_DMES, oldValue, dmes);
        this.dmes = dmes;
        fireOnPostWrite(PROPERTY_DMES, oldValue, dmes);
    }

    @Override
    public Date getDmes() {
        fireOnPreRead(PROPERTY_DMES, dmes);
        Date result = this.dmes;
        fireOnPostRead(PROPERTY_DMES, dmes);
        return result;
    }

    @Override
    public void setDpmes(Date dpmes) {
        Date oldValue = this.dpmes;
        fireOnPreWrite(PROPERTY_DPMES, oldValue, dpmes);
        this.dpmes = dpmes;
        fireOnPostWrite(PROPERTY_DPMES, oldValue, dpmes);
    }

    @Override
    public Date getDpmes() {
        fireOnPreRead(PROPERTY_DPMES, dpmes);
        Date result = this.dpmes;
        fireOnPostRead(PROPERTY_DPMES, dpmes);
        return result;
    }

    @Override
    public void setDluo(Date dluo) {
        Date oldValue = this.dluo;
        fireOnPreWrite(PROPERTY_DLUO, oldValue, dluo);
        this.dluo = dluo;
        fireOnPostWrite(PROPERTY_DLUO, oldValue, dluo);
    }

    @Override
    public Date getDluo() {
        fireOnPreRead(PROPERTY_DLUO, dluo);
        Date result = this.dluo;
        fireOnPostRead(PROPERTY_DLUO, dluo);
        return result;
    }

    @Override
    public void setSpentDate(Date spentDate) {
        Date oldValue = this.spentDate;
        fireOnPreWrite(PROPERTY_SPENT_DATE, oldValue, spentDate);
        this.spentDate = spentDate;
        fireOnPostWrite(PROPERTY_SPENT_DATE, oldValue, spentDate);
    }

    @Override
    public Date getSpentDate() {
        fireOnPreRead(PROPERTY_SPENT_DATE, spentDate);
        Date result = this.spentDate;
        fireOnPostRead(PROPERTY_SPENT_DATE, spentDate);
        return result;
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(PROPERTY_QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(PROPERTY_QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(PROPERTY_QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(PROPERTY_QUANTITY, quantity);
        return result;
    }

    @Override
    public void setPackageCount(int packageCount) {
        int oldValue = this.packageCount;
        fireOnPreWrite(PROPERTY_PACKAGE_COUNT, oldValue, packageCount);
        this.packageCount = packageCount;
        fireOnPostWrite(PROPERTY_PACKAGE_COUNT, oldValue, packageCount);
    }

    @Override
    public int getPackageCount() {
        fireOnPreRead(PROPERTY_PACKAGE_COUNT, packageCount);
        int result = this.packageCount;
        fireOnPostRead(PROPERTY_PACKAGE_COUNT, packageCount);
        return result;
    }

    @Override
    public void setSupplier(Supplier supplier) {
        Supplier oldValue = this.supplier;
        fireOnPreWrite(PROPERTY_SUPPLIER, oldValue, supplier);
        this.supplier = supplier;
        fireOnPostWrite(PROPERTY_SUPPLIER, oldValue, supplier);
    }

    @Override
    public Supplier getSupplier() {
        fireOnPreRead(PROPERTY_SUPPLIER, supplier);
        Supplier result = this.supplier;
        fireOnPostRead(PROPERTY_SUPPLIER, supplier);
        return result;
    }

    @Override
    public void setProduct(Product product) {
        Product oldValue = this.product;
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, product);
        this.product = product;
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, product);
    }

    @Override
    public Product getProduct() {
        fireOnPreRead(PROPERTY_PRODUCT, product);
        Product result = this.product;
        fireOnPostRead(PROPERTY_PRODUCT, product);
        return result;
    }

    @Override
    public void setDedicatedClient(Client dedicatedClient) {
        Client oldValue = this.dedicatedClient;
        fireOnPreWrite(PROPERTY_DEDICATED_CLIENT, oldValue, dedicatedClient);
        this.dedicatedClient = dedicatedClient;
        fireOnPostWrite(PROPERTY_DEDICATED_CLIENT, oldValue, dedicatedClient);
    }

    @Override
    public Client getDedicatedClient() {
        fireOnPreRead(PROPERTY_DEDICATED_CLIENT, dedicatedClient);
        Client result = this.dedicatedClient;
        fireOnPostRead(PROPERTY_DEDICATED_CLIENT, dedicatedClient);
        return result;
    }

    @Override
    public void addAnalyzeFile(AnalyzeFile analyzeFile) {
        fireOnPreWrite(PROPERTY_ANALYZE_FILE, null, analyzeFile);
        if (this.analyzeFile == null) {
            this.analyzeFile = new ArrayList<AnalyzeFile>();
        }

        this.analyzeFile.add(analyzeFile);
        fireOnPostWrite(PROPERTY_ANALYZE_FILE, this.analyzeFile.size(), null, analyzeFile);
    }

    @Override
    public void addAllAnalyzeFile(Collection<AnalyzeFile> analyzeFile) {
        if (analyzeFile == null) {
            return;
        }
        for (AnalyzeFile item : analyzeFile) {
            addAnalyzeFile(item);
        }
    }

    @Override
    public void setAnalyzeFile(Collection<AnalyzeFile> analyzeFile) {
        // Copy elements to keep data for fire with new reference
        Collection<AnalyzeFile> oldValue = this.analyzeFile != null ? new ArrayList<AnalyzeFile>(this.analyzeFile) : null;
        fireOnPreWrite(PROPERTY_ANALYZE_FILE, oldValue, analyzeFile);
        this.analyzeFile = analyzeFile;
        fireOnPostWrite(PROPERTY_ANALYZE_FILE, oldValue, analyzeFile);
    }

    @Override
    public void removeAnalyzeFile(AnalyzeFile analyzeFile) {
        fireOnPreWrite(PROPERTY_ANALYZE_FILE, analyzeFile, null);
        if (this.analyzeFile == null || !this.analyzeFile.remove(analyzeFile)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ANALYZE_FILE, this.analyzeFile.size() + 1, analyzeFile, null);
    }

    @Override
    public void clearAnalyzeFile() {
        if (this.analyzeFile == null) {
            return;
        }
        Collection<AnalyzeFile> oldValue = new ArrayList<AnalyzeFile>(this.analyzeFile);
        fireOnPreWrite(PROPERTY_ANALYZE_FILE, oldValue, this.analyzeFile);
        this.analyzeFile.clear();
        fireOnPostWrite(PROPERTY_ANALYZE_FILE, oldValue, this.analyzeFile);
    }

    @Override
    public Collection<AnalyzeFile> getAnalyzeFile() {
        return analyzeFile;
    }

    @Override
    public AnalyzeFile getAnalyzeFileByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(analyzeFile, topiaId);
    }

    @Override
    public int sizeAnalyzeFile() {
        if (analyzeFile == null) {
            return 0;
        }
        return analyzeFile.size();
    }

    @Override
    public boolean isAnalyzeFileEmpty() {
        int size = sizeAnalyzeFile();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //BatchAbstract
