package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AnalyzeDAOAbstract<E extends Analyze> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Analyze.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Analyze;
    }

    public E findByCreationDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_CREATION_DATE, v);
        return result;
    }

    public List<E> findAllByCreationDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_CREATION_DATE, v);
        return result;
    }

    public E findBySentDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SENT_DATE, v);
        return result;
    }

    public List<E> findAllBySentDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SENT_DATE, v);
        return result;
    }

    public E findByReceiptDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_RECEIPT_DATE, v);
        return result;
    }

    public List<E> findAllByReceiptDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_RECEIPT_DATE, v);
        return result;
    }

    public E findBySynthesis(String v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SYNTHESIS, v);
        return result;
    }

    public List<E> findAllBySynthesis(String v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SYNTHESIS, v);
        return result;
    }

    public E findByAnalyzeType(AnalyzeType v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_ANALYZE_TYPE, v);
        return result;
    }

    public List<E> findAllByAnalyzeType(AnalyzeType v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_ANALYZE_TYPE, v);
        return result;
    }

    public E findContainsAnalyzeFile(AnalyzeFile v) throws TopiaException {
        E result = findContains(Analyze.PROPERTY_ANALYZE_FILE, v);
        return result;
    }

    public List<E> findAllContainsAnalyzeFile(AnalyzeFile v) throws TopiaException {
        List<E> result = findAllContains(Analyze.PROPERTY_ANALYZE_FILE, v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_BATCH, v);
        return result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_BATCH, v);
        return result;
    }

    public E findBySupplier(Supplier v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SUPPLIER, v);
        return result;
    }

    public List<E> findAllBySupplier(Supplier v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SUPPLIER, v);
        return result;
    }

    public E findBySynthesisMention(SynthesisMention v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SYNTHESIS_MENTION, v);
        return result;
    }

    public List<E> findAllBySynthesisMention(SynthesisMention v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SYNTHESIS_MENTION, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //AnalyzeDAOAbstract<E extends Analyze>
