/*
 * #%L
 * SGQ :: Business
 * $Id: SgqBusinessConfig.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/SgqBusinessConfig.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.util.Properties;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

/**
 * SGQ Business config.
 * 
 * @author echatellier
 */
public class SgqBusinessConfig {

    protected ApplicationConfig config;

    public SgqBusinessConfig() {
        config = new ApplicationConfig();
        for (SgqBusinessOption o : SgqBusinessOption.values()) {
            if (o.defaultValue != null) {
                config.setDefaultOption(o.key, o.defaultValue);
            }
        }
    }

    public void parse() {
        try {
            config.parse();
        } catch (ArgumentsParserException ex) {
            throw new SgqBusinessException("Can't load configuration", ex);
        }
    }

    public Properties getFlatOptions() {
        return config.getFlatOptions();
    }

    public int getBatchRangeNonBioStart() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_START.key);
    }

    public int getBatchRangeNonBioEnd() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_END.key);
    }

    public int getBatchRangeBioStart() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_START.key);
    }

    public int getBatchRangeBioEnd() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_END.key);
    }

    public String getLabelProductionFilename() {
        return config.getOption(SgqBusinessOption.LABEL_PRODUCTION_FILENAME.key);
    }

    public String getLabelExpeditionFilename() {
        return config.getOption(SgqBusinessOption.LABEL_EXPEDITION_FILENAME.key);
    }

    public int getClientInternalSite1() {
        return config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_SITE1.key);
    }

    public int getClientInternalSite2() {
        return config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_SITE2.key);
    }

    public int getClientInternalSite3() {
        return config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_SITE3.key);
    }

    static enum SgqBusinessOption {

        CONFIG_FILE(ApplicationConfig.CONFIG_FILE_NAME, "sgqweb.properties"),
        SGQ_DIRECTORY("sgq.directory", "${java.io.tmpdir}/sgq"),
        //SGQ_DIRECTORY("sgq.directory", "${user.home}/.sgq"),
        HIBERNATE_DIALECT("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        HIBERNATE_CONNECTION_DRIVER("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        HIBERNATE_CONNECTION_URL("hibernate.connection.url", "jdbc:h2:file:${sgq.directory}/data/sgq"),
        HIBERNATE_CONNETION_USERNAME("hibernate.connection.username", "sa"),
        HIBERNATE_CONNECTION_PASSWORD("hibernate.connection.password", ""),
        // FIXME echatellier 20120829 temp quick solution : to remove
        HIBERNATE_HBM2DLL_AUTO("hibernate.hbm2ddl.auto", "update"),

        CLIENT_INTERNAL_SITE1("client.internal.site1", "99997"),
        CLIENT_INTERNAL_SITE2("client.internal.site2", "99998"),
        CLIENT_INTERNAL_SITE3("client.internal.site3", "99999"),

        BATCH_RANGE_NONBIO_START("batch.range.nonbio.start", "20000"),
        BATCH_RANGE_NONBIO_END("batch.range.nonbio.end", "69999"),
        BATCH_RANGE_BIO_START("batch.range.bio.start", "71000"),
        BATCH_RANGE_BIO_END("batch.range.bio.end", "89999"),

        LABEL_PRODUCTION_FILENAME("label.production.filename", "FIF_HIST.txt"),
        LABEL_EXPEDITION_FILENAME("label.expedition.filename", "FIC_HIST.txt");

        protected String key;
        protected String defaultValue;

        private SgqBusinessOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }
    }
}
