/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.codepoint;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.text.codepoint.Codepoint;
import com.helger.text.codepoint.CodepointIteratorRestricted;
import com.helger.text.codepoint.ICodepointIterator;
import com.helger.text.codepoint.InvalidCharacterException;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractCodepointIterator
implements ICodepointIterator {
    protected int m_nPosition = -1;
    protected int m_nLimit = -1;

    protected AbstractCodepointIterator(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0((int)n, (String)"Position");
        ValueEnforcer.isGE0((int)n2, (String)"Limit");
        this.m_nPosition = n;
        this.m_nLimit = n2;
    }

    protected abstract char get();

    protected abstract char get(int var1);

    @Override
    @CheckForSigned
    public int lastPosition() {
        int n = this.position();
        if (n < 0) {
            return -1;
        }
        return n >= this.limit() ? n : n - 1;
    }

    @Override
    public char @Nullable [] nextChars() {
        if (this.hasNext()) {
            if (this._isNextSurrogate()) {
                char c = this.get();
                if (Character.isHighSurrogate(c) && this.position() < this.limit()) {
                    char c2 = this.get();
                    if (Character.isLowSurrogate(c2)) {
                        return new char[]{c, c2};
                    }
                    throw new InvalidCharacterException(c2);
                }
                if (Character.isLowSurrogate(c) && this.position() > 0) {
                    char c3 = this.get(this.position() - 2);
                    if (Character.isHighSurrogate(c3)) {
                        return new char[]{c, c3};
                    }
                    throw new InvalidCharacterException(c3);
                }
            }
            return new char[]{this.get()};
        }
        return null;
    }

    @Override
    public char @Nullable [] peekChars() {
        return this._peekChars(this.position());
    }

    private char @Nullable [] _peekChars(@Nonnegative int n) {
        if (n < 0 || n >= this.limit()) {
            return null;
        }
        char c = this.get(n);
        if (Character.isHighSurrogate(c) && n < this.limit()) {
            char c2 = this.get(n + 1);
            if (Character.isLowSurrogate(c2)) {
                return new char[]{c, c2};
            }
            throw new InvalidCharacterException(c2);
        }
        if (Character.isLowSurrogate(c) && n > 1) {
            char c3 = this.get(n - 1);
            if (Character.isHighSurrogate(c3)) {
                return new char[]{c3, c};
            }
            throw new InvalidCharacterException(c3);
        }
        return new char[]{c};
    }

    @Override
    public @NonNull Codepoint next() {
        Codepoint codepoint = AbstractCodepointIterator._toCodepoint(this.nextChars());
        if (codepoint == null) {
            throw new NoSuchElementException();
        }
        return codepoint;
    }

    @Override
    public @Nullable Codepoint peek() {
        return AbstractCodepointIterator._toCodepoint(this.peekChars());
    }

    @Override
    public @Nullable Codepoint peek(int n) {
        return AbstractCodepointIterator._toCodepoint(this._peekChars(n));
    }

    private static @Nullable Codepoint _toCodepoint(char @Nullable [] cArray) {
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        return new Codepoint(cArray);
    }

    private void _checkLimit(@Nonnegative int n) {
        if (n < 0 || n > this.limit()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    @Override
    public void position(@Nonnegative int n) {
        this._checkLimit(n);
        this.m_nPosition = n;
    }

    @Override
    @Nonnegative
    public final int position() {
        return this.m_nPosition;
    }

    @Override
    @Nonnegative
    public final int limit() {
        return this.m_nLimit;
    }

    @Override
    @Nonnegative
    public int remaining() {
        return this.m_nLimit - this.position();
    }

    private boolean _isNextSurrogate() {
        if (!this.hasNext()) {
            return false;
        }
        char c = this.get(this.position());
        return Character.isHighSurrogate(c) || Character.isLowSurrogate(c);
    }

    @Override
    public boolean isHigh(@Nonnegative int n) {
        this._checkLimit(n);
        return Character.isHighSurrogate(this.get(n));
    }

    @Override
    public boolean isLow(@Nonnegative int n) {
        this._checkLimit(n);
        return Character.isLowSurrogate(this.get(n));
    }

    @Override
    public @NonNull CodepointIteratorRestricted restrict(@NonNull IntPredicate intPredicate, boolean bl, boolean bl2) {
        return new CodepointIteratorRestricted(this, intPredicate, bl, bl2);
    }
}

