/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.text.TextFormatter;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.IHasText;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class HasTextWithArgs
implements IHasText {
    private final IHasText m_aParentText;
    private final Object[] m_aArgs;

    public HasTextWithArgs(@NonNull IHasText iHasText, Object ... objectArray) {
        this.m_aParentText = (IHasText)ValueEnforcer.notNull((Object)iHasText, (String)"ParentText");
        this.m_aArgs = ValueEnforcer.notEmpty((Object[])objectArray, (String)"Arguments");
    }

    public @NonNull IHasText getParentText() {
        return this.m_aParentText;
    }

    @Nonempty
    @ReturnsMutableCopy
    public @NonNull @Nonempty Object[] getAllArgs() {
        return ArrayHelper.getCopy((Object[])this.m_aArgs);
    }

    @Override
    public @Nullable String getText(@NonNull Locale locale) {
        String string = this.m_aParentText.getText(locale);
        return TextFormatter.getFormattedText((String)string, (Object[])this.m_aArgs);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("parentText", (Object)this.m_aParentText).append("args", this.m_aArgs).getToString();
    }
}

