/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resourceresolver;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.string.StringHelper;
import com.helger.base.url.URLHelper;
import com.helger.io.file.FilenameHelper;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import java.io.File;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultResourceResolver
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceResolver.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);

    protected DefaultResourceResolver() {
    }

    public static boolean isDebugResolve() {
        return CONDLOG.isEnabled();
    }

    public static void setDebugResolve(boolean bl) {
        CONDLOG.setEnabled(bl);
    }

    public static boolean isExplicitJarFileResource(@Nullable String string) {
        return StringHelper.startsWith((String)string, (String)"jar:file:") || StringHelper.startsWith((String)string, (String)"wsjar:file:") || StringHelper.startsWith((String)string, (String)"zip:file:");
    }

    public static @NonNull IReadableResource getResolvedResource(@Nullable String string, @Nullable String string2) {
        return DefaultResourceResolver.getResolvedResource(string, string2, null);
    }

    private static @NonNull ClassPathResource _resolveClassPathResource(String string, String string2, ClassLoader classLoader) {
        String string3 = ClassPathResource.getWithoutClassPathPrefix(string2);
        File file = new File(string3).getParentFile();
        String string4 = FilenameHelper.getCleanPath((String)(file == null ? string : file.getPath() + "/" + string));
        ClassPathResource classPathResource = new ClassPathResource(string4, classLoader);
        CONDLOG.info(() -> "  [ClassPath] resolved base + system to " + String.valueOf(classPathResource));
        return classPathResource;
    }

    private static @NonNull URLResource _resolveJarFileResource(@NonNull String string, @NonNull String string2) throws MalformedURLException {
        File file;
        String string3;
        String string4;
        int n = string2.lastIndexOf("!/");
        if (n < 0) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n + 2);
            string3 = string2.substring(n + 2);
        }
        if (FilenameHelper.startsWithPathSeparatorChar(string3)) {
            string3 = string3.substring(1);
        }
        String string5 = FilenameHelper.getCleanPath((String)((file = new File(string3).getParentFile()) == null ? string : file.getPath() + "/" + string));
        String string6 = string4.endsWith("/") && string5.startsWith("/") ? string4 + string5.substring(1) : string4 + string5;
        URLResource uRLResource = new URLResource(string6);
        CONDLOG.info(() -> "  [JarFile] resolved base + system to " + String.valueOf(uRLResource));
        return uRLResource;
    }

    private static @NonNull URLResource _resolveURLResource(String string, @NonNull URL uRL) throws MalformedURLException {
        String string2 = uRL.getPath();
        String string3 = FilenameHelper.getWithoutPath(string2);
        if (string3 != null && string3.indexOf(46) >= 0) {
            string2 = FilenameHelper.getPath(string2);
        }
        String string4 = FilenameHelper.getCleanConcatenatedUrlPath(string2, string);
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), URLHelper.getURLString((String)string4, (String)uRL.getQuery(), (String)uRL.getRef()));
        URLResource uRLResource = new URLResource(uRL2);
        CONDLOG.info(() -> "  [URL] resolved base + system to " + String.valueOf(uRLResource));
        return uRLResource;
    }

    private static @NonNull FileSystemResource _getChildResource(@Nullable File file, @NonNull File file2) {
        if (file == null) {
            return new FileSystemResource(file2);
        }
        File file3 = file.isDirectory() ? file : file.getParentFile();
        File file4 = new File(file3, file2.getPath());
        return new FileSystemResource(file4);
    }

    public static @NonNull IReadableResource getResolvedResource(@Nullable String string, @Nullable String string2, @Nullable ClassLoader classLoader) {
        if (StringHelper.isEmpty((String)string) && StringHelper.isEmpty((String)string2)) {
            throw new IllegalArgumentException("Both systemID and baseURI are null!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to resolve resource '" + string + "' from base '" + string2 + (String)(classLoader == null ? "'" : "' with ClassLoader " + String.valueOf(classLoader)));
        }
        CONDLOG.info(() -> "doStandardResourceResolving ('" + string + "', '" + string2 + "', " + String.valueOf(classLoader) + ")");
        URL uRL = URLHelper.getAsURL((String)string, (boolean)false);
        if (uRL != null && !uRL.getProtocol().equals("file")) {
            URLResource uRLResource = new URLResource(uRL);
            CONDLOG.info(() -> "  resolved system URL to " + String.valueOf(uRLResource));
            return uRLResource;
        }
        if (ClassPathResource.isExplicitClassPathResource(string2)) {
            return DefaultResourceResolver._resolveClassPathResource(string, string2, classLoader);
        }
        if (DefaultResourceResolver.isExplicitJarFileResource(string2)) {
            try {
                return DefaultResourceResolver._resolveJarFileResource(string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        URL uRL2 = URLHelper.getAsURL((String)string2);
        if (uRL2 != null && !uRL2.getProtocol().equals("file")) {
            try {
                return DefaultResourceResolver._resolveURLResource(string, uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        File file = uRL2 != null ? URLHelper.getAsFile((URL)uRL2) : (string2 != null ? new File(string2) : null);
        if (StringHelper.isEmpty((String)string)) {
            FileSystemResource fileSystemResource = new FileSystemResource(file);
            CONDLOG.info(() -> "  resolved base URL to " + String.valueOf(fileSystemResource));
            return fileSystemResource;
        }
        File file2 = uRL != null ? URLHelper.getAsFile((URL)uRL) : new File(string);
        if (file2.isAbsolute()) {
            FileSystemResource fileSystemResource;
            FileSystemResource fileSystemResource2 = new FileSystemResource(file2);
            if (!fileSystemResource2.exists() && (fileSystemResource = DefaultResourceResolver._getChildResource(file, file2)).exists()) {
                CONDLOG.info(() -> "  resolved base + system URL to " + String.valueOf(fileSystemResource));
                return fileSystemResource;
            }
            CONDLOG.info(() -> "  resolved system URL to " + String.valueOf(fileSystemResource2));
            return fileSystemResource2;
        }
        FileSystemResource fileSystemResource = DefaultResourceResolver._getChildResource(file, file2);
        CONDLOG.info(() -> "  resolved base + system URL to " + String.valueOf(fileSystemResource));
        return fileSystemResource;
    }
}

