/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import com.helger.io.file.PathHelper;
import com.helger.io.stream.StreamHelperExt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class SimpleFileIO {
    private static final SimpleFileIO INSTANCE = new SimpleFileIO();

    private SimpleFileIO() {
    }

    public static byte @Nullable [] getAllFileBytes(@Nullable File file) {
        return file == null ? null : StreamHelper.getAllBytes((InputStream)FileHelper.getInputStream(file));
    }

    public static byte @Nullable [] getAllFileBytes(@Nullable Path path) {
        try {
            return path == null ? null : Files.readAllBytes(path);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static List<String> readAllLines(@NonNull Path path, @NonNull Charset charset) throws IOException {
        try (NonBlockingBufferedReader nonBlockingBufferedReader = PathHelper.getBufferedReader(path, charset);){
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((object = nonBlockingBufferedReader.readLine()) != null) {
                arrayList.add((String)object);
            }
            object = arrayList;
            return object;
        }
    }

    public static @Nullable String getFileAsString(@Nullable File file, @NonNull Charset charset) {
        return file == null ? null : StreamHelper.getAllBytesAsString((InputStream)FileHelper.getInputStream(file), (Charset)charset);
    }

    public static @Nullable ICommonsList<String> getAllFileLines(@Nullable File file, @NonNull Charset charset) {
        return file == null ? null : StreamHelperExt.readStreamLines(FileHelper.getInputStream(file), charset);
    }

    public static void readFileLines(@Nullable File file, @NonNull Charset charset, @NonNull List<String> list) {
        if (file != null) {
            StreamHelperExt.readStreamLines((InputStream)FileHelper.getInputStream(file), charset, list);
        }
    }

    public static void readFileLines(@Nullable File file, @NonNull Charset charset, @NonNull Consumer<? super String> consumer) {
        if (file != null) {
            StreamHelperExt.readStreamLines((InputStream)FileHelper.getInputStream(file), charset, consumer);
        }
    }

    public static @NonNull ESuccess writeFile(@NonNull File file, byte @NonNull [] byArray) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream((OutputStream)fileOutputStream, (byte[])byArray);
    }

    public static @NonNull ESuccess writeFile(@NonNull File file, byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream((OutputStream)fileOutputStream, (byte[])byArray, (int)n, (int)n2);
    }

    public static @NonNull ESuccess writeFile(@NonNull File file, @NonNull String string, @NonNull Charset charset) {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file);
        return fileOutputStream == null ? ESuccess.FAILURE : StreamHelper.writeStream((OutputStream)fileOutputStream, (String)string, (Charset)charset);
    }
}

