/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.MapEntry;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class SingleElementMap<KEYTYPE, VALUETYPE>
implements ICommonsMap<KEYTYPE, VALUETYPE> {
    private boolean m_bHasElement = false;
    private KEYTYPE m_aKey;
    private VALUETYPE m_aValue;

    public SingleElementMap() {
    }

    public SingleElementMap(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.put(KEYTYPE, VALUETYPE);
    }

    @ReturnsMutableCopy
    public @NonNull SingleElementMap<KEYTYPE, VALUETYPE> getClone() {
        return this.m_bHasElement ? new SingleElementMap<KEYTYPE, VALUETYPE>(this.m_aKey, this.m_aValue) : new SingleElementMap<KEYTYPE, VALUETYPE>();
    }

    @Override
    public void clear() {
        this.m_bHasElement = false;
        this.m_aKey = null;
        this.m_aValue = null;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        KEYTYPE KEYTYPE = this.m_aKey;
        return this.m_bHasElement && EqualsHelper.equals(KEYTYPE, (Object)object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        VALUETYPE VALUETYPE = this.m_aValue;
        return this.m_bHasElement && EqualsHelper.equals(VALUETYPE, (Object)object);
    }

    @Override
    public @Nullable VALUETYPE get(@Nullable Object object) {
        return this.containsKey(object) ? (VALUETYPE)this.m_aValue : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_bHasElement;
    }

    @Override
    public final @Nullable VALUETYPE put(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        VALUETYPE VALUETYPE2 = null;
        KEYTYPE KEYTYPE2 = this.m_aKey;
        if (EqualsHelper.equals(KEYTYPE, KEYTYPE2)) {
            VALUETYPE2 = this.m_aValue;
        } else {
            this.m_aKey = KEYTYPE;
        }
        this.m_aValue = VALUETYPE;
        this.m_bHasElement = true;
        return VALUETYPE2;
    }

    @Override
    public void putAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null && !map.isEmpty()) {
            if (map.size() != 1) {
                throw new IllegalArgumentException("Only maps with exactly one element are allowed!");
            }
            Map.Entry<KEYTYPE, VALUETYPE> entry = map.entrySet().iterator().next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public @Nullable VALUETYPE remove(@Nullable Object object) {
        if (!this.containsKey(object)) {
            return null;
        }
        VALUETYPE VALUETYPE = this.m_aValue;
        this.m_bHasElement = false;
        this.m_aValue = null;
        this.m_aKey = null;
        return VALUETYPE;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_bHasElement ? 1 : 0;
    }

    @Override
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public @NonNull Set<KEYTYPE> keySet() {
        return this.m_bHasElement ? new CommonsHashSet<KEYTYPE>(this.m_aKey) : new CommonsHashSet();
    }

    @Override
    @ReturnsImmutableObject
    public @NonNull Collection<VALUETYPE> values() {
        return this.m_bHasElement ? new CommonsArrayList<VALUETYPE>(this.m_aValue) : new CommonsArrayList();
    }

    @Override
    @ReturnsMutableCopy
    @CodingStyleguideUnaware
    public @NonNull Set<Map.Entry<KEYTYPE, VALUETYPE>> entrySet() {
        CommonsHashSet<int> commonsHashSet = new CommonsHashSet<int>(this.size());
        if (this.m_bHasElement) {
            commonsHashSet.add(new MapEntry<KEYTYPE, VALUETYPE>(this.m_aKey, this.m_aValue));
        }
        return commonsHashSet;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementMap singleElementMap = (SingleElementMap)object;
        KEYTYPE KEYTYPE = this.m_aKey;
        VALUETYPE VALUETYPE = this.m_aValue;
        return this.m_bHasElement == singleElementMap.m_bHasElement && EqualsHelper.equals(KEYTYPE, singleElementMap.m_aKey) && EqualsHelper.equals(VALUETYPE, singleElementMap.m_aValue);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bHasElement).append(this.m_aKey).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hasElement", this.m_bHasElement).append("key", this.m_aKey).append("value", this.m_aValue).getToString();
    }
}

