/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.url;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.url.CURL;
import com.helger.base.wrapper.IMutableWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class URLHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLHelper.class);
    private static final boolean DEBUG_GET_IS = false;
    private static final URLHelper INSTANCE = new URLHelper();

    private URLHelper() {
    }

    public static boolean equalURLs(@Nullable URL uRL3, @Nullable URL uRL4) {
        return EqualsHelper.equalsCustom(uRL3, uRL4, (uRL, uRL2) -> uRL.toExternalForm().equals(uRL2.toExternalForm()));
    }

    public static @Nullable String getURLString(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        boolean bl = StringHelper.isNotEmpty(string);
        boolean bl2 = StringHelper.isNotEmpty(string2);
        boolean bl3 = StringHelper.isNotEmpty(string3);
        if (GlobalDebug.isDebugMode()) {
            if (bl) {
                if (string.contains(CURL.QUESTIONMARK_STR)) {
                    LOGGER.warn("Path contains the question mark ('?') character: '" + string + "'");
                }
                if (string.contains(CURL.AMPERSAND_STR)) {
                    LOGGER.warn("Path contains the ampersand ('&') character: '" + string + "'");
                }
                if (string.contains(CURL.HASH_STR)) {
                    LOGGER.warn("Path contains the hash ('#') character: '" + string + "'");
                }
            }
            if (bl2 && string2.contains(CURL.QUESTIONMARK_STR)) {
                LOGGER.warn("Query parameters contain the question mark ('?') character: '" + string2 + "'");
            }
            if (bl3 && string3.contains(CURL.HASH_STR)) {
                LOGGER.warn("Anchor contains the hash ('#') character: '" + string3 + "'");
            }
        }
        if (!bl2 && !bl3) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(string);
        }
        if (bl2) {
            boolean bl4;
            boolean bl5 = bl4 = stringBuilder.indexOf(CURL.QUESTIONMARK_STR) >= 0;
            if (bl4) {
                char c = StringHelper.getLastChar(stringBuilder);
                if (c != '?' && c != '&') {
                    stringBuilder.append('&');
                }
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append(string2);
        }
        if (bl3) {
            if (StringHelper.getLastChar(stringBuilder) != '#') {
                stringBuilder.append('#');
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static @Nullable URL getAsURL(@Nullable String string, boolean bl) {
        block3: {
            if (StringHelper.isNotEmpty(string)) {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!bl || !GlobalDebug.isDebugMode()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + string + "' to a URL!");
                }
            }
        }
        return null;
    }

    public static @Nullable URL getAsURL(@Nullable String string) {
        return URLHelper.getAsURL(string, true);
    }

    public static @Nullable URL getAsURL(@Nullable URI uRI) {
        block3: {
            if (uRI != null) {
                try {
                    return uRI.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!GlobalDebug.isDebugMode()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + String.valueOf(uRI) + "' to a URL!");
                }
            }
        }
        return null;
    }

    public static @Nullable URI getAsURI(@Nullable String string) {
        block3: {
            if (StringHelper.isNotEmpty(string)) {
                try {
                    return new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!GlobalDebug.isDebugMode()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + string + "' to a URI!");
                }
            }
        }
        return null;
    }

    public static @Nullable URI getAsURI(@Nullable URL uRL) {
        block3: {
            if (uRL != null) {
                try {
                    return uRL.toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!GlobalDebug.isDebugMode()) break block3;
                    LOGGER.warn("Debug warn: failed to convert '" + String.valueOf(uRL) + "' to a URI!");
                }
            }
        }
        return null;
    }

    private static boolean _isTimeout(IOException iOException) {
        return iOException instanceof SocketTimeoutException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable InputStream getInputStream(@NonNull URL uRL, @CheckForSigned int n, @CheckForSigned int n2, @Nullable Consumer<? super URLConnection> consumer, @Nullable IMutableWrapper<IOException> iMutableWrapper) {
        ValueEnforcer.notNull(uRL, "URL");
        HttpURLConnection httpURLConnection = null;
        try {
            JarEntry jarEntry;
            Object object;
            URLConnection uRLConnection = uRL.openConnection();
            if (n >= 0) {
                uRLConnection.setConnectTimeout(n);
            }
            if (n2 >= 0) {
                uRLConnection.setReadTimeout(n2);
            }
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                httpURLConnection = object;
            }
            uRLConnection.setUseCaches(false);
            if (consumer != null) {
                consumer.accept(uRLConnection);
            }
            if (uRLConnection instanceof JarURLConnection && (jarEntry = ((JarURLConnection)(object = (JarURLConnection)uRLConnection)).getJarEntry()) != null) {
                if (jarEntry.isDirectory()) {
                    return null;
                }
                if (jarEntry.getSize() == 0L && jarEntry.getCrc() == 0L) {
                    LOGGER.warn("Heuristically determined " + String.valueOf(uRL) + " to be a directory!");
                    return null;
                }
            }
            object = uRLConnection.getInputStream();
            return object;
        }
        catch (IOException iOException) {
            if (iMutableWrapper != null) {
                iMutableWrapper.set(iOException);
            } else if (URLHelper._isTimeout(iOException)) {
                LOGGER.warn("Timeout to open input stream for '" + String.valueOf(uRL) + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            } else {
                LOGGER.warn("Failed to open input stream for '" + String.valueOf(uRL) + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            }
            if (httpURLConnection != null) {
                InputStream inputStream = null;
                try {
                    inputStream = httpURLConnection.getErrorStream();
                    if (inputStream != null) {
                        byte[] byArray = new byte[1024];
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                }
                catch (IOException iOException2) {
                    LOGGER.warn("Failed to consume error stream for '" + String.valueOf(uRL) + "': " + iOException2.getClass().getName() + " - " + iOException2.getMessage());
                }
                finally {
                    StreamHelper.close(inputStream);
                }
            }
            return null;
        }
    }

    public static @NonNull File getAsFile(@NonNull URL uRL) {
        File file;
        String string;
        ValueEnforcer.notNull(uRL, "URL");
        ValueEnforcer.isEqual("file", uRL.getProtocol(), () -> "Not a file URL: " + uRL.toExternalForm());
        try {
            string = uRL.toURI().getSchemeSpecificPart();
            file = new File(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            string = uRL.getPath();
            file = new File(string);
        }
        if (string.length() > 0 && (string.charAt(0) == '/' || string.charAt(0) == '\\')) {
            file = file.getAbsoluteFile();
        }
        return file;
    }

    public static @Nullable File getAsFileOrNull(@Nullable URL uRL) {
        if (uRL != null) {
            try {
                return URLHelper.getAsFile(uRL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static @Nullable URL getClassPathURL(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Path");
        URL uRL = ClassLoaderHelper.getResource(ClassLoaderHelper.getDefaultClassLoader(), string);
        if (uRL == null && (uRL = ClassHelper.getResource(URLHelper.class, string)) == null) {
            uRL = ClassLoaderHelper.getResource(ClassLoaderHelper.getSystemClassLoader(), string);
        }
        return uRL;
    }

    public static boolean isClassPathURLExisting(@NonNull @Nonempty String string) {
        return URLHelper.getClassPathURL(string) != null;
    }

    public static boolean isClassPathURLExisting(@NonNull @Nonempty String string, @NonNull ClassLoader classLoader) {
        return ClassLoaderHelper.getResource(classLoader, string) != null;
    }
}

