/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.io.EAppend;
import com.helger.base.io.iface.IHasOutputStreamAndWriter;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;

public class ByteArrayOutputStreamProvider
implements IHasOutputStreamAndWriter {
    private final NonBlockingByteArrayOutputStream m_aOS = new NonBlockingByteArrayOutputStream();

    @Override
    public final @NonNull NonBlockingByteArrayOutputStream getOutputStream(@NonNull EAppend eAppend) {
        if (eAppend.isTruncate()) {
            this.m_aOS.reset();
        }
        return this.m_aOS;
    }

    @Override
    public final boolean isWriteMultiple() {
        return true;
    }

    @ReturnsMutableCopy
    public final byte @NonNull [] getBytes() {
        return this.m_aOS.toByteArray();
    }

    public final @NonNull String getAsString(@NonNull Charset charset) {
        return this.m_aOS.getAsString(charset);
    }

    public String toString() {
        return new ToStringGenerator(this).append("os", this.m_aOS).getToString();
    }
}

