/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.mysql;

import com.googlecode.flyway.core.dbsupport.Delimiter;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.regex.Pattern;

public class MySQLSqlStatementBuilder
extends SqlStatementBuilder {
    private static final String DELIMITER_KEYWORD = "DELIMITER";
    private final String[] charSets = new String[]{"ARMSCII8", "ASCII", "BIG5", "BINARY", "CP1250", "CP1251", "CP1256", "CP1257", "CP850", "CP852", "CP866", "CP932", "DEC8", "EUCJPMS", "EUCKR", "GB2312", "GBK", "GEOSTD8", "GREEK", "HEBREW", "HP8", "KEYBCS2", "KOI8R", "KOI8U", "LATIN1", "LATIN2", "LATIN5", "LATIN7", "MACCE", "MACROMAN", "SJIS", "SWE7", "TIS620", "UCS2", "UJIS", "UTF8"};
    private boolean isInMultiLineCommentDirective = false;

    public Delimiter extractNewDelimiterFromLine(String line) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return null;
    }

    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return delimiter;
    }

    public boolean isCommentDirective(String line) {
        if (line.matches("^" + Pattern.quote("/*!") + "\\d{5} .*" + Pattern.quote("*/") + ";?")) {
            return true;
        }
        if (this.isInMultiLineCommentDirective && line.matches(".*" + Pattern.quote("*/") + ";?")) {
            this.isInMultiLineCommentDirective = false;
            return true;
        }
        if (line.matches("^" + Pattern.quote("/*!") + "\\d{5} .*")) {
            this.isInMultiLineCommentDirective = true;
            return true;
        }
        return this.isInMultiLineCommentDirective;
    }

    public boolean isSingleLineComment(String line) {
        return line.startsWith("--") || line.startsWith("#");
    }

    protected String removeEscapedQuotes(String token) {
        String noEscapedBackslashes = StringUtils.replaceAll(token, "\\\\", "");
        String noBackslashEscapes = StringUtils.replaceAll(StringUtils.replaceAll(noEscapedBackslashes, "\\'", ""), "\\\"", "");
        return StringUtils.replaceAll(noBackslashEscapes, "''", "");
    }

    protected String removeCharsetCasting(String token) {
        if (token.startsWith("_")) {
            for (String charSet : this.charSets) {
                String cast = "_" + charSet;
                if (!token.startsWith(cast)) continue;
                return token.substring(cast.length());
            }
        }
        return token;
    }

    protected String extractAlternateOpenQuote(String token) {
        if (token.startsWith("\"")) {
            return "\"";
        }
        if (token.startsWith("B'") && token.length() > 2) {
            return "B'";
        }
        if (token.startsWith("X'") && token.length() > 2) {
            return "X'";
        }
        return null;
    }

    protected String computeAlternateCloseQuote(String openQuote) {
        if ("B'".equals(openQuote) || "X'".equals(openQuote)) {
            return "'";
        }
        return openQuote;
    }
}

