/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderReplacer {
    public static final PlaceholderReplacer NO_PLACEHOLDERS = new PlaceholderReplacer(new HashMap<String, String>(), "", "");
    private final Map<String, String> placeholders;
    private final String placeholderPrefix;
    private final String placeholderSuffix;

    public PlaceholderReplacer(Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        this.placeholders = placeholders;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public String replacePlaceholders(String input) {
        String noPlaceholders = input;
        for (String placeholder : this.placeholders.keySet()) {
            String searchTerm = this.placeholderPrefix + placeholder + this.placeholderSuffix;
            noPlaceholders = StringUtils.replaceAll(noPlaceholders, searchTerm, this.placeholders.get(placeholder));
        }
        this.checkForUnmatchedPlaceholderExpression(noPlaceholders);
        return noPlaceholders;
    }

    private void checkForUnmatchedPlaceholderExpression(String input) {
        String regex = Pattern.quote(this.placeholderPrefix) + "(.+?)" + Pattern.quote(this.placeholderSuffix);
        Matcher matcher = Pattern.compile(regex).matcher(input);
        TreeSet<String> unmatchedPlaceHolderExpressions = new TreeSet<String>();
        while (matcher.find()) {
            unmatchedPlaceHolderExpressions.add(matcher.group());
        }
        if (!unmatchedPlaceHolderExpressions.isEmpty()) {
            throw new FlywayException("No value provided for placeholder expressions: " + StringUtils.collectionToCommaDelimitedString(unmatchedPlaceHolderExpressions) + ".  Check your configuration!");
        }
    }
}

