/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.mysql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLSchema;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLSqlStatementBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;

public class MySQLDbSupport
extends DbSupport {
    public MySQLDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/mysql/";
    }

    public String getCurrentUserFunction() {
        return "SUBSTRING_INDEX(USER(),'@',1)";
    }

    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.getConnection().getCatalog();
    }

    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        if ("".equals(schema.getName())) {
            String newDb = this.quote(UUID.randomUUID().toString());
            this.jdbcTemplate.execute("CREATE SCHEMA " + newDb, new Object[0]);
            this.jdbcTemplate.execute("USE " + newDb, new Object[0]);
            this.jdbcTemplate.execute("DROP SCHEMA " + newDb, new Object[0]);
        } else {
            this.jdbcTemplate.execute("USE " + schema, new Object[0]);
        }
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public SqlStatementBuilder createSqlStatementBuilder() {
        return new MySQLSqlStatementBuilder();
    }

    public String doQuote(String identifier) {
        return "`" + identifier + "`";
    }

    public Schema getSchema(String name) {
        return new MySQLSchema(this.jdbcTemplate, this, name);
    }

    public boolean catalogIsSchema() {
        return true;
    }
}

