/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.jdbc;

import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverDataSource
implements DataSource {
    private Driver driver;
    private String url;
    private String user;
    private String password;
    private String[] initSqls = new String[0];

    public DriverDataSource() {
    }

    public DriverDataSource(Driver driver, String url, String user, String password, String ... initSqls) throws FlywayException {
        this.configure(driver, url, user, password, initSqls);
    }

    public DriverDataSource(String driverClass, String url, String user, String password, String ... initSqls) throws FlywayException {
        Driver driver;
        try {
            driver = (Driver)ClassUtils.instantiate(driverClass);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate jdbc driver: " + driverClass);
        }
        this.configure(driver, url, user, password, initSqls);
    }

    private void configure(Driver driver, String url, String user, String password, String ... initSqls) throws FlywayException {
        this.driver = driver;
        if (!url.toLowerCase().startsWith("jdbc:")) {
            throw new FlywayException("Invalid jdbc url (should start with jdbc:) : " + url);
        }
        this.url = url;
        this.user = user;
        this.password = password;
        this.initSqls = initSqls;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getInitSqls() {
        return this.initSqls;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriver(this.getUser(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriver(username, password);
    }

    protected Connection getConnectionFromDriver(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        Connection connection = this.driver.connect(this.url, props);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(connection){

            protected void setNull(PreparedStatement preparedStatement, int parameterIndex) throws SQLException {
            }
        };
        for (String initSql : this.initSqls) {
            jdbcTemplate.executeStatement(initSql);
        }
        return connection;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("getLogWriter");
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return DataSource.class.equals(iface);
    }
}

