/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;
import com.googlecode.flyway.core.util.jdbc.RowMapper;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTable.class);
    private final DbSupport dbSupport;
    private final String schema;
    private final String table;
    private final Connection connection;
    private final JdbcTemplate jdbcTemplate;

    public MetaDataTable(Connection connection, DbSupport dbSupport, String schema, String table) {
        this.connection = connection;
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.dbSupport = dbSupport;
        this.schema = schema;
        this.table = table;
    }

    private boolean exists() {
        try {
            return this.dbSupport.tableExists(this.schema, this.table);
        }
        catch (SQLException e) {
            throw new FlywayException("Error checking whether table '" + this.table + "' exists in schema '" + this.schema + "'", e);
        }
    }

    private void create() {
        LOG.info((Object)("Creating Metadata table: " + this.table + " (Schema: " + this.schema + ")"));
        final String createMetaDataTableScriptSource = new ClassPathResource(this.dbSupport.getScriptLocation() + "createMetaDataTable.sql").loadAsString("UTF-8");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", this.schema);
        placeholders.put("table", this.table);
        final PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(placeholders, "${", "}");
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                SqlScript sqlScript = new SqlScript(createMetaDataTableScriptSource, placeholderReplacer);
                sqlScript.execute(MetaDataTable.this.jdbcTemplate);
                return null;
            }
        });
        LOG.debug((Object)("Metadata table created: " + this.table + " (Schema: " + this.schema + ")"));
    }

    public void createIfNotExists() {
        if (!this.exists()) {
            this.create();
        }
    }

    public void lock() {
        try {
            this.dbSupport.lockTable(this.schema, this.table);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to lock metadata table '" + this.table + "' in schema '" + this.schema + "'", e);
        }
    }

    public void insert(MetaDataTableRow metaDataTableRow) {
        try {
            this.jdbcTemplate.update("UPDATE " + this.schema + "." + this.table + " SET current_version=" + this.dbSupport.getBooleanFalse(), new Object[0]);
            String version = metaDataTableRow.getVersion().toString();
            String description = metaDataTableRow.getDescription();
            String state = metaDataTableRow.getState().name();
            String migrationType = metaDataTableRow.getMigrationType().name();
            Integer checksum = metaDataTableRow.getChecksum();
            String scriptName = metaDataTableRow.getScript();
            Integer executionTime = metaDataTableRow.getExecutionTime();
            this.jdbcTemplate.update("INSERT INTO " + this.schema + "." + this.table + " (version, description, type, script, checksum, installed_by, execution_time, state, current_version)" + " VALUES (?, ?, ?, ?, ?, " + this.dbSupport.getCurrentUserFunction() + ", ?, ?, " + this.dbSupport.getBooleanTrue() + ")", version, description, migrationType, scriptName, checksum, executionTime, state);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to insert metadata table row for version " + metaDataTableRow.getVersion().toString(), e);
        }
    }

    private boolean hasRows() {
        if (!this.exists()) {
            return false;
        }
        try {
            return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.schema + "." + this.table, new String[0]) > 0;
        }
        catch (SQLException e) {
            throw new FlywayException("Error checking if the metadata table has at least one row", e);
        }
    }

    public MetaDataTableRow latestAppliedMigration() {
        if (!this.hasRows()) {
            return null;
        }
        String query = this.getSelectStatement() + " where current_version=" + this.dbSupport.getBooleanTrue();
        try {
            List<MetaDataTableRow> metaDataTableRows = this.jdbcTemplate.query(query, new MetaDataTableRowMapper());
            if (metaDataTableRows.isEmpty()) {
                throw new FlywayException("Cannot determine latest applied migration. Was the metadata table manually modified?");
            }
            return metaDataTableRows.get(0);
        }
        catch (SQLException e) {
            throw new FlywayException("Error determining latest applied migration", e);
        }
    }

    public List<MetaDataTableRow> allAppliedMigrations() {
        if (!this.exists()) {
            return new ArrayList<MetaDataTableRow>();
        }
        String query = this.getSelectStatement();
        try {
            List<MetaDataTableRow> metaDataTableRows = this.jdbcTemplate.query(query, new MetaDataTableRowMapper());
            Collections.sort(metaDataTableRows);
            return metaDataTableRows;
        }
        catch (SQLException e) {
            throw new FlywayException("Error while retrieving the list of applied migrations", e);
        }
    }

    private String getSelectStatement() {
        return "select version as VERSION, description as DESCRIPTION, type as TYPE, script as SCRIPT, checksum as CHECKSUM, installed_on as INSTALLED_ON, execution_time as EXECUTION_TIME, state as STATE from " + this.schema + "." + this.table;
    }

    private Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    public MigrationState getCurrentSchemaState() {
        MetaDataTableRow latestAppliedMigration = this.latestAppliedMigration();
        if (latestAppliedMigration == null) {
            return MigrationState.SUCCESS;
        }
        return latestAppliedMigration.getState();
    }

    public SchemaVersion getCurrentSchemaVersion() {
        MetaDataTableRow latestAppliedMigration = this.latestAppliedMigration();
        if (latestAppliedMigration == null) {
            return SchemaVersion.EMPTY;
        }
        return latestAppliedMigration.getVersion();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetaDataTableRowMapper
    implements RowMapper<MetaDataTableRow> {
        private MetaDataTableRowMapper() {
        }

        @Override
        public MetaDataTableRow mapRow(ResultSet rs) throws SQLException {
            SchemaVersion version = new SchemaVersion(rs.getString("VERSION"));
            String description = rs.getString("DESCRIPTION");
            MigrationType migrationType = MigrationType.valueOf(rs.getString("TYPE"));
            String script = rs.getString("SCRIPT");
            Integer checksum = MetaDataTable.this.toInteger((Number)rs.getObject("CHECKSUM"));
            Timestamp installedOn = rs.getTimestamp("INSTALLED_ON");
            Integer executionTime = MetaDataTable.this.toInteger((Number)rs.getObject("EXECUTION_TIME"));
            MigrationState migrationState = MigrationState.valueOf(rs.getString("STATE"));
            return new MetaDataTableRow(version, description, migrationType, script, checksum, installedOn, executionTime, migrationState);
        }
    }
}

