/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.db2.DB2DbSupport;
import com.googlecode.flyway.core.dbsupport.derby.DerbyDbSupport;
import com.googlecode.flyway.core.dbsupport.h2.H2DbSupport;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlDbSupport;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLDbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleDbSupport;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLDbSupport;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerDbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbSupportFactory {
    private static final Log LOG = LogFactory.getLog(DbSupportFactory.class);

    private DbSupportFactory() {
    }

    public static DbSupport createDbSupport(Connection connection) {
        String databaseProductName = DbSupportFactory.getDatabaseProductName(connection);
        if (databaseProductName == null) {
            throw new FlywayException("Unable to determine database. Product name is null.");
        }
        LOG.debug((Object)("Database: " + databaseProductName));
        if ("Apache Derby".equals(databaseProductName)) {
            return new DerbyDbSupport(connection);
        }
        if ("H2".equals(databaseProductName)) {
            return new H2DbSupport(connection);
        }
        if ("HSQL Database Engine".equals(databaseProductName) || "Google SQL Service/HSQL Database Engine".equals(databaseProductName)) {
            return new HsqlDbSupport(connection);
        }
        if ("Microsoft SQL Server".equals(databaseProductName)) {
            return new SQLServerDbSupport(connection);
        }
        if (databaseProductName.contains("MySQL")) {
            return new MySQLDbSupport(connection);
        }
        if ("Oracle".equals(databaseProductName)) {
            return new OracleDbSupport(connection);
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            return new PostgreSQLDbSupport(connection);
        }
        if (databaseProductName.startsWith("DB2")) {
            return new DB2DbSupport(connection);
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }

    private static String getDatabaseProductName(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                throw new FlywayException("Unable to read database metadata while it is null!");
            }
            return databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new FlywayException("Error while determining database product name", e);
        }
    }
}

