/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.TypeEnv;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NewTypeInference
implements CompilerPass {
    static final DiagnosticType MISTYPED_ASSIGN_RHS = DiagnosticType.warning("JSC_MISTYPED_ASSIGN_RHS", "The right side in the assignment is not a subtype of the left side.\nleft side  : {0}\nright side : {1}\n");
    static final DiagnosticType INVALID_OPERAND_TYPE = DiagnosticType.warning("JSC_INVALID_OPERAND_TYPE", "Invalid type(s) for operator {0}.\nexpected : {1}\nfound    : {2}\n");
    static final DiagnosticType RETURN_NONDECLARED_TYPE = DiagnosticType.warning("JSC_RETURN_NONDECLARED_TYPE", "Returned type does not match declared return type.\n declared : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_INFERRED_RETURN_TYPE = DiagnosticType.warning("JSC_INVALID_INFERRED_RETURN_TYPE", "Function called in context that expects incompatible type.\n expected : {0}\nfound    : {1}\n");
    static final DiagnosticType INVALID_ARGUMENT_TYPE = DiagnosticType.warning("JSC_INVALID_ARGUMENT_TYPE", "Invalid type for parameter {0} of function {1}.\n expected : {2}\nfound    : {3}\n");
    static final DiagnosticType CROSS_SCOPE_GOTCHA = DiagnosticType.warning("JSC_CROSS_SCOPE_GOTCHA", "You thought we weren't going to notice? Guess again.\nVariable {0} typed inconsistently across scopes.\n In outer scope : {1}\nIn inner scope : {2}\n");
    static final DiagnosticType POSSIBLY_INEXISTENT_PROPERTY = DiagnosticType.warning("JSC_POSSIBLY_INEXISTENT_PROPERTY", "Property {0} may not be present on {1}.");
    static final DiagnosticType PROPERTY_ACCESS_ON_NONOBJECT = DiagnosticType.warning("JSC_PROPERTY_ACCESS_ON_NONOBJECT", "Cannot access property {0} of non-object type {1}.");
    static final DiagnosticType CALL_FUNCTION_WITH_BOTTOM_FORMAL = DiagnosticType.warning("JSC_CALL_FUNCTION_WITH_BOTTOM_FORMAL", "The #{0} formal parameter of this function has an invalid type, which prevents the function from being called.\nPlease change the type.");
    static final DiagnosticType NOT_UNIQUE_INSTANTIATION = DiagnosticType.warning("JSC_NOT_UNIQUE_INSTANTIATION", "Illegal instantiation for type variable {0}.\nYou can only specify one type. Found {1}.");
    static final DiagnosticType FAILED_TO_UNIFY = DiagnosticType.warning("JSC_FAILED_TO_UNIFY", "Could not instantiate type {0} with {1}.");
    static final DiagnosticType NON_NUMERIC_ARRAY_INDEX = DiagnosticType.warning("JSC_NON_NUMERIC_ARRAY_INDEX", "Expected numeric array index but found {0}.");
    static final DiagnosticType INVALID_OBJLIT_PROPERTY_TYPE = DiagnosticType.warning("JSC_INVALID_OBJLIT_PROPERTY_TYPE", "Object-literal property declared as {0} but has type {1}.");
    static final DiagnosticType FORIN_EXPECTS_OBJECT = DiagnosticType.warning("JSC_FORIN_EXPECTS_OBJECT", "For/in expects an object, found type {0}.");
    static final DiagnosticType FORIN_EXPECTS_STRING_KEY = DiagnosticType.warning("JSC_FORIN_EXPECTS_STRING_KEY", "For/in creates string keys, but variable has declared type {1}.");
    static final DiagnosticType CONST_REASSIGNED = DiagnosticType.warning("JSC_CONST_REASSIGNED", "Cannot change the value of a constant.");
    static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NOT_A_CONSTRUCTOR", "Expected a constructor but found type {0}.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(CALL_FUNCTION_WITH_BOTTOM_FORMAL, CONST_REASSIGNED, CROSS_SCOPE_GOTCHA, FAILED_TO_UNIFY, FORIN_EXPECTS_OBJECT, FORIN_EXPECTS_STRING_KEY, INVALID_ARGUMENT_TYPE, INVALID_INFERRED_RETURN_TYPE, INVALID_OBJLIT_PROPERTY_TYPE, INVALID_OPERAND_TYPE, MISTYPED_ASSIGN_RHS, NON_NUMERIC_ARRAY_INDEX, NOT_A_CONSTRUCTOR, NOT_UNIQUE_INSTANTIATION, POSSIBLY_INEXISTENT_PROPERTY, PROPERTY_ACCESS_ON_NONOBJECT, RETURN_NONDECLARED_TYPE, CheckGlobalThis.GLOBAL_THIS, CheckMissingReturn.MISSING_RETURN_STATEMENT, TypeCheck.CONSTRUCTOR_NOT_CALLABLE, TypeCheck.ILLEGAL_OBJLIT_KEY, TypeCheck.ILLEGAL_PROPERTY_CREATION, TypeCheck.IN_USED_WITH_STRUCT, TypeCheck.INEXISTENT_PROPERTY, TypeCheck.NOT_CALLABLE, TypeCheck.WRONG_ARGUMENT_COUNT, TypeValidator.ILLEGAL_PROPERTY_ACCESS, TypeValidator.INVALID_CAST, TypeValidator.UNKNOWN_TYPEOF_VALUE);
    private WarningReporter warnings;
    private final AbstractCompiler compiler;
    Map<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv> envs;
    Map<GlobalTypeInfo.Scope, JSType> summaries;
    Map<Node, DeferredCheck> deferredChecks;
    ControlFlowGraph<Node> cfg;
    Node jsRoot;
    GlobalTypeInfo.Scope currentScope;
    GlobalTypeInfo symbolTable;
    static final String RETVAL_ID = "%return";
    static final String GETTER_PREFIX = "%getter_fun";
    static final String SETTER_PREFIX = "%setter_fun";
    private JSType arrayType;
    private JSType regexpType;
    private final boolean isClosurePassOn;
    private static boolean showDebuggingPrints = false;
    static boolean measureMem = false;
    private static long peakMem = 0L;
    static final ImmutableSet<String> googPredicates = ImmutableSet.of((Object)"isArray", (Object)"isBoolean", (Object)"isDef", (Object)"isDefAndNotNull", (Object)"isFunction", (Object)"isNull", (Object[])new String[]{"isNumber", "isObject", "isString"});

    NewTypeInference(AbstractCompiler compiler, boolean isClosurePassOn) {
        this.warnings = new WarningReporter(compiler);
        this.compiler = compiler;
        this.envs = new HashMap<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>, TypeEnv>();
        this.summaries = new HashMap<GlobalTypeInfo.Scope, JSType>();
        this.deferredChecks = new HashMap<Node, DeferredCheck>();
        this.isClosurePassOn = isClosurePassOn;
    }

    @VisibleForTesting
    public GlobalTypeInfo.Scope processForTesting(Node externs, Node root) {
        this.process(externs, root);
        return this.symbolTable.getGlobalScope();
    }

    @Override
    public void process(Node externs, Node root) {
        this.jsRoot = root;
        this.symbolTable = this.compiler.getSymbolTable();
        GlobalTypeInfo.Scope gs = this.symbolTable.getGlobalScope();
        JSType arrayCtor = gs.getDeclaredTypeOf("Array");
        this.arrayType = arrayCtor == null ? JSType.UNKNOWN : arrayCtor.getFunType().getReturnType();
        JSType regexpCtor = gs.getDeclaredTypeOf("RegExp");
        this.regexpType = regexpCtor == null ? JSType.UNKNOWN : regexpCtor.getFunType().getReturnType();
        for (GlobalTypeInfo.Scope scope : this.symbolTable.getScopes()) {
            this.analyzeFunction(scope);
            this.envs.clear();
        }
        for (DeferredCheck check : this.deferredChecks.values()) {
            check.runCheck(this.summaries, this.warnings);
        }
        if (measureMem) {
            System.out.println("Peak mem: " + peakMem + "MB");
        }
    }

    static void updatePeakMem() {
        Runtime rt = Runtime.getRuntime();
        long currentUsedMem = (rt.totalMemory() - rt.freeMemory()) / 0x100000L;
        if (currentUsedMem > peakMem) {
            peakMem = currentUsedMem;
        }
    }

    private boolean isArrayType(JSType t) {
        if (this.arrayType.isUnknown()) {
            return false;
        }
        return !t.isUnknown() && t.isSubtypeOf(this.arrayType);
    }

    private static void println(Object ... objs) {
        if (showDebuggingPrints) {
            StringBuilder b = new StringBuilder();
            for (Object obj : objs) {
                b.append(obj == null ? "null" : obj.toString());
            }
            System.out.println(b.toString());
        }
    }

    private TypeEnv getInEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn) {
        List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> inEdges = dn.getInEdges();
        if (inEdges.size() == 1) {
            return this.envs.get(inEdges.get(0));
        }
        HashSet<TypeEnv> envSet = new HashSet<TypeEnv>();
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : inEdges) {
            TypeEnv env = this.envs.get(de);
            if (env == null) continue;
            envSet.add(env);
        }
        if (envSet.isEmpty()) {
            return null;
        }
        return TypeEnv.join(envSet);
    }

    private TypeEnv getOutEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn) {
        Preconditions.checkArgument((!dn.getOutEdges().isEmpty() ? 1 : 0) != 0);
        List<DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch>> outEdges = dn.getOutEdges();
        if (outEdges.size() == 1) {
            return this.envs.get(outEdges.get(0));
        }
        HashSet<TypeEnv> envSet = new HashSet<TypeEnv>();
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : outEdges) {
            TypeEnv env = this.envs.get(de);
            if (env == null) continue;
            envSet.add(env);
        }
        return TypeEnv.join(envSet);
    }

    private TypeEnv setOutEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, TypeEnv e) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : dn.getOutEdges()) {
            this.envs.put(de, e);
        }
        return e;
    }

    private TypeEnv setInEnv(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, TypeEnv e) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> de : dn.getInEdges()) {
            this.envs.put(de, e);
        }
        return e;
    }

    private void initEdgeEnvsFwd(TypeEnv entryEnv) {
        this.envs.clear();
        if (this.currentScope.isFunction()) {
            Set<String> formalsAndOuters = this.currentScope.getOuterVars();
            if (this.currentScope.getName() != null) {
                formalsAndOuters.add(this.currentScope.getName());
            }
            formalsAndOuters.addAll(this.currentScope.getFormals());
            if (this.currentScope.hasThis()) {
                formalsAndOuters.add("this");
            }
            for (String name : formalsAndOuters) {
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                JSType initType = declType == null ? NewTypeInference.envGetType(entryEnv, name) : NewTypeInference.pickInitialType(declType);
                entryEnv = NewTypeInference.envPutType(entryEnv, name, initType);
            }
            entryEnv = NewTypeInference.envPutType(entryEnv, RETVAL_ID, JSType.UNDEFINED);
        }
        for (String local : this.currentScope.getLocals()) {
            entryEnv = NewTypeInference.envPutType(entryEnv, local, JSType.UNDEFINED);
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            JSType summaryType = this.summaries.get(this.currentScope.getScope(fnName));
            FunctionType fnType = summaryType.getFunType();
            summaryType = fnType.isConstructor() || fnType.isInterfaceDefinition() ? fnType.createConstructorObject() : summaryType.withProperty(new QualifiedName("prototype"), JSType.TOP_OBJECT);
            entryEnv = NewTypeInference.envPutType(entryEnv, fnName, summaryType);
        }
        NewTypeInference.println("Keeping env: ", entryEnv);
        this.setOutEnv(this.cfg.getEntry(), entryEnv);
    }

    private TypeEnv getTypeEnvFromDeclaredTypes() {
        TypeEnv env = new TypeEnv();
        Set<String> varNames = this.currentScope.getOuterVars();
        varNames.addAll(this.currentScope.getLocals());
        if (this.currentScope.isFunction()) {
            if (this.currentScope.getName() != null) {
                varNames.add(this.currentScope.getName());
            }
            varNames.addAll(this.currentScope.getFormals());
            if (this.currentScope.hasThis()) {
                varNames.add("this");
            }
        }
        Iterator<String> i$ = varNames.iterator();
        while (i$.hasNext()) {
            String varName;
            JSType declType = this.currentScope.getDeclaredTypeOf(varName = i$.next());
            env = NewTypeInference.envPutType(env, varName, declType == null ? JSType.UNKNOWN : NewTypeInference.pickInitialType(declType));
        }
        for (String fnName : this.currentScope.getLocalFunDefs()) {
            JSType summaryType = this.summaries.get(this.currentScope.getScope(fnName));
            FunctionType fnType = summaryType.getFunType();
            summaryType = fnType.isConstructor() || fnType.isInterfaceDefinition() ? fnType.createConstructorObject() : summaryType.withProperty(new QualifiedName("prototype"), JSType.TOP_OBJECT);
            env = NewTypeInference.envPutType(env, fnName, summaryType);
        }
        return env;
    }

    private void initEdgeEnvsBwd() {
        TypeEnv env = this.getTypeEnvFromDeclaredTypes();
        this.initEdgeEnvs(env);
    }

    private void initEdgeEnvs(TypeEnv env) {
        for (DiGraph.DiGraphEdge e : this.cfg.getEdges()) {
            this.envs.put(e, env);
        }
    }

    private static JSType pickInitialType(JSType declType) {
        Preconditions.checkNotNull((Object)declType);
        FunctionType funType = declType.getFunTypeIfSingletonObj();
        if (funType == null) {
            return declType;
        }
        if (funType.isConstructor() || funType.isInterfaceDefinition()) {
            return funType.createConstructorObject();
        }
        return declType.withProperty(new QualifiedName("prototype"), JSType.TOP_OBJECT);
    }

    private void buildWorkset(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        this.buildWorksetHelper(dn, workset, new HashSet<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>());
    }

    private void buildWorksetHelper(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn, List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset, Set<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> seen) {
        if (seen.contains(dn) || dn == this.cfg.getImplicitReturn()) {
            return;
        }
        switch (((Node)dn.getValue()).getType()) {
            case 113: 
            case 114: 
            case 115: {
                List outEdges = dn.getOutEdges();
                seen.add(dn);
                workset.add(dn);
                for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                    if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_TRUE) continue;
                    this.buildWorksetHelper(diGraphEdge.getDestination(), workset, seen);
                }
                workset.add(dn);
                for (DiGraph.DiGraphEdge diGraphEdge : outEdges) {
                    if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_FALSE) continue;
                    this.buildWorksetHelper(diGraphEdge.getDestination(), workset, seen);
                }
                break;
            }
            default: {
                List succs;
                for (DiGraph.DiGraphEdge diGraphEdge : dn.getInEdges()) {
                    if (seen.contains(diGraphEdge.getSource()) || ((Node)diGraphEdge.getSource().getValue()).isDo()) continue;
                    return;
                }
                seen.add(dn);
                if (this.cfg.getEntry() != dn) {
                    workset.add(dn);
                }
                while ((succs = this.cfg.getDirectedSuccNodes(dn)).size() == 1) {
                    DiGraph.DiGraphNode diGraphNode = succs.get(0);
                    if (diGraphNode == this.cfg.getImplicitReturn()) {
                        return;
                    }
                    if (this.cfg.getDirectedPredNodes(diGraphNode).size() > 1) break;
                    workset.add(diGraphNode);
                    seen.add(diGraphNode);
                    dn = diGraphNode;
                }
                for (DiGraph.DiGraphNode diGraphNode : this.cfg.getDirectedSuccNodes(dn)) {
                    this.buildWorksetHelper(diGraphNode, workset, seen);
                }
            }
        }
    }

    private void analyzeFunction(GlobalTypeInfo.Scope scope) {
        NewTypeInference.println("=== Analyzing function: ", scope.getReadableName(), " ===");
        this.currentScope = scope;
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, scope.getRoot());
        this.cfg = cfa.getCfg();
        NewTypeInference.println(this.cfg);
        LinkedList<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset = new LinkedList<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>>();
        this.buildWorkset(this.cfg.getEntry(), workset);
        if (scope.isFunction() && scope.hasUndeclaredFormalsOrOuters()) {
            Collections.reverse(workset);
            this.initEdgeEnvsBwd();
            this.analyzeFunctionBwd(workset);
            Collections.reverse(workset);
            TypeEnv entryEnv = this.getEntryTypeEnv();
            this.initEdgeEnvsFwd(entryEnv);
            if (measureMem) {
                NewTypeInference.updatePeakMem();
            }
        } else {
            TypeEnv entryEnv = this.getTypeEnvFromDeclaredTypes();
            this.initEdgeEnvsFwd(entryEnv);
        }
        this.analyzeFunctionFwd(workset);
        if (scope.isFunction()) {
            this.createSummary(scope);
        }
        if (measureMem) {
            NewTypeInference.updatePeakMem();
        }
    }

    private void analyzeFunctionBwd(List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset) {
            TypeEnv inEnv;
            Node n = (Node)dn.getValue();
            if (n.isThrow()) continue;
            TypeEnv outEnv = this.getOutEnv(dn);
            NewTypeInference.println("\tBWD Statment: ", n);
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            switch (n.getType()) {
                case 130: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv, (JSType)JSType.UNKNOWN).env;
                    break;
                }
                case 4: {
                    Node retExp = n.getFirstChild();
                    if (retExp == null) {
                        inEnv = outEnv;
                        break;
                    }
                    JSType declRetType = this.currentScope.getDeclaredType().getReturnType();
                    declRetType = declRetType == null ? JSType.UNKNOWN : declRetType;
                    inEnv = this.analyzeExprBwd((Node)retExp, (TypeEnv)outEnv, (JSType)declRetType).env;
                    break;
                }
                case 118: {
                    if (NodeUtil.isTypedefDecl(n)) {
                        inEnv = outEnv;
                        break;
                    }
                    inEnv = outEnv;
                    for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                        JSType requiredType;
                        String varName = nameNode.getString();
                        Node rhs = nameNode.getFirstChild();
                        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
                        inEnv = NewTypeInference.envPutType(inEnv, varName, JSType.UNKNOWN);
                        if (rhs == null || this.currentScope.isLocalFunDef(varName)) continue;
                        JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
                        if (declType == null) {
                            requiredType = inferredType;
                        } else {
                            requiredType = JSType.meet(declType, inferredType);
                            if (requiredType.isBottom()) {
                                requiredType = JSType.UNKNOWN;
                            }
                        }
                        inEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)inEnv, (JSType)requiredType).env;
                    }
                    break;
                }
                case 77: 
                case 112: 
                case 116: 
                case 117: 
                case 120: 
                case 124: 
                case 125: 
                case 132: 
                case 152: {
                    inEnv = outEnv;
                    break;
                }
                case 108: 
                case 113: 
                case 114: 
                case 115: {
                    Node expr = NodeUtil.isForIn(n) ? n.getFirstChild() : NodeUtil.getConditionExpression(n);
                    inEnv = this.analyzeExprBwd((Node)expr, (TypeEnv)outEnv).env;
                    break;
                }
                case 110: 
                case 111: {
                    inEnv = this.analyzeExprBwd((Node)n.getFirstChild(), (TypeEnv)outEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + Token.name(n.getType()));
                    }
                    inEnv = this.analyzeExprBwd((Node)n, (TypeEnv)outEnv).env;
                }
            }
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            this.setInEnv(dn, inEnv);
        }
    }

    private void analyzeFunctionFwd(List<DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch>> workset) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : workset) {
            Node n = (Node)dn.getValue();
            Node parent = n.getParent();
            Preconditions.checkState((n != null ? 1 : 0) != 0, (Object)"Implicit return should not be in workset.");
            TypeEnv inEnv = this.getInEnv(dn);
            TypeEnv outEnv = null;
            if (parent.isScript() || parent.isBlock() && parent.getParent().isFunction()) {
                inEnv = inEnv.clearChangeLog();
            }
            NewTypeInference.println("\tFWD Statment: ", n);
            NewTypeInference.println("\t\tinEnv: ", inEnv);
            boolean conditional = false;
            switch (n.getType()) {
                case 77: 
                case 105: 
                case 112: 
                case 116: 
                case 117: 
                case 120: 
                case 124: 
                case 125: 
                case 132: 
                case 152: {
                    outEnv = inEnv;
                    break;
                }
                case 130: {
                    NewTypeInference.println("\tsemi ", Token.name(n.getFirstChild().getType()));
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv, (JSType)JSType.UNKNOWN).env;
                    break;
                }
                case 4: {
                    JSType actualRetType;
                    Node retExp = n.getFirstChild();
                    JSType declRetType = this.currentScope.getDeclaredType().getReturnType();
                    JSType jSType = declRetType = declRetType == null ? JSType.UNKNOWN : declRetType;
                    if (retExp == null) {
                        actualRetType = JSType.UNDEFINED;
                        outEnv = NewTypeInference.envPutType(inEnv, RETVAL_ID, actualRetType);
                    } else {
                        EnvTypePair retPair = this.analyzeExprFwd(retExp, inEnv, declRetType);
                        actualRetType = retPair.type;
                        outEnv = NewTypeInference.envPutType(retPair.env, RETVAL_ID, actualRetType);
                    }
                    if (actualRetType.isSubtypeOf(declRetType)) break;
                    this.warnings.add(JSError.make(n, RETURN_NONDECLARED_TYPE, declRetType.toString(), actualRetType.toString()));
                    break;
                }
                case 108: 
                case 113: 
                case 114: 
                case 115: {
                    if (NodeUtil.isForIn(n)) {
                        Node obj = n.getChildAtIndex(1);
                        EnvTypePair pair = this.analyzeExprFwd(obj, inEnv, NewTypeInference.pickReqObjType(n));
                        JSType objType = pair.type;
                        if (!objType.isSubtypeOf(JSType.TOP_OBJECT)) {
                            this.warnings.add(JSError.make(obj, FORIN_EXPECTS_OBJECT, objType.toString()));
                        } else if (objType.isStruct()) {
                            this.warnings.add(JSError.make(obj, TypeCheck.IN_USED_WITH_STRUCT, new String[0]));
                        }
                        Node lhs = n.getFirstChild();
                        LValueResultFwd lval = this.analyzeLValueFwd(lhs, inEnv, JSType.STRING);
                        if (lval.declType != null && !lval.declType.isSubtypeOf(JSType.STRING)) {
                            this.warnings.add(JSError.make(lhs, FORIN_EXPECTS_STRING_KEY, lval.declType.toString()));
                            outEnv = lval.env;
                            break;
                        }
                        outEnv = NewTypeInference.updateLvalueTypeInEnv(lval.env, lhs, lval.ptr, JSType.STRING);
                        break;
                    }
                    conditional = true;
                    this.analyzeConditionalStmFwd(dn, NodeUtil.getConditionExpression(n), inEnv);
                    break;
                }
                case 111: {
                    conditional = true;
                    this.analyzeConditionalStmFwd(dn, n, inEnv);
                    break;
                }
                case 118: {
                    outEnv = inEnv;
                    if (NodeUtil.isTypedefDecl(n)) break;
                    for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                        outEnv = this.processVarDeclaration(nameNode, outEnv);
                    }
                    break;
                }
                case 49: 
                case 110: {
                    outEnv = this.analyzeExprFwd((Node)n.getFirstChild(), (TypeEnv)inEnv).env;
                    break;
                }
                default: {
                    if (NodeUtil.isStatement(n)) {
                        throw new RuntimeException("Unhandled statement type: " + Token.name(n.getType()));
                    }
                    outEnv = this.analyzeExprFwd((Node)n, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN).env;
                }
            }
            if (conditional) continue;
            NewTypeInference.println("\t\toutEnv: ", outEnv);
            this.setOutEnv(dn, outEnv);
        }
    }

    private void analyzeConditionalStmFwd(DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> stm, Node cond, TypeEnv inEnv) {
        for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> outEdge : stm.getOutEdges()) {
            JSType specializedType;
            switch ((ControlFlowGraph.Branch)((Object)outEdge.getValue())) {
                case ON_TRUE: {
                    specializedType = JSType.TRUTHY;
                    break;
                }
                case ON_FALSE: {
                    specializedType = JSType.FALSY;
                    break;
                }
                case ON_EX: {
                    specializedType = JSType.UNKNOWN;
                    break;
                }
                default: {
                    throw new RuntimeException("Condition with an unexpected edge type: " + outEdge.getValue());
                }
            }
            this.envs.put(outEdge, this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN, (JSType)specializedType).env);
        }
    }

    private void createSummary(GlobalTypeInfo.Scope fn) {
        String formalName;
        JSType formalType;
        TypeEnv entryEnv = this.getEntryTypeEnv();
        TypeEnv exitEnv = this.getFinalTypeEnv();
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        DeclaredFunctionType declType = fn.getDeclaredType();
        int reqArity = declType.getRequiredArity();
        int optArity = declType.getOptionalArity();
        if (declType.isGeneric()) {
            builder.addTypeParameters(declType.getTypeParameters());
        }
        List<String> formals = fn.getFormals();
        for (int i = reqArity - 1; i >= 0 && (formalType = fn.getDeclaredType().getFormalType(i)) == null && ((formalType = this.getTypeAfterFwd(formalName = formals.get(i), entryEnv, exitEnv)).isUnknown() || JSType.UNDEFINED.isSubtypeOf(formalType)); --i) {
            --reqArity;
        }
        int formalIndex = 0;
        for (String formal : formals) {
            JSType formalType2 = fn.getDeclaredTypeOf(formal);
            if (formalType2 == null) {
                formalType2 = this.getTypeAfterFwd(formal, entryEnv, exitEnv);
            }
            if (formalIndex < reqArity) {
                builder.addReqFormal(formalType2);
            } else if (formalIndex < optArity) {
                builder.addOptFormal(formalType2);
            }
            ++formalIndex;
        }
        if (declType.hasRestFormals()) {
            builder.addRestFormals(declType.getFormalType(formalIndex));
        }
        for (String outer : fn.getOuterVars()) {
            NewTypeInference.println("Free var ", outer, " going in summary");
            builder.addOuterVarPrecondition(outer, this.getTypeAfterFwd(outer, entryEnv, exitEnv));
        }
        builder.addNominalType(declType.getNominalType());
        JSType declRetType = declType.getReturnType();
        JSType actualRetType = NewTypeInference.envGetType(exitEnv, RETVAL_ID);
        if (declRetType == null) {
            builder.addRetType(actualRetType);
        } else {
            builder.addRetType(declRetType);
            if (!NewTypeInference.isAllowedToNotReturn(fn) && !JSType.UNDEFINED.isSubtypeOf(declRetType) && NewTypeInference.hasPathWithNoReturn(this.cfg)) {
                this.warnings.add(JSError.make(fn.getRoot(), CheckMissingReturn.MISSING_RETURN_STATEMENT, declRetType.toString()));
            }
        }
        JSType summary = builder.buildType();
        NewTypeInference.println("Function summary for ", fn.getReadableName());
        NewTypeInference.println("\t", summary);
        this.summaries.put(fn, summary);
    }

    private JSType getTypeAfterFwd(String varName, TypeEnv entryEnv, TypeEnv exitEnv) {
        JSType typeAfterFwd;
        JSType typeAfterBwd = NewTypeInference.envGetType(entryEnv, varName);
        if (!(typeAfterBwd.hasNonScalar() && typeAfterBwd.getFunType() == null || (typeAfterFwd = NewTypeInference.envGetType(exitEnv, varName)) == null)) {
            return typeAfterFwd;
        }
        return typeAfterBwd;
    }

    private static boolean isAllowedToNotReturn(GlobalTypeInfo.Scope methodScope) {
        Node fn = methodScope.getRoot();
        if (fn.isFromExterns()) {
            return true;
        }
        if (!NodeUtil.isPrototypeMethod(fn)) {
            return false;
        }
        String typeName = NodeUtil.getRootOfQualifiedName(fn.getParent().getFirstChild()).getString();
        JSType t = methodScope.getDeclaredTypeOf(typeName);
        return t != null && t.isInterfaceDefinition();
    }

    private static boolean hasPathWithNoReturn(ControlFlowGraph<Node> cfg) {
        for (DiGraph.DiGraphNode<Node, ControlFlowGraph.Branch> dn : cfg.getDirectedPredNodes(cfg.getImplicitReturn())) {
            if (((Node)dn.getValue()).isReturn()) continue;
            return true;
        }
        return false;
    }

    private TypeEnv processVarDeclaration(Node nameNode, TypeEnv inEnv) {
        JSType rhsType;
        String varName = nameNode.getString();
        JSType declType = this.currentScope.getDeclaredTypeOf(varName);
        if (this.currentScope.isLocalFunDef(varName)) {
            return inEnv;
        }
        if (NodeUtil.isNamespaceDecl(nameNode)) {
            return NewTypeInference.envPutType(inEnv, varName, declType);
        }
        Node rhs = nameNode.getFirstChild();
        TypeEnv outEnv = inEnv;
        if (rhs == null) {
            rhsType = JSType.UNDEFINED;
        } else {
            EnvTypePair pair = this.analyzeExprFwd(rhs, inEnv, declType != null ? declType : JSType.UNKNOWN);
            outEnv = pair.env;
            rhsType = pair.type;
        }
        if (declType != null && rhs != null) {
            if (!rhsType.isSubtypeOf(declType)) {
                this.warnings.add(JSError.make(rhs, MISTYPED_ASSIGN_RHS, declType.toString(), rhsType.toString()));
                rhsType = declType;
            } else {
                rhsType = declType.specialize(rhsType);
            }
        }
        return NewTypeInference.envPutType(outEnv, varName, rhsType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv) {
        return this.analyzeExprFwd(expr, inEnv, JSType.UNKNOWN, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        return this.analyzeExprFwd(expr, inEnv, requiredType, requiredType);
    }

    private EnvTypePair analyzeExprFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Preconditions.checkArgument((requiredType != null && !requiredType.isBottom() ? 1 : 0) != 0);
        switch (expr.getType()) {
            case 124: {
                return new EnvTypePair(inEnv, JSType.UNKNOWN);
            }
            case 105: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                JSType fnType = NewTypeInference.envGetType(inEnv, fnName);
                Preconditions.checkState((fnType != null ? 1 : 0) != 0, (String)"Could not find type for %s", (Object[])new Object[]{fnName});
                return new EnvTypePair(inEnv, fnType);
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return new EnvTypePair(inEnv, NewTypeInference.scalarValueToType(expr.getType()));
            }
            case 64: {
                return this.analyzeObjLitFwd(expr, inEnv, requiredType, specializedType);
            }
            case 42: {
                if (!this.currentScope.hasThis()) {
                    this.warnings.add(JSError.make(expr, CheckGlobalThis.GLOBAL_THIS, new String[0]));
                    return new EnvTypePair(inEnv, JSType.UNKNOWN);
                }
                JSType thisType = this.currentScope.getDeclaredTypeOf("this");
                return new EnvTypePair(inEnv, thisType);
            }
            case 38: {
                return this.analyzeNameFwd(expr, inEnv, requiredType, specializedType);
            }
            case 100: 
            case 101: {
                return this.analyzeLogicalOpFwd(expr, inEnv, requiredType, specializedType);
            }
            case 102: 
            case 103: {
                return this.analyzeIncDecFwd(expr, inEnv, requiredType);
            }
            case 27: 
            case 28: 
            case 29: {
                return this.analyzeUnaryNumFwd(expr, inEnv);
            }
            case 32: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                pair.type = JSType.STRING;
                return pair;
            }
            case 52: {
                return this.analyzeInstanceofFwd(expr, inEnv, specializedType);
            }
            case 21: {
                return this.analyzeAddFwd(expr, inEnv);
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.analyzeBinaryNumericOpFwd(expr, inEnv);
            }
            case 86: {
                return this.analyzeAssignFwd(expr, inEnv, requiredType, specializedType);
            }
            case 93: {
                return this.analyzeAssignAddFwd(expr, inEnv, requiredType);
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.analyzeAssignNumericOpFwd(expr, inEnv);
            }
            case 45: 
            case 46: {
                return this.analyzeStrictComparisonFwd(expr.getType(), expr.getFirstChild(), expr.getLastChild(), inEnv, specializedType);
            }
            case 12: 
            case 13: {
                return this.analyzeNonStrictComparisonFwd(expr, inEnv, specializedType);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.analyzeLtGtFwd(expr, inEnv);
            }
            case 33: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                if (expr.getBooleanProp(75)) {
                    expr.removeProp(75);
                    return new EnvTypePair(inEnv, requiredType);
                }
                return this.analyzePropAccessFwd(expr.getFirstChild(), expr.getLastChild().getString(), inEnv, requiredType, specializedType);
            }
            case 98: {
                return this.analyzeHookFwd(expr, inEnv, requiredType, specializedType);
            }
            case 30: 
            case 37: {
                return this.analyzeCallNewFwd(expr, inEnv, requiredType, specializedType);
            }
            case 85: {
                return this.analyzeExprFwd(expr.getLastChild(), this.analyzeExprFwd((Node)expr.getFirstChild(), (TypeEnv)inEnv).env, requiredType, specializedType);
            }
            case 26: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv, JSType.UNKNOWN, specializedType.negate());
                pair.type = pair.type.negate().toBoolean();
                return pair;
            }
            case 35: {
                return this.analyzeGetElemFwd(expr, inEnv, requiredType, specializedType);
            }
            case 122: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                pair.type = JSType.UNDEFINED;
                return pair;
            }
            case 51: {
                return this.analyzeInFwd(expr, inEnv, specializedType);
            }
            case 31: {
                EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 47: {
                return new EnvTypePair(inEnv, this.regexpType);
            }
            case 63: {
                return this.analyzeArrayLitFwd(expr, inEnv);
            }
            case 155: {
                return this.analyzeCastFwd(expr, inEnv);
            }
            case 111: {
                return this.analyzeStrictComparisonFwd(45, expr.getParent().getFirstChild(), expr.getFirstChild(), inEnv, specializedType);
            }
        }
        throw new RuntimeException("Unhandled expression type: " + Token.name(expr.getType()));
    }

    private EnvTypePair analyzeNameFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        String varName = expr.getString();
        if (varName.equals("undefined")) {
            return new EnvTypePair(inEnv, JSType.UNDEFINED);
        }
        if (this.currentScope.isLocalVar(varName) || this.currentScope.isFormalParam(varName) || this.currentScope.isLocalFunDef(varName) || this.currentScope.isOuterVar(varName) || varName.equals(this.currentScope.getName())) {
            JSType inferredType = NewTypeInference.envGetType(inEnv, varName);
            NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType, " specializedType:  ", specializedType);
            if (!inferredType.isSubtypeOf(requiredType)) {
                JSType declType = this.currentScope.getDeclaredTypeOf(varName);
                if (this.tightenTypeAndDontWarn(varName, declType, inferredType, requiredType)) {
                    inferredType = inferredType.specialize(requiredType);
                } else {
                    return new EnvTypePair(inEnv, inferredType);
                }
            }
            JSType preciseType = inferredType.specialize(specializedType);
            NewTypeInference.println(varName, "'s preciseType: ", preciseType);
            if (!preciseType.isBottom() && this.currentScope.isUndeclaredFormal(varName) && preciseType.hasNonScalar()) {
                preciseType = preciseType.withLoose();
            }
            return EnvTypePair.addBinding(inEnv, varName, preciseType);
        }
        NewTypeInference.println("Found global variable ", varName);
        return new EnvTypePair(inEnv, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeLogicalOpFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        int exprKind = expr.getType();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (specializedType.isTruthy() && exprKind == 101 || specializedType.isFalsy() && exprKind == 100) {
            EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, specializedType);
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, specializedType);
            return rhsPair;
        }
        if (specializedType.isFalsy() && exprKind == 101 || specializedType.isTruthy() && exprKind == 100) {
            EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, specializedType);
            EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, specializedType.negate());
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, specializedType);
            return EnvTypePair.join(rhsPair, shortCircuitPair);
        }
        JSType stopAfterLhsType = exprKind == 101 ? JSType.FALSY : JSType.TRUTHY;
        EnvTypePair shortCircuitPair = this.analyzeExprFwd(lhs, inEnv, requiredType, stopAfterLhsType);
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, stopAfterLhsType.negate());
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, requiredType, specializedType);
        return EnvTypePair.join(rhsPair, shortCircuitPair);
    }

    private EnvTypePair analyzeIncDecFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        this.mayWarnAboutConst(expr);
        Node ch = expr.getFirstChild();
        if (ch.isGetProp() || ch.isGetElem() && ch.getLastChild().isString()) {
            Node recv = ch.getFirstChild();
            String pname = ch.getLastChild().getString();
            EnvTypePair pair = this.analyzeExprFwd(recv, inEnv);
            JSType recvType = pair.type;
            if (this.mayWarnAboutConstProp(ch, recvType, new QualifiedName(pname))) {
                pair.type = requiredType;
                return pair;
            }
        }
        return this.analyzeUnaryNumFwd(expr, inEnv);
    }

    private EnvTypePair analyzeUnaryNumFwd(Node expr, TypeEnv inEnv) {
        Node child = expr.getFirstChild();
        EnvTypePair pair = this.analyzeExprFwd(child, inEnv, JSType.NUMBER);
        if (!pair.type.isSubtypeOf(JSType.NUMBER)) {
            this.warnInvalidOperand(child, expr.getType(), JSType.NUMBER, pair.type);
        }
        pair.type = JSType.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeInstanceofFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        Node obj = expr.getFirstChild();
        Node ctor = expr.getLastChild();
        EnvTypePair objPair = this.analyzeExprFwd(obj, inEnv);
        JSType objType = objPair.type;
        if (!(objType.equals(JSType.TOP) || objType.equals(JSType.UNKNOWN) || objType.hasNonScalar())) {
            this.warnInvalidOperand(obj, 52, "an object or a union type that includes an object", objPair.type);
        }
        EnvTypePair ctorPair = this.analyzeExprFwd(ctor, objPair.env, JSType.topFunction());
        JSType ctorType = ctorPair.type;
        FunctionType ctorFunType = ctorType.getFunType();
        if (!(ctorType.isUnknown() || ctorType.isSubtypeOf(JSType.topFunction()) && ctorFunType.isConstructor())) {
            this.warnInvalidOperand(ctor, 52, "a constructor function", ctorType);
        }
        if (ctorFunType == null || !ctorFunType.isConstructor() || !specializedType.isTruthy() && !specializedType.isFalsy()) {
            ctorPair.type = JSType.BOOLEAN;
            return ctorPair;
        }
        JSType instanceType = ctorFunType.getTypeOfThis();
        objPair = this.analyzeExprFwd(obj, inEnv, JSType.UNKNOWN, specializedType.isTruthy() ? objPair.type.specialize(instanceType) : objPair.type.removeType(instanceType));
        ctorPair = this.analyzeExprFwd(ctor, objPair.env, JSType.topFunction());
        ctorPair.type = JSType.BOOLEAN;
        return ctorPair;
    }

    private EnvTypePair analyzeAddFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.NUM_OR_STR);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.NUM_OR_STR);
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (!lhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
            this.warnInvalidOperand(lhs, expr.getType(), JSType.NUM_OR_STR, lhsType);
        }
        if (!rhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
            this.warnInvalidOperand(rhs, expr.getType(), JSType.NUM_OR_STR, rhsType);
        }
        return new EnvTypePair(rhsPair.env, JSType.plus(lhsType, rhsType));
    }

    private EnvTypePair analyzeBinaryNumericOpFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.NUMBER);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.NUMBER);
        if (!lhsPair.type.isSubtypeOf(JSType.NUMBER)) {
            this.warnInvalidOperand(lhs, expr.getType(), JSType.NUMBER, lhsPair.type);
        }
        if (!rhsPair.type.isSubtypeOf(JSType.NUMBER)) {
            this.warnInvalidOperand(rhs, expr.getType(), JSType.NUMBER, rhsPair.type);
        }
        rhsPair.type = JSType.NUMBER;
        return rhsPair;
    }

    private EnvTypePair analyzeAssignFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        if (expr.getBooleanProp(75)) {
            expr.removeProp(75);
            return new EnvTypePair(inEnv, requiredType);
        }
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (lhs.getBooleanProp(75)) {
            lhs.removeProp(75);
            JSType declType = this.getDeclaredTypeOfQname(lhs, inEnv);
            EnvTypePair rhsPair = this.analyzeExprFwd(rhs, inEnv, declType);
            if (!rhsPair.type.isSubtypeOf(declType)) {
                this.warnings.add(JSError.make(expr, MISTYPED_ASSIGN_RHS, declType.toString(), rhsPair.type.toString()));
            }
            return rhsPair;
        }
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, requiredType);
        JSType declType = lvalue.declType;
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lvalue.env, requiredType, specializedType);
        if (declType != null && !rhsPair.type.isSubtypeOf(declType)) {
            this.warnings.add(JSError.make(expr, MISTYPED_ASSIGN_RHS, declType.toString(), rhsPair.type.toString()));
        } else {
            rhsPair.env = NewTypeInference.updateLvalueTypeInEnv(rhsPair.env, lhs, lvalue.ptr, rhsPair.type);
        }
        return rhsPair;
    }

    private EnvTypePair analyzeAssignAddFwd(Node expr, TypeEnv inEnv, JSType requiredType) {
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType lhsReqType = NewTypeInference.specializeWithCorrection(requiredType, JSType.NUM_OR_STR);
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, lhsReqType);
        JSType lhsType = lvalue.type;
        if (!lhsType.isSubtypeOf(JSType.NUM_OR_STR)) {
            this.warnInvalidOperand(lhs, 93, JSType.NUM_OR_STR, lhsType);
        }
        JSType rhsReqType = lhsType.equals(JSType.NUMBER) ? JSType.NUMBER : JSType.NUM_OR_STR;
        EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, rhsReqType);
        if (!pair.type.isSubtypeOf(rhsReqType)) {
            this.warnInvalidOperand(rhs, 93, rhsReqType, pair.type);
        }
        return pair;
    }

    private EnvTypePair analyzeAssignNumericOpFwd(Node expr, TypeEnv inEnv) {
        this.mayWarnAboutConst(expr);
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        LValueResultFwd lvalue = this.analyzeLValueFwd(lhs, inEnv, JSType.NUMBER);
        JSType lhsType = lvalue.type;
        boolean lhsWarned = false;
        if (!lhsType.isSubtypeOf(JSType.NUMBER)) {
            this.warnInvalidOperand(lhs, expr.getType(), JSType.NUMBER, lhsType);
            lhsWarned = true;
        }
        EnvTypePair pair = this.analyzeExprFwd(rhs, lvalue.env, JSType.NUMBER);
        if (!pair.type.isSubtypeOf(JSType.NUMBER)) {
            this.warnInvalidOperand(rhs, expr.getType(), JSType.NUMBER, pair.type);
        }
        if (!lhsWarned) {
            pair.env = NewTypeInference.updateLvalueTypeInEnv(pair.env, lhs, lvalue.ptr, JSType.NUMBER);
        }
        pair.type = JSType.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeLtGtFwd(Node expr, TypeEnv inEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        if (lhsPair.type.isScalar() && !rhsPair.type.isScalar()) {
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, lhsPair.type);
        } else if (rhsPair.type.isScalar()) {
            lhsPair = this.analyzeExprFwd(lhs, inEnv, rhsPair.type);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, rhsPair.type);
        } else if (lhs.isName() && lhsPair.type.isUnknown() && rhs.isName() && rhsPair.type.isUnknown()) {
            TypeEnv env = NewTypeInference.envPutType(rhsPair.env, lhs.getString(), JSType.TOP_SCALAR);
            env = NewTypeInference.envPutType(rhsPair.env, rhs.getString(), JSType.TOP_SCALAR);
            return new EnvTypePair(env, JSType.BOOLEAN);
        }
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (!(lhsType.isSubtypeOf(JSType.TOP_SCALAR) && rhsType.isSubtypeOf(JSType.TOP_SCALAR) && JSType.areCompatibleScalarTypes(lhsType, rhsType))) {
            this.warnInvalidOperand(expr, expr.getType(), "matching scalar types", lhsType.toString() + ", " + rhsType.toString());
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeHookFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Node cond = expr.getFirstChild();
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        TypeEnv trueEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN, (JSType)JSType.TRUE_TYPE).env;
        TypeEnv falseEnv = this.analyzeExprFwd((Node)cond, (TypeEnv)inEnv, (JSType)JSType.UNKNOWN, (JSType)JSType.FALSE_TYPE).env;
        EnvTypePair thenPair = this.analyzeExprFwd(thenBranch, trueEnv, requiredType, specializedType);
        EnvTypePair elsePair = this.analyzeExprFwd(elseBranch, falseEnv, requiredType, specializedType);
        return EnvTypePair.join(thenPair, elsePair);
    }

    private EnvTypePair analyzeCallNewFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        String calleeName;
        FunctionType funType;
        if (this.isClosureSpecificCall(expr)) {
            return this.analyzeClosureCallFwd(expr, inEnv, specializedType);
        }
        Node callee = expr.getFirstChild();
        EnvTypePair calleePair = this.analyzeExprFwd(callee, inEnv, JSType.topFunction());
        JSType calleeType = calleePair.type;
        if (!calleeType.isSubtypeOf(JSType.topFunction())) {
            this.warnings.add(JSError.make(expr, TypeCheck.NOT_CALLABLE, calleeType.toString()));
        }
        if ((funType = calleeType.getFunType()) == null || funType.isTopFunction() || funType.isQmarkFunction()) {
            return this.analyzeCallNodeArgumentsFwd(expr, inEnv);
        }
        if (funType.isLoose()) {
            return this.analyzeLooseCallNodeFwd(expr, inEnv, requiredType);
        }
        if (expr.isCall() && funType.isConstructor()) {
            this.warnings.add(JSError.make(expr, TypeCheck.CONSTRUCTOR_NOT_CALLABLE, funType.toString()));
            return this.analyzeCallNodeArgumentsFwd(expr, inEnv);
        }
        if (expr.isNew() && !funType.isConstructor()) {
            this.warnings.add(JSError.make(expr, NOT_A_CONSTRUCTOR, funType.toString()));
            return this.analyzeCallNodeArgumentsFwd(expr, inEnv);
        }
        int maxArity = funType.getMaxArity();
        int minArity = funType.getMinArity();
        int numArgs = expr.getChildCount() - 1;
        if (numArgs < minArity || numArgs > maxArity) {
            this.warnings.add(JSError.make(expr, TypeCheck.WRONG_ARGUMENT_COUNT, "", Integer.toString(numArgs), Integer.toString(minArity), " and at most " + maxArity));
            return this.analyzeCallNodeArgumentsFwd(expr, inEnv);
        }
        FunctionType origFunType = funType;
        if (funType.isGeneric()) {
            Map<String, JSType> typeMap = this.calcTypeInstantiationFwd(expr, funType, inEnv);
            funType = funType.instantiateGenerics(typeMap);
            NewTypeInference.println("Instantiated function type: " + funType);
        }
        ArrayList<JSType> argTypes = new ArrayList<JSType>();
        TypeEnv tmpEnv = inEnv;
        Node arg = expr.getChildAtIndex(1);
        for (int i = 0; i < numArgs; ++i) {
            JSType formalType = funType.getFormalType(i);
            if (formalType.isBottom()) {
                this.warnings.add(JSError.make(expr, CALL_FUNCTION_WITH_BOTTOM_FORMAL, Integer.toString(i)));
                formalType = JSType.UNKNOWN;
            }
            EnvTypePair pair = this.analyzeExprFwd(arg, tmpEnv, formalType);
            JSType argTypeForDeferredCheck = pair.type;
            if (i >= minArity && pair.type.equals(JSType.UNDEFINED)) {
                argTypeForDeferredCheck = null;
            } else if (!pair.type.isSubtypeOf(formalType)) {
                this.warnings.add(JSError.make(arg, INVALID_ARGUMENT_TYPE, Integer.toString(i + 1), "", formalType.toString(), pair.type.toString()));
                argTypeForDeferredCheck = null;
            }
            argTypes.add(argTypeForDeferredCheck);
            tmpEnv = pair.env;
            arg = arg.getNext();
        }
        JSType retType = funType.getReturnType();
        if (callee.isName() && this.currentScope.isKnownFunction(calleeName = callee.getQualifiedName())) {
            if (this.currentScope.isLocalFunDef(calleeName)) {
                this.collectTypesForFreeVarsFwd(callee, tmpEnv);
            } else if (!origFunType.isGeneric()) {
                DeferredCheck dc;
                JSType expectedRetType = requiredType;
                NewTypeInference.println("Updating deferred check with ret: ", expectedRetType, " and args: ", argTypes);
                if (expr.isCall()) {
                    dc = this.deferredChecks.get(expr);
                    if (dc != null) {
                        dc.updateReturn(expectedRetType);
                    } else {
                        Preconditions.checkState((!this.currentScope.hasUndeclaredFormalsOrOuters() ? 1 : 0) != 0, (String)"No deferred check created in backward direction for %s", (Object[])new Object[]{expr});
                    }
                } else {
                    dc = new DeferredCheck(expr, null, this.currentScope, this.currentScope.getScope(calleeName));
                    this.deferredChecks.put(expr, dc);
                }
                if (dc != null) {
                    dc.updateArgTypes(argTypes);
                }
            }
        }
        return new EnvTypePair(tmpEnv, retType);
    }

    private EnvTypePair analyzeGetElemFwd(Node expr, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        Node receiver = expr.getFirstChild();
        Node index = expr.getLastChild();
        JSType reqObjType = NewTypeInference.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprFwd(receiver, inEnv, reqObjType);
        JSType recvType = pair.type;
        if (!this.mayWarnAboutNonObject(receiver, "", recvType, specializedType) && !this.mayWarnAboutStructPropAccess(receiver, recvType)) {
            if (this.isArrayType(recvType)) {
                pair = this.analyzeExprFwd(index, pair.env, JSType.NUMBER);
                if (!pair.type.isSubtypeOf(JSType.NUMBER)) {
                    this.warnings.add(JSError.make(index, NON_NUMERIC_ARRAY_INDEX, pair.type.toString()));
                }
            } else if (index.isString()) {
                return this.analyzePropAccessFwd(receiver, index.getString(), inEnv, requiredType, specializedType);
            }
        }
        pair = this.analyzeExprFwd(index, pair.env);
        pair.type = requiredType;
        return pair;
    }

    private EnvTypePair analyzeInFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType reqObjType = NewTypeInference.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprFwd(lhs, inEnv, JSType.NUM_OR_STR);
        if (!pair.type.isSubtypeOf(JSType.NUM_OR_STR)) {
            this.warnInvalidOperand(lhs, 51, JSType.NUM_OR_STR, pair.type);
        }
        pair = this.analyzeExprFwd(rhs, pair.env, reqObjType);
        if (!pair.type.isSubtypeOf(JSType.TOP_OBJECT)) {
            this.warnInvalidOperand(rhs, 51, "Object", pair.type);
            pair.type = JSType.BOOLEAN;
            return pair;
        }
        if (pair.type.isStruct()) {
            this.warnings.add(JSError.make(rhs, TypeCheck.IN_USED_WITH_STRUCT, new String[0]));
            pair.type = JSType.BOOLEAN;
            return pair;
        }
        JSType resultType = JSType.BOOLEAN;
        if (lhs.isString()) {
            QualifiedName pname = new QualifiedName(lhs.getString());
            if (specializedType.isTruthy()) {
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType, reqObjType.withPropertyRequired(pname.getLeftmostName()));
                resultType = JSType.TRUE_TYPE;
            } else if (specializedType.isFalsy()) {
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType);
                pair = this.analyzeExprFwd(rhs, inEnv, reqObjType, pair.type.withoutProperty(pname));
                resultType = JSType.FALSE_TYPE;
            }
        }
        pair.type = resultType;
        return pair;
    }

    private EnvTypePair analyzeArrayLitFwd(Node expr, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        for (Node arrayElm = expr.getFirstChild(); arrayElm != null; arrayElm = arrayElm.getNext()) {
            env = this.analyzeExprFwd((Node)arrayElm, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, this.arrayType);
    }

    private EnvTypePair analyzeCastFwd(Node expr, TypeEnv inEnv) {
        EnvTypePair pair = this.analyzeExprFwd(expr.getFirstChild(), inEnv);
        JSType fromType = pair.type;
        JSType toType = this.symbolTable.getCastType(expr);
        if (!toType.isSubtypeOf(fromType) && !fromType.isSubtypeOf(toType)) {
            this.warnings.add(JSError.make(expr, TypeValidator.INVALID_CAST, fromType.toString(), toType.toString()));
        }
        pair.type = toType;
        return pair;
    }

    private EnvTypePair analyzeCallNodeArgumentsFwd(Node callNode, TypeEnv inEnv) {
        TypeEnv env = inEnv;
        for (Node arg = callNode.getFirstChild().getNext(); arg != null; arg = arg.getNext()) {
            env = this.analyzeExprFwd((Node)arg, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeStrictComparisonFwd(int comparisonOp, Node lhs, Node rhs, TypeEnv inEnv, JSType specializedType) {
        if (specializedType.isTruthy() || specializedType.isFalsy()) {
            if (lhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(lhs, rhs, comparisonOp, inEnv, specializedType);
            }
            if (rhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(rhs, lhs, comparisonOp, inEnv, specializedType);
            }
            if (this.isGoogTypeof(lhs)) {
                return this.analyzeGoogTypeof(lhs, rhs, inEnv, specializedType);
            }
            if (this.isGoogTypeof(rhs)) {
                return this.analyzeGoogTypeof(rhs, lhs, inEnv, specializedType);
            }
        }
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        if (comparisonOp == 45 && specializedType.isTruthy() || comparisonOp == 46 && specializedType.isFalsy()) {
            JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
            lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, meetType);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, meetType);
        } else if (comparisonOp == 45 && specializedType.isFalsy() || comparisonOp == 46 && specializedType.isTruthy()) {
            JSType lhsType = lhsPair.type;
            JSType rhsType = rhsPair.type;
            if (lhsType.equals(JSType.NULL) || lhsType.equals(JSType.UNDEFINED)) {
                rhsType = rhsType.removeType(lhsType);
            } else if (rhsType.equals(JSType.NULL) || rhsType.equals(JSType.UNDEFINED)) {
                lhsType = lhsType.removeType(rhsType);
            }
            lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, lhsType);
            rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, rhsType);
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeSpecializedTypeof(Node typeof, Node typeString, int comparisonOp, TypeEnv inEnv, JSType specializedType) {
        EnvTypePair pair;
        Node typeofRand = typeof.getFirstChild();
        JSType comparedType = NewTypeInference.getTypeFromString(typeString);
        this.checkInvalidTypename(typeString);
        if (comparedType.isUnknown()) {
            pair = this.analyzeExprFwd(typeofRand, inEnv);
            pair = this.analyzeExprFwd(typeString, pair.env);
        } else if (specializedType.isTruthy() && (comparisonOp == 45 || comparisonOp == 12) || specializedType.isFalsy() && (comparisonOp == 46 || comparisonOp == 13)) {
            pair = this.analyzeExprFwd(typeofRand, inEnv, JSType.UNKNOWN, comparedType);
        } else {
            pair = this.analyzeExprFwd(typeofRand, inEnv);
            pair = this.analyzeExprFwd(typeofRand, inEnv, JSType.UNKNOWN, pair.type.removeType(comparedType));
        }
        pair.type = specializedType.toBoolean();
        return pair;
    }

    private static JSType getTypeFromString(Node typeString) {
        if (!typeString.isString()) {
            return JSType.UNKNOWN;
        }
        switch (typeString.getString()) {
            case "number": {
                return JSType.NUMBER;
            }
            case "string": {
                return JSType.STRING;
            }
            case "boolean": {
                return JSType.BOOLEAN;
            }
            case "undefined": {
                return JSType.UNDEFINED;
            }
            case "function": {
                return JSType.topFunction();
            }
            case "object": {
                return JSType.join(JSType.NULL, JSType.TOP_OBJECT);
            }
        }
        return JSType.UNKNOWN;
    }

    private void checkInvalidTypename(Node typeString) {
        String typeName;
        if (!typeString.isString()) {
            return;
        }
        switch (typeName = typeString.getString()) {
            case "number": 
            case "string": 
            case "boolean": 
            case "undefined": 
            case "function": 
            case "object": 
            case "unknown": {
                break;
            }
            default: {
                this.warnings.add(JSError.make(typeString, TypeValidator.UNKNOWN_TYPEOF_VALUE, typeName));
            }
        }
    }

    private Map<String, JSType> calcTypeInstantiationFwd(Node callNode, FunctionType funType, TypeEnv typeEnv) {
        return this.calcTypeInstantiation(callNode, funType, typeEnv, true);
    }

    private Map<String, JSType> calcTypeInstantiationBwd(Node callNode, FunctionType funType, TypeEnv typeEnv) {
        return this.calcTypeInstantiation(callNode, funType, typeEnv, false);
    }

    private ImmutableMap<String, JSType> calcTypeInstantiation(Node callNode, FunctionType funType, TypeEnv typeEnv, boolean isFwd) {
        List<String> typeParameters = funType.getTypeParameters();
        HashMultimap typeMultimap = HashMultimap.create();
        Node arg = callNode.getChildAtIndex(1);
        int i = 0;
        while (arg != null) {
            JSType unifSource;
            EnvTypePair pair = isFwd ? this.analyzeExprFwd(arg, typeEnv) : this.analyzeExprBwd(arg, typeEnv);
            JSType unifTarget = funType.getFormalType(i);
            if (!unifTarget.unifyWith(unifSource = pair.type, typeParameters, (Multimap<String, JSType>)typeMultimap)) {
                HashMap<String, JSType> tmpTypeMap = new HashMap<String, JSType>();
                for (String typeParam : typeParameters) {
                    tmpTypeMap.put(typeParam, JSType.UNKNOWN);
                }
                if (unifSource.isSubtypeOf(unifTarget.substituteGenerics(tmpTypeMap))) {
                    this.warnings.add(JSError.make(arg, FAILED_TO_UNIFY, unifTarget.toString(), unifSource.toString()));
                }
            }
            arg = arg.getNext();
            typeEnv = pair.env;
            ++i;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : typeParameters) {
            Collection types = typeMultimap.get((Object)typeParam);
            if (types.size() > 1) {
                if (isFwd) {
                    this.warnings.add(JSError.make(callNode, NOT_UNIQUE_INSTANTIATION, typeParam, types.toString()));
                }
                builder.put((Object)typeParam, (Object)JSType.UNKNOWN);
                continue;
            }
            if (types.size() == 1) {
                builder.put((Object)typeParam, Iterables.getOnlyElement((Iterable)types));
                continue;
            }
            builder.put((Object)typeParam, (Object)JSType.UNKNOWN);
        }
        return builder.build();
    }

    private EnvTypePair analyzeNonStrictComparisonFwd(Node expr, TypeEnv inEnv, JSType specializedType) {
        int tokenType = expr.getType();
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (specializedType.isTruthy() || specializedType.isFalsy()) {
            if (lhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(lhs, rhs, tokenType, inEnv, specializedType);
            }
            if (rhs.isTypeOf()) {
                return this.analyzeSpecializedTypeof(rhs, lhs, tokenType, inEnv, specializedType);
            }
            if (this.isGoogTypeof(lhs)) {
                return this.analyzeGoogTypeof(lhs, rhs, inEnv, specializedType);
            }
            if (this.isGoogTypeof(rhs)) {
                return this.analyzeGoogTypeof(rhs, lhs, inEnv, specializedType);
            }
        }
        EnvTypePair lhsPair = this.analyzeExprFwd(lhs, inEnv);
        EnvTypePair rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
        JSType lhsType = lhsPair.type;
        JSType rhsType = rhsPair.type;
        if (tokenType == 12 && specializedType.isTruthy() || tokenType == 13 && specializedType.isFalsy()) {
            if (lhsType.isNullOrUndef()) {
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, JSType.NULL_OR_UNDEF);
            } else if (rhsType.isNullOrUndef()) {
                lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            } else if (!JSType.NULL_OR_UNDEF.isSubtypeOf(lhsType)) {
                rhsType = rhsType.removeType(JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, rhsType);
            } else if (!JSType.NULL_OR_UNDEF.isSubtypeOf(rhsType)) {
                lhsType = lhsType.removeType(JSType.NULL_OR_UNDEF);
                lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        } else if (tokenType == 12 && specializedType.isFalsy() || tokenType == 13 && specializedType.isTruthy()) {
            if (lhsType.isNullOrUndef()) {
                rhsType = rhsType.removeType(JSType.NULL_OR_UNDEF);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env, JSType.UNKNOWN, rhsType);
            } else if (rhsType.isNullOrUndef()) {
                lhsType = lhsType.removeType(JSType.NULL_OR_UNDEF);
                lhsPair = this.analyzeExprFwd(lhs, inEnv, JSType.UNKNOWN, lhsType);
                rhsPair = this.analyzeExprFwd(rhs, lhsPair.env);
            }
        }
        rhsPair.type = JSType.BOOLEAN;
        return rhsPair;
    }

    private EnvTypePair analyzeObjLitFwd(Node objLit, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        if (NodeUtil.isEnumDecl(objLit.getParent())) {
            return this.analyzeEnumObjLitFwd(objLit, inEnv, requiredType);
        }
        JSDocInfo jsdoc = objLit.getJSDocInfo();
        boolean isStruct = jsdoc != null && jsdoc.makesStructs();
        boolean isDict = jsdoc != null && jsdoc.makesDicts();
        TypeEnv env = inEnv;
        JSType result = NewTypeInference.pickReqObjType(objLit);
        for (Node prop : objLit.children()) {
            JSType reqPtype;
            JSType specPtype;
            if (isStruct && prop.isQuotedString()) {
                this.warnings.add(JSError.make(prop, TypeCheck.ILLEGAL_OBJLIT_KEY, "struct"));
            } else if (isDict && !prop.isQuotedString()) {
                this.warnings.add(JSError.make(prop, TypeCheck.ILLEGAL_OBJLIT_KEY, "dict"));
            }
            String pname = NodeUtil.getObjectLitKeyName(prop);
            if (prop.isGetterDef() || prop.isSetterDef()) {
                JSType propType;
                String specialPropName;
                EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env);
                FunctionType funType = pair.type.getFunType();
                Preconditions.checkNotNull((Object)funType);
                if (prop.isGetterDef()) {
                    specialPropName = GETTER_PREFIX + pname;
                    propType = funType.getReturnType();
                } else {
                    specialPropName = SETTER_PREFIX + pname;
                    propType = pair.type;
                }
                result = result.withProperty(new QualifiedName(specialPropName), propType);
                env = pair.env;
                continue;
            }
            QualifiedName qname = new QualifiedName(pname);
            JSType jsdocType = this.symbolTable.getPropDeclaredType(prop);
            if (jsdocType != null) {
                reqPtype = specPtype = jsdocType;
            } else if (requiredType.mayHaveProp(qname)) {
                reqPtype = specPtype = requiredType.getProp(qname);
                if (specializedType.mayHaveProp(qname)) {
                    specPtype = specializedType.getProp(qname);
                }
            } else {
                reqPtype = specPtype = JSType.UNKNOWN;
            }
            EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env, reqPtype, specPtype);
            if (jsdocType != null) {
                result = result.withDeclaredProperty(qname, jsdocType, false);
                if (!pair.type.isSubtypeOf(jsdocType)) {
                    this.warnings.add(JSError.make(prop, INVALID_OBJLIT_PROPERTY_TYPE, jsdocType.toString(), pair.type.toString()));
                    pair.type = jsdocType;
                }
            }
            result = result.withProperty(qname, pair.type);
            env = pair.env;
        }
        return new EnvTypePair(env, result);
    }

    private EnvTypePair analyzeEnumObjLitFwd(Node objLit, TypeEnv inEnv, JSType requiredType) {
        if (objLit.getFirstChild() == null) {
            return new EnvTypePair(inEnv, requiredType);
        }
        String pname = NodeUtil.getObjectLitKeyName(objLit.getFirstChild());
        JSType enumeratedType = requiredType.getProp(new QualifiedName(pname)).getEnumeratedType();
        if (enumeratedType == null) {
            return new EnvTypePair(inEnv, requiredType);
        }
        TypeEnv env = inEnv;
        for (Node prop : objLit.children()) {
            EnvTypePair pair = this.analyzeExprFwd(prop.getFirstChild(), env, enumeratedType);
            if (!pair.type.isSubtypeOf(enumeratedType)) {
                this.warnings.add(JSError.make(prop, INVALID_OBJLIT_PROPERTY_TYPE, enumeratedType.toString(), pair.type.toString()));
            }
            env = pair.env;
        }
        return new EnvTypePair(env, requiredType);
    }

    private EnvTypePair analyzeGoogTypePredicate(Node call, String typeHint, TypeEnv inEnv, JSType specializedType) {
        int numArgs = call.getChildCount() - 1;
        if (numArgs != 1) {
            this.warnings.add(JSError.make(call, TypeCheck.WRONG_ARGUMENT_COUNT, call.getFirstChild().getQualifiedName(), Integer.toString(numArgs), "1", "1"));
            return this.analyzeCallNodeArgumentsFwd(call, inEnv);
        }
        EnvTypePair pair = this.analyzeExprFwd(call.getLastChild(), inEnv);
        if (specializedType.isTruthy() || specializedType.isFalsy()) {
            pair = this.analyzeExprFwd(call.getLastChild(), inEnv, JSType.UNKNOWN, this.googPredicateTransformType(typeHint, specializedType, pair.type));
        }
        pair.type = JSType.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeGoogTypeof(Node typeof, Node typeString, TypeEnv inEnv, JSType specializedType) {
        return this.analyzeGoogTypePredicate(typeof, typeString.isString() ? typeString.getString() : "", inEnv, specializedType);
    }

    private EnvTypePair analyzeClosureCallFwd(Node call, TypeEnv inEnv, JSType specializedType) {
        return this.analyzeGoogTypePredicate(call, call.getFirstChild().getLastChild().getString(), inEnv, specializedType);
    }

    private JSType googPredicateTransformType(String typeHint, JSType booleanContext, JSType beforeType) {
        switch (typeHint) {
            case "array": 
            case "isArray": {
                return booleanContext.isTruthy() ? this.arrayType : beforeType.removeType(this.arrayType);
            }
            case "boolean": 
            case "isBoolean": {
                return booleanContext.isTruthy() ? JSType.BOOLEAN : beforeType.removeType(JSType.BOOLEAN);
            }
            case "function": 
            case "isFunction": {
                return booleanContext.isTruthy() ? JSType.topFunction() : beforeType.removeType(JSType.topFunction());
            }
            case "null": 
            case "isNull": {
                return booleanContext.isTruthy() ? JSType.NULL : beforeType.removeType(JSType.NULL);
            }
            case "number": 
            case "isNumber": {
                return booleanContext.isTruthy() ? JSType.NUMBER : beforeType.removeType(JSType.NUMBER);
            }
            case "string": 
            case "isString": {
                return booleanContext.isTruthy() ? JSType.STRING : beforeType.removeType(JSType.STRING);
            }
            case "isDef": {
                return booleanContext.isTruthy() ? beforeType.removeType(JSType.UNDEFINED) : JSType.UNDEFINED;
            }
            case "isDefAndNotNull": {
                return booleanContext.isTruthy() ? beforeType.removeType(JSType.NULL_OR_UNDEF) : JSType.NULL_OR_UNDEF;
            }
            case "isObject": {
                return booleanContext.isTruthy() ? JSType.TOP_OBJECT : beforeType.removeType(JSType.TOP_OBJECT);
            }
            case "object": {
                return JSType.UNKNOWN;
            }
            case "undefined": {
                return booleanContext.isTruthy() ? JSType.UNDEFINED : beforeType.removeType(JSType.UNDEFINED);
            }
        }
        return JSType.UNKNOWN;
    }

    private boolean tightenTypeAndDontWarn(String varName, JSType declared, JSType inferred, JSType required) {
        boolean fuzzyDeclaration = declared == null || declared.isUnknown() || declared.isTop() && !inferred.isTop();
        return fuzzyDeclaration && (varName == null || this.currentScope.isFormalParam(varName) || this.currentScope.isOuterVar(varName)) && required.isNonLooseSubtypeOf(inferred);
    }

    private boolean mayWarnAboutNonObject(Node receiver, String pname, JSType recvType, JSType specializedType) {
        boolean mayNotBeAnObject;
        boolean isNotAnObject = JSType.BOTTOM.equals(JSType.meet(recvType, JSType.TOP_OBJECT));
        boolean bl = mayNotBeAnObject = !recvType.isSubtypeOf(JSType.TOP_OBJECT);
        if (isNotAnObject || !specializedType.isTruthy() && !specializedType.isFalsy() && mayNotBeAnObject) {
            this.warnings.add(JSError.make(receiver, PROPERTY_ACCESS_ON_NONOBJECT, pname, recvType.toString()));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutStructPropAccess(Node obj, JSType type) {
        if (type.isStruct()) {
            this.warnings.add(JSError.make(obj, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "'[]'", "struct"));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutDictPropAccess(Node obj, JSType type) {
        if (type.isDict()) {
            this.warnings.add(JSError.make(obj, TypeValidator.ILLEGAL_PROPERTY_ACCESS, "'.'", "dict"));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutPropCreation(QualifiedName pname, Node getProp, JSType recvType) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        if (recvType.isStruct() && !recvType.isLooseStruct() && !recvType.hasProp(pname)) {
            this.warnings.add(JSError.make(getProp, TypeCheck.ILLEGAL_PROPERTY_CREATION, new String[0]));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutConst(Node n) {
        Node lhs = n.getFirstChild();
        if (lhs.isName() && this.currentScope.isConstVar(lhs.getString())) {
            this.warnings.add(JSError.make(n, CONST_REASSIGNED, new String[0]));
            return true;
        }
        return false;
    }

    private boolean mayWarnAboutConstProp(Node propAccess, JSType recvType, QualifiedName pname) {
        if (recvType.hasConstantProp(pname) && !NodeUtil.hasConstAnnotation(propAccess.getParent())) {
            this.warnings.add(JSError.make(propAccess, CONST_REASSIGNED, new String[0]));
            return true;
        }
        return false;
    }

    private EnvTypePair analyzePropAccessFwd(Node receiver, String pname, TypeEnv inEnv, JSType requiredType, JSType specializedType) {
        JSType recvSpecType;
        JSType recvReqType;
        QualifiedName propQname = new QualifiedName(pname);
        Node propAccessNode = receiver.getParent();
        JSType objWithProp = NewTypeInference.pickReqObjType(receiver).withLoose().withProperty(propQname, requiredType);
        if (specializedType.isTruthy() || specializedType.isFalsy()) {
            recvReqType = JSType.UNKNOWN;
            recvSpecType = objWithProp;
        } else {
            recvReqType = recvSpecType = objWithProp;
        }
        EnvTypePair pair = this.analyzeExprFwd(receiver, inEnv, recvReqType, recvSpecType);
        JSType recvType = pair.type;
        if (recvType.isUnknown() || this.mayWarnAboutNonObject(receiver, pname, recvType, specializedType)) {
            return new EnvTypePair(pair.env, requiredType);
        }
        if (propAccessNode.isGetProp() && this.mayWarnAboutDictPropAccess(receiver, recvType)) {
            return new EnvTypePair(pair.env, requiredType);
        }
        QualifiedName getterPname = new QualifiedName(GETTER_PREFIX + pname);
        if (recvType.hasProp(getterPname)) {
            return new EnvTypePair(pair.env, recvType.getProp(getterPname));
        }
        JSType resultType = recvType.getProp(propQname);
        if (!(propAccessNode.getParent().isExprResult() || specializedType.isTruthy() || specializedType.isFalsy())) {
            if (!recvType.mayHaveProp(propQname)) {
                this.warnings.add(JSError.make(propAccessNode, TypeCheck.INEXISTENT_PROPERTY, pname, recvType.toString()));
            } else if (!recvType.hasProp(propQname)) {
                this.warnings.add(JSError.make(propAccessNode, POSSIBLY_INEXISTENT_PROPERTY, pname, recvType.toString()));
            } else if (recvType.hasProp(propQname) && !resultType.isSubtypeOf(requiredType) && this.tightenTypeAndDontWarn(receiver.isName() ? receiver.getString() : null, recvType.getDeclaredProp(propQname), resultType, requiredType)) {
                resultType = resultType.specialize(requiredType);
                LValueResultFwd lvr = this.analyzeLValueFwd(propAccessNode, inEnv, resultType);
                TypeEnv updatedEnv = NewTypeInference.updateLvalueTypeInEnv(lvr.env, propAccessNode, lvr.ptr, resultType);
                return new EnvTypePair(updatedEnv, resultType);
            }
        }
        if (resultType == null) {
            resultType = JSType.UNKNOWN;
        }
        return new EnvTypePair(pair.env, resultType);
    }

    private static TypeEnv updateLvalueTypeInEnv(TypeEnv env, Node lvalue, QualifiedName qname, JSType type) {
        if (lvalue.isName()) {
            return NewTypeInference.envPutType(env, lvalue.getString(), type);
        }
        if (lvalue.isVar()) {
            Preconditions.checkState((boolean)NodeUtil.isForIn(lvalue.getParent()));
            return NewTypeInference.envPutType(env, lvalue.getFirstChild().getString(), type);
        }
        Preconditions.checkState((lvalue.isGetProp() || lvalue.isGetElem() ? 1 : 0) != 0);
        if (qname != null) {
            String objName = qname.getLeftmostName();
            QualifiedName props = qname.getAllButLeftmost();
            JSType objType = NewTypeInference.envGetType(env, objName);
            env = NewTypeInference.envPutType(env, objName, objType.withProperty(props, type));
        }
        return env;
    }

    private void collectTypesForFreeVarsFwd(Node callee, TypeEnv env) {
        GlobalTypeInfo.Scope calleeScope = this.currentScope.getScope(callee.getQualifiedName());
        for (String freeVar : calleeScope.getOuterVars()) {
            if (calleeScope.getDeclaredTypeOf(freeVar) != null) continue;
            FunctionType summary = this.summaries.get(calleeScope).getFunType();
            JSType outerType = NewTypeInference.envGetType(env, freeVar);
            JSType innerType = summary.getOuterVarPrecondition(freeVar);
            if (outerType == null || !JSType.meet(outerType, innerType).isBottom()) continue;
            this.warnings.add(JSError.make(callee, CROSS_SCOPE_GOTCHA, freeVar, outerType.toString(), innerType.toString()));
        }
    }

    private TypeEnv collectTypesForFreeVarsBwd(Node callee, TypeEnv env) {
        GlobalTypeInfo.Scope calleeScope = this.currentScope.getScope(callee.getQualifiedName());
        for (String freeVar : calleeScope.getOuterVars()) {
            if (!this.currentScope.isDefinedLocally(freeVar) && !this.currentScope.isOuterVar(freeVar)) continue;
            JSType declType = this.currentScope.getDeclaredTypeOf(freeVar);
            env = NewTypeInference.envPutType(env, freeVar, declType != null ? declType : JSType.UNKNOWN);
        }
        return env;
    }

    private EnvTypePair analyzeLooseCallNodeFwd(Node callNode, TypeEnv inEnv, JSType retType) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isNew() ? 1 : 0) != 0);
        Node callee = callNode.getFirstChild();
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        TypeEnv tmpEnv = inEnv;
        for (Node arg = callee.getNext(); arg != null; arg = arg.getNext()) {
            EnvTypePair pair = this.analyzeExprFwd(arg, tmpEnv);
            tmpEnv = pair.env;
            builder.addReqFormal(pair.type);
        }
        JSType looseRetType = retType.isUnknown() ? JSType.BOTTOM : retType;
        JSType looseFunctionType = builder.addRetType(looseRetType).addLoose().buildType();
        EnvTypePair calleePair = this.analyzeExprFwd(callee, tmpEnv, JSType.topFunction(), looseFunctionType);
        return new EnvTypePair(calleePair.env, retType);
    }

    private EnvTypePair analyzeLooseCallNodeBwd(Node callNode, TypeEnv outEnv, JSType retType) {
        Preconditions.checkArgument((callNode.isCall() || callNode.isNew() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)retType);
        Node callee = callNode.getFirstChild();
        TypeEnv tmpEnv = outEnv;
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (int i = callNode.getChildCount() - 2; i >= 0; --i) {
            Node arg = callNode.getChildAtIndex(i + 1);
            tmpEnv = this.analyzeExprBwd((Node)arg, (TypeEnv)tmpEnv).env;
            builder.addReqFormal(JSType.BOTTOM);
        }
        JSType looseRetType = retType.isUnknown() ? JSType.BOTTOM : retType;
        JSType looseFunctionType = builder.addRetType(looseRetType).addLoose().buildType();
        NewTypeInference.println("loose function type is ", looseFunctionType);
        EnvTypePair calleePair = this.analyzeExprBwd(callee, tmpEnv, looseFunctionType);
        return new EnvTypePair(calleePair.env, retType);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv) {
        return this.analyzeExprBwd(expr, outEnv, JSType.UNKNOWN);
    }

    private EnvTypePair analyzeExprBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Preconditions.checkArgument((requiredType != null ? 1 : 0) != 0, (Object)("Required type null at: " + expr));
        Preconditions.checkArgument((!requiredType.isBottom() ? 1 : 0) != 0);
        switch (expr.getType()) {
            case 124: {
                return new EnvTypePair(outEnv, JSType.UNKNOWN);
            }
            case 105: {
                String fnName = this.symbolTable.getFunInternalName(expr);
                return new EnvTypePair(outEnv, NewTypeInference.envGetType(outEnv, fnName));
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return new EnvTypePair(outEnv, NewTypeInference.scalarValueToType(expr.getType()));
            }
            case 64: {
                return this.analyzeObjLitBwd(expr, outEnv, requiredType);
            }
            case 42: {
                if (!this.currentScope.hasThis()) {
                    return new EnvTypePair(outEnv, JSType.UNKNOWN);
                }
                JSType thisType = this.currentScope.getDeclaredTypeOf("this");
                return new EnvTypePair(outEnv, thisType);
            }
            case 38: {
                return this.analyzeNameBwd(expr, outEnv, requiredType);
            }
            case 27: 
            case 28: 
            case 29: 
            case 102: 
            case 103: {
                return this.analyzeExprBwd(expr.getFirstChild(), outEnv, JSType.NUMBER);
            }
            case 32: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.STRING;
                return pair;
            }
            case 52: {
                TypeEnv env = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv, (JSType)JSType.topFunction()).env;
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), env);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.analyzeBinaryNumericOpBwd(expr, outEnv);
            }
            case 21: {
                return this.analyzeAddBwd(expr, outEnv);
            }
            case 100: 
            case 101: {
                return this.analyzeLogicalOpBwd(expr, outEnv);
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return this.analyzeEqNeBwd(expr, outEnv);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.analyzeLtGtBwd(expr, outEnv);
            }
            case 86: {
                return this.analyzeAssignBwd(expr, outEnv, requiredType);
            }
            case 93: {
                return this.analyzeAssignAddBwd(expr, outEnv, requiredType);
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.analyzeAssignNumericOpBwd(expr, outEnv);
            }
            case 33: {
                Preconditions.checkState((!NodeUtil.isAssignmentOp(expr.getParent()) || !NodeUtil.isLValue(expr) ? 1 : 0) != 0);
                if (expr.getBooleanProp(75)) {
                    return new EnvTypePair(outEnv, requiredType);
                }
                return this.analyzePropAccessBwd(expr.getFirstChild(), expr.getLastChild().getString(), outEnv, requiredType);
            }
            case 98: {
                return this.analyzeHookBwd(expr, outEnv, requiredType);
            }
            case 30: 
            case 37: {
                return this.analyzeCallNewBwd(expr, outEnv, requiredType);
            }
            case 85: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getLastChild(), outEnv, requiredType);
                pair.env = this.analyzeExprBwd((Node)expr.getFirstChild(), (TypeEnv)pair.env).env;
                return pair;
            }
            case 26: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = pair.type.negate();
                return pair;
            }
            case 35: {
                return this.analyzeGetElemBwd(expr, outEnv, requiredType);
            }
            case 122: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.UNDEFINED;
                return pair;
            }
            case 51: {
                return this.analyzeInBwd(expr, outEnv);
            }
            case 31: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = JSType.BOOLEAN;
                return pair;
            }
            case 118: {
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getString();
                Preconditions.checkState((!vdecl.hasChildren() ? 1 : 0) != 0);
                return new EnvTypePair(NewTypeInference.envPutType(outEnv, name, JSType.UNKNOWN), JSType.UNKNOWN);
            }
            case 47: {
                return new EnvTypePair(outEnv, this.regexpType);
            }
            case 63: {
                return this.analyzeArrayLitBwd(expr, outEnv);
            }
            case 155: {
                EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), outEnv);
                pair.type = this.symbolTable.getCastType(expr);
                return pair;
            }
        }
        throw new RuntimeException("BWD: Unhandled expression type: " + Token.name(expr.getType()) + " with parent: " + expr.getParent());
    }

    private EnvTypePair analyzeNameBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        String varName = expr.getString();
        if (varName.equals("undefined")) {
            return new EnvTypePair(outEnv, JSType.UNDEFINED);
        }
        JSType inferredType = NewTypeInference.envGetType(outEnv, varName);
        NewTypeInference.println(varName, "'s inferredType: ", inferredType, " requiredType:  ", requiredType);
        if (inferredType == null) {
            return new EnvTypePair(outEnv, JSType.UNKNOWN);
        }
        JSType preciseType = inferredType.specialize(requiredType);
        if (this.currentScope.isUndeclaredFormal(varName) && preciseType.hasNonScalar()) {
            preciseType = preciseType.withLoose();
        }
        NewTypeInference.println(varName, "'s preciseType: ", preciseType);
        if (preciseType.isBottom()) {
            JSType declType = this.currentScope.getDeclaredTypeOf(varName);
            preciseType = declType == null ? requiredType : declType;
        }
        return EnvTypePair.addBinding(outEnv, varName, preciseType);
    }

    private EnvTypePair analyzeBinaryNumericOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        TypeEnv rhsEnv = this.analyzeExprBwd((Node)rhs, (TypeEnv)outEnv, (JSType)JSType.NUMBER).env;
        EnvTypePair pair = this.analyzeExprBwd(lhs, rhsEnv, JSType.NUMBER);
        pair.type = JSType.NUMBER;
        return pair;
    }

    private EnvTypePair analyzeAddBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv, JSType.NUM_OR_STR);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, JSType.NUM_OR_STR);
        lhsPair.type = JSType.plus(lhsPair.type, rhsPair.type);
        return lhsPair;
    }

    private EnvTypePair analyzeLogicalOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
        lhsPair.type = JSType.join(rhsPair.type, lhsPair.type);
        return lhsPair;
    }

    private EnvTypePair analyzeEqNeBwd(Node expr, TypeEnv outEnv) {
        TypeEnv rhsEnv = this.analyzeExprBwd((Node)expr.getLastChild(), (TypeEnv)outEnv).env;
        EnvTypePair pair = this.analyzeExprBwd(expr.getFirstChild(), rhsEnv);
        pair.type = JSType.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeLtGtBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair rhsPair = this.analyzeExprBwd(rhs, outEnv);
        EnvTypePair lhsPair = this.analyzeExprBwd(lhs, rhsPair.env);
        JSType meetType = JSType.meet(lhsPair.type, rhsPair.type);
        if (meetType.isBottom()) {
            lhsPair.type = JSType.BOOLEAN;
            return lhsPair;
        }
        rhsPair = this.analyzeExprBwd(rhs, outEnv, meetType);
        lhsPair = this.analyzeExprBwd(lhs, rhsPair.env, meetType);
        lhsPair.type = JSType.BOOLEAN;
        return lhsPair;
    }

    private EnvTypePair analyzeAssignBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        if (expr.getBooleanProp(75)) {
            return new EnvTypePair(outEnv, requiredType);
        }
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        if (lhs.getBooleanProp(75)) {
            return this.analyzeExprBwd(rhs, outEnv, this.getDeclaredTypeOfQname(lhs, outEnv));
        }
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, outEnv, requiredType, true);
        TypeEnv slicedEnv = lvalue.env;
        JSType rhsReqType = NewTypeInference.specializeWithCorrection(lvalue.type, requiredType);
        EnvTypePair pair = this.analyzeExprBwd(rhs, slicedEnv, rhsReqType);
        pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)requiredType, (boolean)true).env;
        return pair;
    }

    private EnvTypePair analyzeAssignAddBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        JSType lhsReqType = NewTypeInference.specializeWithCorrection(requiredType, JSType.NUM_OR_STR);
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, outEnv, lhsReqType, false);
        JSType rhsReqType = lvalue.type.equals(JSType.NUMBER) ? JSType.NUMBER : JSType.NUM_OR_STR;
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, rhsReqType);
        pair.env = this.analyzeLValueBwd((Node)lhs, (TypeEnv)pair.env, (JSType)lhsReqType, (boolean)false).env;
        return pair;
    }

    private EnvTypePair analyzeAssignNumericOpBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, JSType.NUMBER);
        LValueResultBwd lvalue = this.analyzeLValueBwd(lhs, pair.env, JSType.NUMBER, false);
        return new EnvTypePair(lvalue.env, JSType.NUMBER);
    }

    private EnvTypePair analyzeHookBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node cond = expr.getFirstChild();
        Node thenBranch = cond.getNext();
        Node elseBranch = thenBranch.getNext();
        EnvTypePair thenPair = this.analyzeExprBwd(thenBranch, outEnv, requiredType);
        EnvTypePair elsePair = this.analyzeExprBwd(elseBranch, outEnv, requiredType);
        return this.analyzeExprBwd(cond, TypeEnv.join(thenPair.env, elsePair.env));
    }

    private EnvTypePair analyzeCallNewBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        int numArgs;
        Node callee = expr.getFirstChild();
        JSType calleeTypeGeneral = this.analyzeExprBwd((Node)callee, (TypeEnv)outEnv, (JSType)JSType.topFunction()).type;
        FunctionType funType = calleeTypeGeneral.getFunType();
        if (funType == null) {
            return this.analyzeCallNodeArgumentsBwd(expr, outEnv);
        }
        if (funType.isLoose()) {
            return this.analyzeLooseCallNodeBwd(expr, outEnv, requiredType);
        }
        if (expr.isCall() && funType.isConstructor() || expr.isNew() && !funType.isConstructor()) {
            return this.analyzeCallNodeArgumentsBwd(expr, outEnv);
        }
        if (funType.isTopFunction()) {
            return this.analyzeCallNodeArgumentsBwd(expr, outEnv);
        }
        if (callee.isName() && !funType.isGeneric() && expr.isCall()) {
            this.createDeferredCheckBwd(expr, requiredType);
        }
        if ((numArgs = expr.getChildCount() - 1) < funType.getMinArity() || numArgs > funType.getMaxArity()) {
            return this.analyzeCallNodeArgumentsBwd(expr, outEnv);
        }
        if (funType.isGeneric()) {
            Map<String, JSType> typeMap = this.calcTypeInstantiationBwd(expr, funType, outEnv);
            funType = funType.instantiateGenerics(typeMap);
        }
        TypeEnv tmpEnv = outEnv;
        for (int i = expr.getChildCount() - 2; i >= 0; --i) {
            JSType formalType = funType.getFormalType(i);
            if (formalType.isBottom()) {
                formalType = JSType.UNKNOWN;
            }
            Node arg = expr.getChildAtIndex(i + 1);
            tmpEnv = this.analyzeExprBwd((Node)arg, (TypeEnv)tmpEnv, (JSType)formalType).env;
        }
        if (callee.isName() && this.currentScope.isLocalFunDef(callee.getString())) {
            tmpEnv = this.collectTypesForFreeVarsBwd(callee, tmpEnv);
        }
        return new EnvTypePair(tmpEnv, funType.getReturnType());
    }

    private EnvTypePair analyzeGetElemBwd(Node expr, TypeEnv outEnv, JSType requiredType) {
        Node receiver = expr.getFirstChild();
        Node index = expr.getLastChild();
        JSType reqObjType = NewTypeInference.pickReqObjType(expr);
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, reqObjType);
        if (this.isArrayType(pair.type)) {
            pair = this.analyzeExprBwd(index, pair.env, JSType.NUMBER);
            pair.type = requiredType;
            return pair;
        }
        if (index.isString()) {
            return this.analyzePropAccessBwd(receiver, index.getString(), outEnv, requiredType);
        }
        pair = this.analyzeExprBwd(index, outEnv);
        pair = this.analyzeExprBwd(receiver, pair.env, reqObjType);
        pair.type = requiredType;
        return pair;
    }

    private EnvTypePair analyzeInBwd(Node expr, TypeEnv outEnv) {
        Node lhs = expr.getFirstChild();
        Node rhs = expr.getLastChild();
        EnvTypePair pair = this.analyzeExprBwd(rhs, outEnv, NewTypeInference.pickReqObjType(expr));
        pair = this.analyzeExprBwd(lhs, pair.env, JSType.NUM_OR_STR);
        pair.type = JSType.BOOLEAN;
        return pair;
    }

    private EnvTypePair analyzeArrayLitBwd(Node expr, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        for (int i = expr.getChildCount() - 1; i >= 0; --i) {
            Node arrayElm = expr.getChildAtIndex(i);
            env = this.analyzeExprBwd((Node)arrayElm, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, this.arrayType);
    }

    private EnvTypePair analyzeCallNodeArgumentsBwd(Node callNode, TypeEnv outEnv) {
        TypeEnv env = outEnv;
        for (int i = callNode.getChildCount() - 1; i > 0; --i) {
            Node arg = callNode.getChildAtIndex(i);
            env = this.analyzeExprBwd((Node)arg, (TypeEnv)env).env;
        }
        return new EnvTypePair(env, JSType.UNKNOWN);
    }

    private void createDeferredCheckBwd(Node expr, JSType requiredType) {
        Preconditions.checkArgument((boolean)expr.isCall());
        String calleeName = expr.getFirstChild().getQualifiedName();
        if (this.currentScope.isKnownFunction(calleeName) && !this.currentScope.isLocalFunDef(calleeName)) {
            GlobalTypeInfo.Scope s = this.currentScope.getScope(calleeName);
            JSType expectedRetType = s.getDeclaredType().getReturnType() == null ? requiredType : null;
            NewTypeInference.println("Putting deferred check of function: ", calleeName, " with ret: ", expectedRetType);
            DeferredCheck dc = new DeferredCheck(expr, expectedRetType, this.currentScope, s);
            this.deferredChecks.put(expr, dc);
        }
    }

    private EnvTypePair analyzePropAccessBwd(Node receiver, String pname, TypeEnv outEnv, JSType requiredType) {
        JSType propAccessType;
        QualifiedName qname = new QualifiedName(pname);
        EnvTypePair pair = this.analyzeExprBwd(receiver, outEnv, NewTypeInference.pickReqObjType(receiver).withLoose().withProperty(qname, requiredType));
        JSType receiverType = pair.type;
        pair.type = propAccessType = receiverType.mayHaveProp(qname) ? receiverType.getProp(qname) : requiredType;
        return pair;
    }

    private EnvTypePair analyzeObjLitBwd(Node objLit, TypeEnv outEnv, JSType requiredType) {
        if (NodeUtil.isEnumDecl(objLit.getParent())) {
            return this.analyzeEnumObjLitBwd(objLit, outEnv, requiredType);
        }
        TypeEnv env = outEnv;
        JSType result = NewTypeInference.pickReqObjType(objLit);
        Node prop = objLit.getLastChild();
        while (prop != null) {
            QualifiedName pname = new QualifiedName(NodeUtil.getObjectLitKeyName(prop));
            if (prop.isGetterDef() || prop.isSetterDef()) {
                env = this.analyzeExprBwd((Node)prop.getFirstChild(), (TypeEnv)env).env;
            } else {
                JSType jsdocType = this.symbolTable.getPropDeclaredType(prop);
                JSType reqPtype = jsdocType != null ? jsdocType : (requiredType.mayHaveProp(pname) ? requiredType.getProp(pname) : JSType.UNKNOWN);
                EnvTypePair pair = this.analyzeExprBwd(prop.getFirstChild(), env, reqPtype);
                result = result.withProperty(pname, pair.type);
                env = pair.env;
            }
            prop = objLit.getChildBefore(prop);
        }
        return new EnvTypePair(env, result);
    }

    private EnvTypePair analyzeEnumObjLitBwd(Node objLit, TypeEnv outEnv, JSType requiredType) {
        if (objLit.getFirstChild() == null) {
            return new EnvTypePair(outEnv, requiredType);
        }
        String pname = NodeUtil.getObjectLitKeyName(objLit.getFirstChild());
        JSType enumeratedType = requiredType.getProp(new QualifiedName(pname)).getEnumeratedType();
        if (enumeratedType == null) {
            return new EnvTypePair(outEnv, requiredType);
        }
        TypeEnv env = outEnv;
        Node prop = objLit.getLastChild();
        while (prop != null) {
            env = this.analyzeExprBwd((Node)prop.getFirstChild(), (TypeEnv)env, (JSType)enumeratedType).env;
            prop = objLit.getChildBefore(prop);
        }
        return new EnvTypePair(env, requiredType);
    }

    private boolean isClosureSpecificCall(Node expr) {
        if (!this.isClosurePassOn || !expr.isCall()) {
            return false;
        }
        Node callee = expr.getFirstChild();
        if (!(callee.isGetProp() && callee.getFirstChild().isName() && callee.getFirstChild().getString().equals("goog"))) {
            return false;
        }
        return googPredicates.contains((Object)callee.getLastChild().getString());
    }

    private boolean isGoogTypeof(Node expr) {
        if (!expr.isCall()) {
            return false;
        }
        return (expr = expr.getFirstChild()).isGetProp() && expr.getFirstChild().isName() && expr.getFirstChild().getString().equals("goog") && expr.getLastChild().getString().equals("typeOf");
    }

    private static JSType scalarValueToType(int token) {
        switch (token) {
            case 39: {
                return JSType.NUMBER;
            }
            case 40: {
                return JSType.STRING;
            }
            case 44: {
                return JSType.TRUE_TYPE;
            }
            case 43: {
                return JSType.FALSE_TYPE;
            }
            case 41: {
                return JSType.NULL;
            }
        }
        throw new RuntimeException("The token isn't a scalar value " + Token.name(token));
    }

    private void warnInvalidOperand(Node expr, int operatorType, Object expected, Object actual) {
        Preconditions.checkArgument((expected instanceof String || expected instanceof JSType ? 1 : 0) != 0);
        Preconditions.checkArgument((actual instanceof String || actual instanceof JSType ? 1 : 0) != 0);
        this.warnings.add(JSError.make(expr, INVALID_OPERAND_TYPE, Token.name(operatorType), expected.toString(), actual.toString()));
    }

    private static JSType envGetType(TypeEnv env, String pname) {
        Preconditions.checkArgument((!pname.contains(".") ? 1 : 0) != 0);
        return env.getType(pname);
    }

    private static TypeEnv envPutType(TypeEnv env, String varName, JSType type) {
        Preconditions.checkArgument((!varName.contains(".") ? 1 : 0) != 0);
        return env.putType(varName, type);
    }

    private JSType getDeclaredTypeOfQname(Node qnameNode, TypeEnv env) {
        switch (qnameNode.getType()) {
            case 38: {
                JSType result = NewTypeInference.envGetType(env, qnameNode.getString());
                Preconditions.checkNotNull((Object)result);
                return result;
            }
            case 33: {
                Preconditions.checkState((boolean)qnameNode.isQualifiedName());
                JSType recvType = this.getDeclaredTypeOfQname(qnameNode.getFirstChild(), env);
                JSType result = recvType.getProp(new QualifiedName(qnameNode.getLastChild().getString()));
                Preconditions.checkNotNull((Object)result);
                return result;
            }
        }
        throw new RuntimeException("getDeclaredTypeOfQname: unexpected node " + Token.name(qnameNode.getType()));
    }

    private LValueResultFwd analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type) {
        return this.analyzeLValueFwd(expr, inEnv, type, false);
    }

    private LValueResultFwd analyzeLValueFwd(Node expr, TypeEnv inEnv, JSType type, boolean insideQualifiedName) {
        switch (expr.getType()) {
            case 42: {
                if (this.currentScope.hasThis()) {
                    return new LValueResultFwd(inEnv, NewTypeInference.envGetType(inEnv, "this"), this.currentScope.getDeclaredTypeOf("this"), new QualifiedName("this"));
                }
                this.warnings.add(JSError.make(expr, CheckGlobalThis.GLOBAL_THIS, new String[0]));
                return new LValueResultFwd(inEnv, JSType.UNKNOWN, null, null);
            }
            case 38: {
                String varName = expr.getString();
                JSType varType = this.analyzeExprFwd((Node)expr, (TypeEnv)inEnv).type;
                return new LValueResultFwd(inEnv, varType, this.currentScope.getDeclaredTypeOf(varName), varType.hasNonScalar() ? new QualifiedName(varName) : null);
            }
            case 33: {
                Node obj = expr.getFirstChild();
                QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                return this.analyzePropLValFwd(obj, pname, inEnv, type, insideQualifiedName);
            }
            case 35: {
                if (expr.getLastChild().isString()) {
                    Node obj = expr.getFirstChild();
                    QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                    return this.analyzePropLValFwd(obj, pname, inEnv, type, insideQualifiedName);
                }
                EnvTypePair pair = this.analyzeExprFwd(expr, inEnv, type);
                return new LValueResultFwd(pair.env, pair.type, null, null);
            }
            case 118: {
                Preconditions.checkState((boolean)NodeUtil.isForIn(expr.getParent()));
                Node vdecl = expr.getFirstChild();
                String name = vdecl.getString();
                Preconditions.checkState((!vdecl.hasChildren() ? 1 : 0) != 0);
                return new LValueResultFwd(inEnv, JSType.STRING, null, new QualifiedName(name));
            }
        }
        Preconditions.checkState((boolean)insideQualifiedName);
        EnvTypePair pair = this.analyzeExprFwd(expr, inEnv, type);
        return new LValueResultFwd(pair.env, pair.type, null, null);
    }

    private LValueResultFwd analyzePropLValFwd(Node obj, QualifiedName pname, TypeEnv inEnv, JSType type, boolean insideQualifiedName) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        String pnameAsString = pname.getLeftmostName();
        JSType reqObjType = NewTypeInference.pickReqObjType(obj).withLoose().withProperty(pname, type);
        LValueResultFwd lvalue = this.analyzeLValueFwd(obj, inEnv, reqObjType, true);
        TypeEnv lvalueEnv = lvalue.env;
        JSType lvalueType = lvalue.type;
        if (!lvalueType.isSubtypeOf(JSType.TOP_OBJECT)) {
            this.warnings.add(JSError.make(obj, PROPERTY_ACCESS_ON_NONOBJECT, pnameAsString, lvalueType.toString()));
            return new LValueResultFwd(lvalueEnv, type, null, null);
        }
        Node parent = obj.getParent();
        if (parent.isGetProp() && parent.getParent().isAssign() && this.mayWarnAboutPropCreation(pname, parent, lvalueType)) {
            return new LValueResultFwd(lvalueEnv, type, null, null);
        }
        if (!insideQualifiedName && this.mayWarnAboutConstProp(parent, lvalueType, pname)) {
            return new LValueResultFwd(lvalueEnv, type, null, null);
        }
        if (!lvalueType.mayHaveProp(pname)) {
            if (insideQualifiedName && lvalueType.isLoose()) {
                if ((lvalueType = lvalueType.withProperty(pname, JSType.TOP_OBJECT.withLoose())).isDict() && parent.isGetProp()) {
                    lvalueType = lvalueType.specialize(JSType.TOP_STRUCT);
                } else if (lvalueType.isStruct() && parent.isGetElem()) {
                    lvalueType = lvalueType.specialize(JSType.TOP_DICT);
                }
                lvalueEnv = NewTypeInference.updateLvalueTypeInEnv(lvalueEnv, obj, lvalue.ptr, lvalueType);
            } else {
                boolean warnForInexistentProp;
                boolean bl = warnForInexistentProp = insideQualifiedName || parent.getParent().getType() != 86;
                if (warnForInexistentProp && !lvalueType.isUnknown() && !lvalueType.isDict()) {
                    this.warnings.add(JSError.make(obj, TypeCheck.INEXISTENT_PROPERTY, pnameAsString, lvalueType.toString()));
                    return new LValueResultFwd(lvalueEnv, type, null, null);
                }
            }
        }
        if (parent.isGetElem()) {
            this.mayWarnAboutStructPropAccess(obj, lvalueType);
        } else if (parent.isGetProp()) {
            this.mayWarnAboutDictPropAccess(obj, lvalueType);
        }
        QualifiedName setterPname = new QualifiedName(SETTER_PREFIX + pnameAsString);
        if (lvalueType.hasProp(setterPname)) {
            FunctionType funType = lvalueType.getProp(setterPname).getFunType();
            Preconditions.checkNotNull((Object)funType);
            JSType formalType = funType.getFormalType(0);
            Preconditions.checkState((!formalType.isBottom() ? 1 : 0) != 0);
            return new LValueResultFwd(lvalueEnv, formalType, formalType, null);
        }
        return new LValueResultFwd(lvalueEnv, lvalueType.mayHaveProp(pname) ? lvalueType.getProp(pname) : JSType.UNKNOWN, lvalueType.mayHaveProp(pname) ? lvalueType.getDeclaredProp(pname) : null, lvalue.ptr == null ? null : QualifiedName.join(lvalue.ptr, pname));
    }

    private LValueResultBwd analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing) {
        return this.analyzeLValueBwd(expr, outEnv, type, doSlicing, false);
    }

    private LValueResultBwd analyzeLValueBwd(Node expr, TypeEnv outEnv, JSType type, boolean doSlicing, boolean insideQualifiedName) {
        switch (expr.getType()) {
            case 38: 
            case 42: {
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                String name = expr.getQualifiedName();
                JSType declType = this.currentScope.getDeclaredTypeOf(name);
                if (doSlicing) {
                    pair.env = NewTypeInference.envPutType(pair.env, name, declType != null ? declType : JSType.UNKNOWN);
                }
                return new LValueResultBwd(pair.env, pair.type, pair.type.hasNonScalar() ? new QualifiedName(name) : null);
            }
            case 33: {
                Node obj = expr.getFirstChild();
                QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
            }
            case 35: {
                if (expr.getLastChild().isString()) {
                    Node obj = expr.getFirstChild();
                    QualifiedName pname = new QualifiedName(expr.getLastChild().getString());
                    return this.analyzePropLValBwd(obj, pname, outEnv, type, doSlicing);
                }
                EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
                return new LValueResultBwd(pair.env, pair.type, null);
            }
        }
        Preconditions.checkState((boolean)insideQualifiedName);
        EnvTypePair pair = this.analyzeExprBwd(expr, outEnv, type);
        return new LValueResultBwd(pair.env, pair.type, null);
    }

    private LValueResultBwd analyzePropLValBwd(Node obj, QualifiedName pname, TypeEnv outEnv, JSType type, boolean doSlicing) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        JSType reqObjType = NewTypeInference.pickReqObjType(obj).withLoose().withProperty(pname, type);
        LValueResultBwd lvalue = this.analyzeLValueBwd(obj, outEnv, reqObjType, false, true);
        if (lvalue.ptr != null) {
            lvalue.ptr = QualifiedName.join(lvalue.ptr, pname);
            if (doSlicing) {
                String objName = lvalue.ptr.getLeftmostName();
                QualifiedName props = lvalue.ptr.getAllButLeftmost();
                JSType objType = NewTypeInference.envGetType(lvalue.env, objName);
                JSType slicedObjType = objType.withoutProperty(props);
                lvalue.env = NewTypeInference.envPutType(lvalue.env, objName, slicedObjType);
            }
        }
        lvalue.type = lvalue.type.mayHaveProp(pname) ? lvalue.type.getProp(pname) : JSType.UNKNOWN;
        return lvalue;
    }

    private static JSType pickReqObjType(Node expr) {
        int exprKind = expr.getType();
        switch (exprKind) {
            case 35: 
            case 51: {
                return JSType.TOP_DICT;
            }
            case 115: {
                Preconditions.checkState((boolean)NodeUtil.isForIn(expr));
                return JSType.TOP_DICT;
            }
            case 64: {
                JSDocInfo jsdoc = expr.getJSDocInfo();
                if (jsdoc != null && jsdoc.makesStructs()) {
                    return JSType.TOP_STRUCT;
                }
                if (jsdoc != null && jsdoc.makesDicts()) {
                    return JSType.TOP_DICT;
                }
                return JSType.TOP_OBJECT;
            }
        }
        Node parent = expr.getParent();
        if (parent.isGetProp()) {
            return JSType.TOP_STRUCT;
        }
        if (parent.isGetElem()) {
            return JSType.TOP_DICT;
        }
        throw new RuntimeException("Unhandled node for pickReqObjType: " + Token.name(exprKind));
    }

    private static JSType specializeWithCorrection(JSType inferred, JSType required) {
        JSType specializedType = inferred.specialize(required);
        if (specializedType.isBottom()) {
            return required;
        }
        return specializedType;
    }

    TypeEnv getEntryTypeEnv() {
        return this.getOutEnv(this.cfg.getEntry());
    }

    private TypeEnv getFinalTypeEnv() {
        TypeEnv env = this.getInEnv(this.cfg.getImplicitReturn());
        if (env == null) {
            env = new TypeEnv();
            return NewTypeInference.envPutType(env, RETVAL_ID, JSType.BOTTOM);
        }
        return env;
    }

    @VisibleForTesting
    JSType getFormalType(int argpos) {
        Preconditions.checkState((this.summaries.size() == 1 ? 1 : 0) != 0);
        return this.summaries.values().iterator().next().getFunType().getFormalType(argpos);
    }

    @VisibleForTesting
    JSType getReturnType() {
        Preconditions.checkState((this.summaries.size() == 1 ? 1 : 0) != 0);
        return this.summaries.values().iterator().next().getFunType().getReturnType();
    }

    @VisibleForTesting
    JSType getDeclaredType(String varName) {
        return this.currentScope.getDeclaredTypeOf(varName);
    }

    private static class DeferredCheck {
        final Node callSite;
        final GlobalTypeInfo.Scope callerScope;
        final GlobalTypeInfo.Scope calleeScope;
        JSType expectedRetType;
        List<JSType> argTypes;

        DeferredCheck(Node callSite, JSType expectedRetType, GlobalTypeInfo.Scope callerScope, GlobalTypeInfo.Scope calleeScope) {
            this.callSite = callSite;
            this.expectedRetType = expectedRetType;
            this.callerScope = callerScope;
            this.calleeScope = calleeScope;
        }

        void updateReturn(JSType expectedRetType) {
            if (this.expectedRetType != null) {
                this.expectedRetType = JSType.meet(this.expectedRetType, expectedRetType);
            }
        }

        void updateArgTypes(List<JSType> argTypes) {
            this.argTypes = argTypes;
        }

        private void runCheck(Map<GlobalTypeInfo.Scope, JSType> summaries, WarningReporter warnings) {
            FunctionType fnSummary = summaries.get(this.calleeScope).getFunType();
            NewTypeInference.println(new Object[]{"Running deferred check of function: ", this.calleeScope.getReadableName(), " with FunctionSummary of: ", fnSummary, " and callsite ret: ", this.expectedRetType, " args: ", this.argTypes});
            if (this.expectedRetType != null && !fnSummary.getReturnType().isSubtypeOf(this.expectedRetType)) {
                warnings.add(JSError.make(this.callSite, INVALID_INFERRED_RETURN_TYPE, this.expectedRetType.toString(), fnSummary.getReturnType().toString()));
            }
            int i = 0;
            Node argNode = this.callSite.getFirstChild().getNext();
            if (this.argTypes == null) {
                return;
            }
            for (JSType argType : this.argTypes) {
                JSType formalType = fnSummary.getFormalType(i);
                Preconditions.checkState((!formalType.equals(JSType.topFunction()) ? 1 : 0) != 0);
                if (argNode.isName() && this.callerScope.isKnownFunction(argNode.getString())) {
                    argType = summaries.get(this.callerScope.getScope(argNode.getString()));
                }
                if (argType != null && !argType.isSubtypeOf(formalType)) {
                    warnings.add(JSError.make(argNode, INVALID_ARGUMENT_TYPE, Integer.toString(i + 1), this.calleeScope.getReadableName(), formalType.toString(), argType.toString()));
                }
                ++i;
                argNode = argNode.getNext();
            }
        }

        public boolean equals(Object o) {
            Preconditions.checkArgument((boolean)(o instanceof DeferredCheck));
            DeferredCheck dc2 = (DeferredCheck)o;
            return this.callSite == dc2.callSite && this.callerScope == dc2.callerScope && this.calleeScope == dc2.calleeScope && Objects.equals(this.expectedRetType, dc2.expectedRetType) && Objects.equals(this.argTypes, dc2.argTypes);
        }

        public int hashCode() {
            return Objects.hash(this.callSite, this.callerScope, this.calleeScope, this.expectedRetType, this.argTypes);
        }
    }

    private static class LValueResultBwd {
        TypeEnv env;
        JSType type;
        QualifiedName ptr;

        LValueResultBwd(TypeEnv env, JSType type, QualifiedName ptr) {
            Preconditions.checkNotNull((Object)type);
            this.env = env;
            this.type = type;
            this.ptr = ptr;
        }
    }

    private static class LValueResultFwd {
        TypeEnv env;
        JSType type;
        JSType declType;
        QualifiedName ptr;

        LValueResultFwd(TypeEnv env, JSType type, JSType declType, QualifiedName ptr) {
            Preconditions.checkNotNull((Object)type);
            this.env = env;
            this.type = type;
            this.declType = declType;
            this.ptr = ptr;
        }
    }

    private static class EnvTypePair {
        TypeEnv env;
        JSType type;

        EnvTypePair(TypeEnv env, JSType type) {
            this.env = env;
            this.type = type;
        }

        static EnvTypePair addBinding(TypeEnv env, String varName, JSType type) {
            return new EnvTypePair(NewTypeInference.envPutType(env, varName, type), type);
        }

        static EnvTypePair join(EnvTypePair p1, EnvTypePair p2) {
            return new EnvTypePair(TypeEnv.join(p1.env, p2.env), JSType.join(p1.type, p2.type));
        }
    }

    public static class WarningReporter {
        AbstractCompiler compiler;

        WarningReporter(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        void add(JSError warning) {
            if (!JSType.mockToString) {
                this.compiler.report(warning);
            }
        }
    }
}

