/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ug" locale.
 */
public class LocalizedNamesImpl_ug extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AR",
        "AW",
        "AC",
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "UM",
        "VI",
        "US",
        "AQ",
        "AG",
        "AD",
        "AO",
        "AI",
        "AU",
        "AT",
        "MO",
        "CF",
        "QO",
        "OM",
        "IT",
        "IQ",
        "IR",
        "IE",
        "IL",
        "IS",
        "ES",
        "JO",
        "UZ",
        "UY",
        "UA",
        "UG",
        "ER",
        "EE",
        "ET",
        "GQ",
        "EC",
        "AM",
        "AE",
        "AZ",
        "SV",
        "IO",
        "GB",
        "VG",
        "BB",
        "BD",
        "BS",
        "BW",
        "BA",
        "BO",
        "BR",
        "MM",
        "BN",
        "BT",
        "BF",
        "BI",
        "BG",
        "BV",
        "BM",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BH",
        "TJ",
        "TZ",
        "TH",
        "TA",
        "TK",
        "TO",
        "TG",
        "TT",
        "TC",
        "TN",
        "TV",
        "TM",
        "TR",
        "TW",
        "DJ",
        "CN",
        "JE",
        "GI",
        "ZA",
        "GS",
        "SS",
        "KR",
        "HM",
        "DK",
        "DM",
        "DO",
        "DG",
        "CX",
        "RW",
        "RU",
        "RO",
        "RE",
        "ZM",
        "ZW",
        "WS",
        "ST",
        "SM",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "SH",
        "VC",
        "SB",
        "SO",
        "LK",
        "SK",
        "SI",
        "SX",
        "SG",
        "CY",
        "SJ",
        "SZ",
        "SD",
        "SR",
        "SY",
        "RS",
        "SL",
        "SN",
        "EA",
        "SC",
        "SA",
        "KP",
        "MP",
        "CH",
        "SE",
        "HK",
        "TL",
        "EH",
        "FO",
        "FK",
        "FJ",
        "FR",
        "TF",
        "PF",
        "GF",
        "PH",
        "FI",
        "QA",
        "KZ",
        "KG",
        "BQ",
        "KH",
        "CM",
        "CA",
        "IC",
        "KY",
        "CI",
        "CR",
        "XK",
        "CO",
        "KM",
        "CG",
        "CD",
        "HR",
        "KI",
        "CP",
        "CU",
        "CW",
        "CK",
        "KW",
        "KE",
        "CC",
        "LA",
        "LV",
        "LR",
        "LT",
        "LU",
        "LI",
        "LB",
        "LY",
        "LS",
        "MG",
        "MA",
        "MQ",
        "MH",
        "MK",
        "MY",
        "MW",
        "MT",
        "MV",
        "ML",
        "YT",
        "MR",
        "MU",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MN",
        "EG",
        "FM",
        "MX",
        "IM",
        "NA",
        "NR",
        "NF",
        "NO",
        "NI",
        "NU",
        "NG",
        "NP",
        "NE",
        "JM",
        "JP",
        "EU",
        "CV",
        "NZ",
        "NC",
        "YE",
        "PY",
        "PK",
        "PW",
        "PA",
        "PG",
        "PT",
        "PL",
        "PN",
        "PR",
        "PE",
        "PS",
        "TD",
        "CL",
        "CZ",
        "GA",
        "GM",
        "GH",
        "NL",
        "GE",
        "GR",
        "GD",
        "GL",
        "GT",
        "GP",
        "GN",
        "GW",
        "GY",
        "GU",
        "DE",
        "GG",
        "HT",
        "HN",
        "ID",
        "IN",
        "VA",
        "WF",
        "VU",
        "VN",
        "HU",
        "VE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "دۇنيا");
    namesMap.put("002", "ئافرىقا");
    namesMap.put("003", "شىمالىي ئامېرىكا");
    namesMap.put("005", "جەنۇبىي ئامېرىكا");
    namesMap.put("009", "ئوكيانىيە");
    namesMap.put("011", "غەربىي ئافرىقا");
    namesMap.put("013", "ئوتتۇرا ئامېرىكا");
    namesMap.put("014", "شەرقىي ئافرىقا");
    namesMap.put("015", "شىمالىي ئافرىقا");
    namesMap.put("017", "ئوتتۇرا ئافرىقا");
    namesMap.put("018", "جەنۇبىي ئافرىقا رايونى");
    namesMap.put("019", "ئامېرىكا");
    namesMap.put("021", "شىمالىي ئامېرىكا رايونى");
    namesMap.put("029", "كارىب دېڭىزى");
    namesMap.put("030", "شەرقىي ئاسىيا");
    namesMap.put("034", "جەنۇبىي ئاسىيا");
    namesMap.put("035", "شەرقىي جەنۇبىي ئاسىيا");
    namesMap.put("039", "جەنۇبىي ياۋروپا");
    namesMap.put("053", "ئاۋسترالئاسىيا");
    namesMap.put("054", "مېلانېسىيە");
    namesMap.put("057", "مىكرونېزىيە رايونى");
    namesMap.put("061", "پولىنىزىيە");
    namesMap.put("142", "ئاسىيا");
    namesMap.put("143", "ئوتتۇرا ئاسىيا");
    namesMap.put("145", "غەربىي ئاسىيا");
    namesMap.put("150", "ياۋروپا");
    namesMap.put("151", "شەرقىي ياۋروپا");
    namesMap.put("154", "شىمالىي ياۋروپا");
    namesMap.put("155", "غەربىي ياۋروپا");
    namesMap.put("419", "لاتىن ئامېرىكا");
    namesMap.put("AC", "ئاسسېنسىيون ئارىلى");
    namesMap.put("AD", "ئاندوررا");
    namesMap.put("AE", "ئەرەب بىرلەشمە خەلىپىلىكى");
    namesMap.put("AF", "ئافغانىستان");
    namesMap.put("AG", "ئانتىگۋا ۋە باربۇدا");
    namesMap.put("AI", "ئانگۋىللا");
    namesMap.put("AL", "ئالبانىيە");
    namesMap.put("AM", "ئەرمېنىيە");
    namesMap.put("AO", "ئانگولا");
    namesMap.put("AQ", "ئانتاركتىكا");
    namesMap.put("AR", "ئارگېنتىنا");
    namesMap.put("AS", "ئامېرىكا تەۋەلىكىدىكى ساموئا");
    namesMap.put("AT", "ئاۋسترىيە");
    namesMap.put("AU", "ئاۋسترالىيە");
    namesMap.put("AW", "ئارۇبا");
    namesMap.put("AX", "ئالاند ئاراللىرى");
    namesMap.put("AZ", "ئەزەربەيجان");
    namesMap.put("BA", "بوسنىيە-گېرتسېگوۋىنا");
    namesMap.put("BB", "باربادوس");
    namesMap.put("BD", "باڭلادىش");
    namesMap.put("BE", "بېلگىيە");
    namesMap.put("BF", "بۇركىنا-فاسو");
    namesMap.put("BG", "بۇلغارىيە");
    namesMap.put("BH", "بەھرەين");
    namesMap.put("BI", "بۇرۇندى");
    namesMap.put("BJ", "بېنىن");
    namesMap.put("BL", "ساينىت-بارتھېلەمي ئاراللىرى");
    namesMap.put("BM", "بېرمۇدا");
    namesMap.put("BN", "بىرۇنېي");
    namesMap.put("BO", "بولىۋىيە");
    namesMap.put("BQ", "كارىب دېڭىزى گوللاندىيە");
    namesMap.put("BR", "بىرازىلىيە");
    namesMap.put("BS", "باھاما");
    namesMap.put("BT", "بۇتان");
    namesMap.put("BV", "بۇۋېت ئاراللىرى");
    namesMap.put("BW", "بوتسۋانا");
    namesMap.put("BY", "بېلارۇسىيە");
    namesMap.put("BZ", "بېلىز");
    namesMap.put("CA", "كانادا");
    namesMap.put("CC", "كەئەلىڭ كوكۇس ئاراللىرى");
    namesMap.put("CD", "كونگو - كىنشاسا");
    namesMap.put("CF", "ئوتتۇرا ئافرىقا جۇمھۇرىيىتى");
    namesMap.put("CG", "كونگو - بىراززاۋىل");
    namesMap.put("CH", "شىۋىتسارىيە");
    namesMap.put("CI", "كوتې دې ئىۋوئىر");
    namesMap.put("CK", "كۇك ئاراللىرى");
    namesMap.put("CL", "چىلى");
    namesMap.put("CM", "كامېرون");
    namesMap.put("CN", "جۇڭگو");
    namesMap.put("CO", "كولومبىيە");
    namesMap.put("CP", "كىلىپپېرتون ئاراللىرى");
    namesMap.put("CR", "كوستارىكا");
    namesMap.put("CU", "كۇبا");
    namesMap.put("CV", "يېشىل تۇمشۇق");
    namesMap.put("CW", "كۇراسو");
    namesMap.put("CX", "روژدېستۋو ئارىلى");
    namesMap.put("CY", "سىپرۇس");
    namesMap.put("CZ", "چېخ جۇمھۇرىيىتى");
    namesMap.put("DE", "گېرمانىيە");
    namesMap.put("DG", "دېگو-گارشىيا");
    namesMap.put("DJ", "جىبۇتى");
    namesMap.put("DK", "دانىيە");
    namesMap.put("DM", "دومىنىكا");
    namesMap.put("DO", "دومىنىكا جۇمھۇرىيىتى");
    namesMap.put("DZ", "ئالجىرىيە");
    namesMap.put("EA", "سېيتا ۋە مېلىلا");
    namesMap.put("EC", "ئېكۋادور");
    namesMap.put("EE", "ئېستونىيە");
    namesMap.put("EG", "مىسىر");
    namesMap.put("EH", "غەربىي ساخارا");
    namesMap.put("ER", "ئېرىترېيە");
    namesMap.put("ES", "ئىسپانىيە");
    namesMap.put("ET", "ئېفىيوپىيە");
    namesMap.put("EU", "ياۋروپا ئىتتىپاقى");
    namesMap.put("FI", "فىنلاندىيە");
    namesMap.put("FJ", "فىجى");
    namesMap.put("FK", "فالكلاند ئاراللىرى");
    namesMap.put("FM", "مىكرونېزىيە");
    namesMap.put("FO", "فائېرو ئاراللىرى");
    namesMap.put("FR", "فىرانسىيە");
    namesMap.put("GA", "گابون");
    namesMap.put("GB", "ئەنگلىيە پادىشاھلىقى");
    namesMap.put("GD", "گىرېنادا");
    namesMap.put("GE", "گىروزىيە");
    namesMap.put("GF", "فىرانسىيەگە قاراشلىق گىۋىيانا");
    namesMap.put("GG", "گېرىنسى");
    namesMap.put("GH", "گانا");
    namesMap.put("GI", "جەبىلتارىق");
    namesMap.put("GL", "گىرېنلاند");
    namesMap.put("GM", "گامبىيە");
    namesMap.put("GN", "گىۋىنېيە");
    namesMap.put("GP", "گىۋادېلۇپ");
    namesMap.put("GQ", "ئېكۋاتور گىۋىنېيەسى");
    namesMap.put("GR", "گىرېتسىيە");
    namesMap.put("GS", "جەنۇبىي جورجىيە ۋە جەنۇبىي ساندىۋىچ ئاراللىرى");
    namesMap.put("GT", "گىۋاتېمالا");
    namesMap.put("GU", "گۇئام");
    namesMap.put("GW", "گىۋىنېيە-بىسسائۇ");
    namesMap.put("GY", "گىۋىيانا");
    namesMap.put("HK", "شياڭگاڭ ئالاھىدە مەمۇرىي رايونى (جۇڭگو)");
    namesMap.put("HM", "خېرد ۋە ماك-دونالد ئارىلى");
    namesMap.put("HN", "ھوندۇراس");
    namesMap.put("HR", "كىرودىيە");
    namesMap.put("HT", "ھايتى");
    namesMap.put("HU", "ۋېنگىرىيە");
    namesMap.put("IC", "كانارى ئاراللىرى");
    namesMap.put("ID", "ھىندونېزىيە");
    namesMap.put("IE", "ئىرېلاندىيە");
    namesMap.put("IL", "ئىسرائىلىيە");
    namesMap.put("IM", "مېن ئارىلى");
    namesMap.put("IN", "ھىندىستان");
    namesMap.put("IO", "ئەنگلىيەنىڭ ھىندى ئوكياندىكى تەۋەلىكى");
    namesMap.put("IQ", "ئىراق");
    namesMap.put("IR", "ئىران");
    namesMap.put("IS", "ئىسلاندىيە");
    namesMap.put("IT", "ئىتالىيە");
    namesMap.put("JE", "جېرسېي");
    namesMap.put("JM", "يامايكا");
    namesMap.put("JO", "ئىيوردانىيە");
    namesMap.put("JP", "ياپونىيە");
    namesMap.put("KE", "كېنىيە");
    namesMap.put("KG", "قىرغىزىستان");
    namesMap.put("KH", "كامبودژا");
    namesMap.put("KI", "كىرىباتى");
    namesMap.put("KM", "كومورو");
    namesMap.put("KN", "ساينىت-كىرىستوفېر ۋە نېۋىس");
    namesMap.put("KP", "شىمالىي كورىيە");
    namesMap.put("KR", "جەنۇبىي كورىيە");
    namesMap.put("KW", "كۇۋەيت");
    namesMap.put("KY", "كايمان ئاراللىرى");
    namesMap.put("KZ", "قازاقىستان");
    namesMap.put("LA", "لائوس");
    namesMap.put("LB", "لىۋان");
    namesMap.put("LC", "ساينىت-لۇسىيە");
    namesMap.put("LI", "لىچتېنشتېين بەگلىكى");
    namesMap.put("LK", "سىرىلانكا");
    namesMap.put("LR", "لىبېرىيە");
    namesMap.put("LS", "لېسوتو");
    namesMap.put("LT", "لىتۋانىيە");
    namesMap.put("LU", "لىيۇكسېمبۇرگ");
    namesMap.put("LV", "لاتۋىيە");
    namesMap.put("LY", "لىۋىيە");
    namesMap.put("MA", "ماراكەش");
    namesMap.put("MC", "موناكو");
    namesMap.put("MD", "مولدوۋا");
    namesMap.put("ME", "مونتېنېگرو");
    namesMap.put("MF", "ساينىت-مارتېن");
    namesMap.put("MG", "ماداغاسقار");
    namesMap.put("MH", "مارشال ئاراللىرى");
    namesMap.put("MK", "ماكېدونىيە");
    namesMap.put("ML", "مالى");
    namesMap.put("MM", "بىرما");
    namesMap.put("MN", "موڭغۇلىيە");
    namesMap.put("MO", "ئاۋمېن ئالاھىدە مەمۇرىي رايونى (جۇڭگو)");
    namesMap.put("MP", "شىمالىي مارىيانا ئاراللىرى");
    namesMap.put("MQ", "مارتىنىكا");
    namesMap.put("MR", "ماۋرىتانىيە");
    namesMap.put("MS", "مونتسېررات");
    namesMap.put("MT", "مالتا");
    namesMap.put("MU", "ماۋرىتىئۇس");
    namesMap.put("MV", "مالدىۋې");
    namesMap.put("MW", "مالاۋى");
    namesMap.put("MX", "مېكسىكا");
    namesMap.put("MY", "مالايشىيا");
    namesMap.put("MZ", "موزامبىك");
    namesMap.put("NA", "نامىبىيە");
    namesMap.put("NC", "يېڭى كالېدونىيە");
    namesMap.put("NE", "نېگىر");
    namesMap.put("NF", "نورفولك ئارىلى");
    namesMap.put("NG", "نىگېرىيە");
    namesMap.put("NI", "نىكاراگۇئا");
    namesMap.put("NL", "گوللاندىيە");
    namesMap.put("NO", "نورۋېگىيە");
    namesMap.put("NP", "نېپال");
    namesMap.put("NR", "ناۋرۇ");
    namesMap.put("NU", "نىيۇئې");
    namesMap.put("NZ", "يېڭى زېلاندىيە");
    namesMap.put("OM", "ئومان");
    namesMap.put("PA", "پاناما");
    namesMap.put("PE", "پېرۇ");
    namesMap.put("PF", "فىرانسىيەگە قاراشلىق پولىنېزىيە");
    namesMap.put("PG", "پاپۇئا يېڭى گىۋىنېيەسى");
    namesMap.put("PH", "فىلىپپىن");
    namesMap.put("PK", "پاكىستان");
    namesMap.put("PL", "پولشا");
    namesMap.put("PM", "ساينىت-پىئېر ۋە مىكېلون ئاراللىرى");
    namesMap.put("PN", "پىتكاير ئاراللىرى");
    namesMap.put("PR", "پۇئېرتو-رىكو");
    namesMap.put("PS", "پەلەستىن زېمىنى");
    namesMap.put("PT", "پورتۇگالىيە");
    namesMap.put("PW", "پالاۋ");
    namesMap.put("PY", "پاراگۋاي");
    namesMap.put("QA", "قاتار");
    namesMap.put("QO", "ئوكيانىيە ئەتراپىدىكى ئاراللار");
    namesMap.put("RE", "رېئونىيون");
    namesMap.put("RO", "رۇمىنىيە");
    namesMap.put("RS", "سېربىيە");
    namesMap.put("RU", "رۇسىيە");
    namesMap.put("RW", "رىۋاندا");
    namesMap.put("SA", "سەئۇدى ئەرەبىستان");
    namesMap.put("SB", "سولومون ئاراللىرى");
    namesMap.put("SC", "سېيشېل");
    namesMap.put("SD", "سۇدان");
    namesMap.put("SE", "شىۋېتسىيە");
    namesMap.put("SG", "سىنگاپور");
    namesMap.put("SH", "ساينىت ھېلېنا");
    namesMap.put("SI", "سىلوۋېنىيە");
    namesMap.put("SJ", "سىۋالبارد ۋە يان-مايېن ئارىلى");
    namesMap.put("SK", "سىلوۋاكىيە");
    namesMap.put("SL", "سېررالېئون");
    namesMap.put("SM", "سان-مارىنو");
    namesMap.put("SN", "سېنېگال");
    namesMap.put("SO", "سومالى");
    namesMap.put("SR", "سۇرىنام");
    namesMap.put("SS", "جەنۇبىي سۇدان");
    namesMap.put("ST", "سان تومې ۋە پرىنسىپې");
    namesMap.put("SV", "ئەل سالۋادور");
    namesMap.put("SX", "سىنت مارتېن");
    namesMap.put("SY", "سۈرىيە");
    namesMap.put("SZ", "سىۋېزىلاند");
    namesMap.put("TA", "ترىستان داكۇنھا");
    namesMap.put("TC", "تۇركس ۋە كايكوس ئاراللىرى");
    namesMap.put("TD", "چاد");
    namesMap.put("TF", "فىرانسىيەگە قاراشلىق جەنۇبتىكى زېمىنلىرى");
    namesMap.put("TG", "توگو");
    namesMap.put("TH", "تايلاند");
    namesMap.put("TJ", "تاجىكىستان");
    namesMap.put("TK", "توكېلاۋ");
    namesMap.put("TL", "شەرقىي تىمور");
    namesMap.put("TM", "تۈركمەنىستان");
    namesMap.put("TN", "تۇنىس");
    namesMap.put("TO", "تونگا");
    namesMap.put("TR", "تۈركىيە");
    namesMap.put("TT", "تىرىنىداد ۋە توباگو");
    namesMap.put("TV", "تۇۋالۇ");
    namesMap.put("TW", "تەيۋەن");
    namesMap.put("TZ", "تانزانىيە");
    namesMap.put("UA", "ئۇكرائىنا");
    namesMap.put("UG", "ئۇگاندا");
    namesMap.put("UM", "ئامېرىكا تەۋەلىكىدىكى سىرتقى كىچىك ئاراللار");
    namesMap.put("US", "ئامېرىكا قوشما شتاتلىرى");
    namesMap.put("UY", "ئۇرۇگۋاي");
    namesMap.put("UZ", "ئۆزبېكىستان");
    namesMap.put("VA", "ۋاتىكان شەھىرى");
    namesMap.put("VC", "ساينىت-ۋىنسېنت ۋە گىرېنادىنېس");
    namesMap.put("VE", "ۋېنېزۇئېلا");
    namesMap.put("VG", "ئەنگلىيەگە قاراشلىق ۋىرجىن ئارىلى");
    namesMap.put("VI", "ئامېرىكا تەۋەلىكىدىكى ۋىرجىن تاقىم ئاراللىرى");
    namesMap.put("VN", "ۋىيېتنام");
    namesMap.put("VU", "ۋانۇئاتۇ");
    namesMap.put("WF", "ۋالىس ۋە فۇتۇنا");
    namesMap.put("WS", "ساموئا");
    namesMap.put("XK", "كوسوۋو");
    namesMap.put("YE", "يەمەن");
    namesMap.put("YT", "مايوتتې");
    namesMap.put("ZA", "جەنۇبىي ئافرىقا");
    namesMap.put("ZM", "زامبىيە");
    namesMap.put("ZW", "زىمبابۋې");
    namesMap.put("ZZ", "يوچۇن جاي");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "دۇنيا",
        "002": "ئافرىقا",
        "003": "شىمالىي ئامېرىكا",
        "005": "جەنۇبىي ئامېرىكا",
        "009": "ئوكيانىيە",
        "011": "غەربىي ئافرىقا",
        "013": "ئوتتۇرا ئامېرىكا",
        "014": "شەرقىي ئافرىقا",
        "015": "شىمالىي ئافرىقا",
        "017": "ئوتتۇرا ئافرىقا",
        "018": "جەنۇبىي ئافرىقا رايونى",
        "019": "ئامېرىكا",
        "021": "شىمالىي ئامېرىكا رايونى",
        "029": "كارىب دېڭىزى",
        "030": "شەرقىي ئاسىيا",
        "034": "جەنۇبىي ئاسىيا",
        "035": "شەرقىي جەنۇبىي ئاسىيا",
        "039": "جەنۇبىي ياۋروپا",
        "053": "ئاۋسترالئاسىيا",
        "054": "مېلانېسىيە",
        "057": "مىكرونېزىيە رايونى",
        "061": "پولىنىزىيە",
        "142": "ئاسىيا",
        "143": "ئوتتۇرا ئاسىيا",
        "145": "غەربىي ئاسىيا",
        "150": "ياۋروپا",
        "151": "شەرقىي ياۋروپا",
        "154": "شىمالىي ياۋروپا",
        "155": "غەربىي ياۋروپا",
        "419": "لاتىن ئامېرىكا",
        "AC": "ئاسسېنسىيون ئارىلى",
        "AD": "ئاندوررا",
        "AE": "ئەرەب بىرلەشمە خەلىپىلىكى",
        "AF": "ئافغانىستان",
        "AG": "ئانتىگۋا ۋە باربۇدا",
        "AI": "ئانگۋىللا",
        "AL": "ئالبانىيە",
        "AM": "ئەرمېنىيە",
        "AO": "ئانگولا",
        "AQ": "ئانتاركتىكا",
        "AR": "ئارگېنتىنا",
        "AS": "ئامېرىكا تەۋەلىكىدىكى ساموئا",
        "AT": "ئاۋسترىيە",
        "AU": "ئاۋسترالىيە",
        "AW": "ئارۇبا",
        "AX": "ئالاند ئاراللىرى",
        "AZ": "ئەزەربەيجان",
        "BA": "بوسنىيە-گېرتسېگوۋىنا",
        "BB": "باربادوس",
        "BD": "باڭلادىش",
        "BE": "بېلگىيە",
        "BF": "بۇركىنا-فاسو",
        "BG": "بۇلغارىيە",
        "BH": "بەھرەين",
        "BI": "بۇرۇندى",
        "BJ": "بېنىن",
        "BL": "ساينىت-بارتھېلەمي ئاراللىرى",
        "BM": "بېرمۇدا",
        "BN": "بىرۇنېي",
        "BO": "بولىۋىيە",
        "BQ": "كارىب دېڭىزى گوللاندىيە",
        "BR": "بىرازىلىيە",
        "BS": "باھاما",
        "BT": "بۇتان",
        "BV": "بۇۋېت ئاراللىرى",
        "BW": "بوتسۋانا",
        "BY": "بېلارۇسىيە",
        "BZ": "بېلىز",
        "CA": "كانادا",
        "CC": "كەئەلىڭ كوكۇس ئاراللىرى",
        "CD": "كونگو - كىنشاسا",
        "CF": "ئوتتۇرا ئافرىقا جۇمھۇرىيىتى",
        "CG": "كونگو - بىراززاۋىل",
        "CH": "شىۋىتسارىيە",
        "CI": "كوتې دې ئىۋوئىر",
        "CK": "كۇك ئاراللىرى",
        "CL": "چىلى",
        "CM": "كامېرون",
        "CN": "جۇڭگو",
        "CO": "كولومبىيە",
        "CP": "كىلىپپېرتون ئاراللىرى",
        "CR": "كوستارىكا",
        "CU": "كۇبا",
        "CV": "يېشىل تۇمشۇق",
        "CW": "كۇراسو",
        "CX": "روژدېستۋو ئارىلى",
        "CY": "سىپرۇس",
        "CZ": "چېخ جۇمھۇرىيىتى",
        "DE": "گېرمانىيە",
        "DG": "دېگو-گارشىيا",
        "DJ": "جىبۇتى",
        "DK": "دانىيە",
        "DM": "دومىنىكا",
        "DO": "دومىنىكا جۇمھۇرىيىتى",
        "DZ": "ئالجىرىيە",
        "EA": "سېيتا ۋە مېلىلا",
        "EC": "ئېكۋادور",
        "EE": "ئېستونىيە",
        "EG": "مىسىر",
        "EH": "غەربىي ساخارا",
        "ER": "ئېرىترېيە",
        "ES": "ئىسپانىيە",
        "ET": "ئېفىيوپىيە",
        "EU": "ياۋروپا ئىتتىپاقى",
        "FI": "فىنلاندىيە",
        "FJ": "فىجى",
        "FK": "فالكلاند ئاراللىرى",
        "FM": "مىكرونېزىيە",
        "FO": "فائېرو ئاراللىرى",
        "FR": "فىرانسىيە",
        "GA": "گابون",
        "GB": "ئەنگلىيە پادىشاھلىقى",
        "GD": "گىرېنادا",
        "GE": "گىروزىيە",
        "GF": "فىرانسىيەگە قاراشلىق گىۋىيانا",
        "GG": "گېرىنسى",
        "GH": "گانا",
        "GI": "جەبىلتارىق",
        "GL": "گىرېنلاند",
        "GM": "گامبىيە",
        "GN": "گىۋىنېيە",
        "GP": "گىۋادېلۇپ",
        "GQ": "ئېكۋاتور گىۋىنېيەسى",
        "GR": "گىرېتسىيە",
        "GS": "جەنۇبىي جورجىيە ۋە جەنۇبىي ساندىۋىچ ئاراللىرى",
        "GT": "گىۋاتېمالا",
        "GU": "گۇئام",
        "GW": "گىۋىنېيە-بىسسائۇ",
        "GY": "گىۋىيانا",
        "HK": "شياڭگاڭ ئالاھىدە مەمۇرىي رايونى (جۇڭگو)",
        "HM": "خېرد ۋە ماك-دونالد ئارىلى",
        "HN": "ھوندۇراس",
        "HR": "كىرودىيە",
        "HT": "ھايتى",
        "HU": "ۋېنگىرىيە",
        "IC": "كانارى ئاراللىرى",
        "ID": "ھىندونېزىيە",
        "IE": "ئىرېلاندىيە",
        "IL": "ئىسرائىلىيە",
        "IM": "مېن ئارىلى",
        "IN": "ھىندىستان",
        "IO": "ئەنگلىيەنىڭ ھىندى ئوكياندىكى تەۋەلىكى",
        "IQ": "ئىراق",
        "IR": "ئىران",
        "IS": "ئىسلاندىيە",
        "IT": "ئىتالىيە",
        "JE": "جېرسېي",
        "JM": "يامايكا",
        "JO": "ئىيوردانىيە",
        "JP": "ياپونىيە",
        "KE": "كېنىيە",
        "KG": "قىرغىزىستان",
        "KH": "كامبودژا",
        "KI": "كىرىباتى",
        "KM": "كومورو",
        "KN": "ساينىت-كىرىستوفېر ۋە نېۋىس",
        "KP": "شىمالىي كورىيە",
        "KR": "جەنۇبىي كورىيە",
        "KW": "كۇۋەيت",
        "KY": "كايمان ئاراللىرى",
        "KZ": "قازاقىستان",
        "LA": "لائوس",
        "LB": "لىۋان",
        "LC": "ساينىت-لۇسىيە",
        "LI": "لىچتېنشتېين بەگلىكى",
        "LK": "سىرىلانكا",
        "LR": "لىبېرىيە",
        "LS": "لېسوتو",
        "LT": "لىتۋانىيە",
        "LU": "لىيۇكسېمبۇرگ",
        "LV": "لاتۋىيە",
        "LY": "لىۋىيە",
        "MA": "ماراكەش",
        "MC": "موناكو",
        "MD": "مولدوۋا",
        "ME": "مونتېنېگرو",
        "MF": "ساينىت-مارتېن",
        "MG": "ماداغاسقار",
        "MH": "مارشال ئاراللىرى",
        "MK": "ماكېدونىيە",
        "ML": "مالى",
        "MM": "بىرما",
        "MN": "موڭغۇلىيە",
        "MO": "ئاۋمېن ئالاھىدە مەمۇرىي رايونى (جۇڭگو)",
        "MP": "شىمالىي مارىيانا ئاراللىرى",
        "MQ": "مارتىنىكا",
        "MR": "ماۋرىتانىيە",
        "MS": "مونتسېررات",
        "MT": "مالتا",
        "MU": "ماۋرىتىئۇس",
        "MV": "مالدىۋې",
        "MW": "مالاۋى",
        "MX": "مېكسىكا",
        "MY": "مالايشىيا",
        "MZ": "موزامبىك",
        "NA": "نامىبىيە",
        "NC": "يېڭى كالېدونىيە",
        "NE": "نېگىر",
        "NF": "نورفولك ئارىلى",
        "NG": "نىگېرىيە",
        "NI": "نىكاراگۇئا",
        "NL": "گوللاندىيە",
        "NO": "نورۋېگىيە",
        "NP": "نېپال",
        "NR": "ناۋرۇ",
        "NU": "نىيۇئې",
        "NZ": "يېڭى زېلاندىيە",
        "OM": "ئومان",
        "PA": "پاناما",
        "PE": "پېرۇ",
        "PF": "فىرانسىيەگە قاراشلىق پولىنېزىيە",
        "PG": "پاپۇئا يېڭى گىۋىنېيەسى",
        "PH": "فىلىپپىن",
        "PK": "پاكىستان",
        "PL": "پولشا",
        "PM": "ساينىت-پىئېر ۋە مىكېلون ئاراللىرى",
        "PN": "پىتكاير ئاراللىرى",
        "PR": "پۇئېرتو-رىكو",
        "PS": "پەلەستىن زېمىنى",
        "PT": "پورتۇگالىيە",
        "PW": "پالاۋ",
        "PY": "پاراگۋاي",
        "QA": "قاتار",
        "QO": "ئوكيانىيە ئەتراپىدىكى ئاراللار",
        "RE": "رېئونىيون",
        "RO": "رۇمىنىيە",
        "RS": "سېربىيە",
        "RU": "رۇسىيە",
        "RW": "رىۋاندا",
        "SA": "سەئۇدى ئەرەبىستان",
        "SB": "سولومون ئاراللىرى",
        "SC": "سېيشېل",
        "SD": "سۇدان",
        "SE": "شىۋېتسىيە",
        "SG": "سىنگاپور",
        "SH": "ساينىت ھېلېنا",
        "SI": "سىلوۋېنىيە",
        "SJ": "سىۋالبارد ۋە يان-مايېن ئارىلى",
        "SK": "سىلوۋاكىيە",
        "SL": "سېررالېئون",
        "SM": "سان-مارىنو",
        "SN": "سېنېگال",
        "SO": "سومالى",
        "SR": "سۇرىنام",
        "SS": "جەنۇبىي سۇدان",
        "ST": "سان تومې ۋە پرىنسىپې",
        "SV": "ئەل سالۋادور",
        "SX": "سىنت مارتېن",
        "SY": "سۈرىيە",
        "SZ": "سىۋېزىلاند",
        "TA": "ترىستان داكۇنھا",
        "TC": "تۇركس ۋە كايكوس ئاراللىرى",
        "TD": "چاد",
        "TF": "فىرانسىيەگە قاراشلىق جەنۇبتىكى زېمىنلىرى",
        "TG": "توگو",
        "TH": "تايلاند",
        "TJ": "تاجىكىستان",
        "TK": "توكېلاۋ",
        "TL": "شەرقىي تىمور",
        "TM": "تۈركمەنىستان",
        "TN": "تۇنىس",
        "TO": "تونگا",
        "TR": "تۈركىيە",
        "TT": "تىرىنىداد ۋە توباگو",
        "TV": "تۇۋالۇ",
        "TW": "تەيۋەن",
        "TZ": "تانزانىيە",
        "UA": "ئۇكرائىنا",
        "UG": "ئۇگاندا",
        "UM": "ئامېرىكا تەۋەلىكىدىكى سىرتقى كىچىك ئاراللار",
        "US": "ئامېرىكا قوشما شتاتلىرى",
        "UY": "ئۇرۇگۋاي",
        "UZ": "ئۆزبېكىستان",
        "VA": "ۋاتىكان شەھىرى",
        "VC": "ساينىت-ۋىنسېنت ۋە گىرېنادىنېس",
        "VE": "ۋېنېزۇئېلا",
        "VG": "ئەنگلىيەگە قاراشلىق ۋىرجىن ئارىلى",
        "VI": "ئامېرىكا تەۋەلىكىدىكى ۋىرجىن تاقىم ئاراللىرى",
        "VN": "ۋىيېتنام",
        "VU": "ۋانۇئاتۇ",
        "WF": "ۋالىس ۋە فۇتۇنا",
        "WS": "ساموئا",
        "XK": "كوسوۋو",
        "YE": "يەمەن",
        "YT": "مايوتتې",
        "ZA": "جەنۇبىي ئافرىقا",
        "ZM": "زامبىيە",
        "ZW": "زىمبابۋې",
        "ZZ": "يوچۇن جاي"
    };
  }-*/;
}
