/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.Image;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class CustomButtonParser
implements ElementParser {
    private static final Set<String> faceNames = new HashSet<String>();
    private static final String IMAGE_CLASS = Image.class.getCanonicalName();

    @Override
    public void parse(final XMLElement elem, final String fieldName, JClassType type, final UiBinderWriter writer) throws UnableToCompleteException {
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                HtmlInterpreter interpreter;
                String innerHtml;
                String ns = child.getNamespaceUri();
                String faceName = child.getLocalName();
                if (!ns.equals(elem.getNamespaceUri())) {
                    writer.die(elem, "Invalid child namespace: %s", new Object[]{ns});
                }
                if (!faceNames.contains(faceName)) {
                    writer.die(elem, "Invalid CustomButton face: %s:%s", new Object[]{ns, faceName});
                }
                if ((innerHtml = child.consumeInnerHtml((XMLElement.Interpreter)(interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName)))).length() > 0) {
                    writer.addStatement("%s.%s().setHTML(%s);", new Object[]{fieldName, CustomButtonParser.this.faceNameGetter(faceName), writer.declareTemplateCall(innerHtml, fieldName)});
                }
                if (child.hasAttribute("image")) {
                    String image = child.consumeImageResourceAttribute("image");
                    writer.addStatement("%s.%s().setImage(new %s(%s));", new Object[]{fieldName, CustomButtonParser.this.faceNameGetter(faceName), IMAGE_CLASS, image});
                }
                return true;
            }
        });
    }

    private String faceNameGetter(String faceName) {
        return "get" + faceName.substring(0, 1).toUpperCase(Locale.ROOT) + faceName.substring(1);
    }

    static {
        faceNames.add("upFace");
        faceNames.add("downFace");
        faceNames.add("upHoveringFace");
        faceNames.add("downHoveringFace");
        faceNames.add("upDisabledFace");
        faceNames.add("downDisabledFace");
    }
}

