/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm.impl;

import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClassComparator
implements Comparator<String> {
    private static final Logger log = Logger.getLogger(ClassComparator.class.getName());
    private final ClassLoader resolveClassesWith;

    public ClassComparator(ClassLoader resolveClassesWith) {
        this.resolveClassesWith = resolveClassesWith;
    }

    @Override
    public int compare(String className1, String className2) {
        Class<?> class2;
        Class<?> class1 = this.forName(className1);
        if (class1.equals(class2 = this.forName(className2))) {
            return 0;
        }
        if (class1.isAssignableFrom(class2)) {
            return 1;
        }
        if (class2.isAssignableFrom(class1)) {
            return -1;
        }
        return className1.compareTo(className2);
    }

    private Class<?> forName(String name) {
        try {
            return Class.forName(name, false, this.resolveClassesWith);
        }
        catch (ClassNotFoundException e) {
            String string = String.valueOf(name);
            String msg = string.length() != 0 ? "Could not locate class ".concat(string) : new String("Could not locate class ");
            log.log(Level.SEVERE, msg, e);
            throw new RuntimeException(msg, e);
        }
    }
}

