/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;

public class DockPanel
extends CellPanel
implements HasAlignment {
    public static final DockLayoutConstant CENTER = new DockLayoutConstant();
    public static final DockLayoutConstant LINE_START = new DockLayoutConstant();
    public static final DockLayoutConstant LINE_END = new DockLayoutConstant();
    public static final DockLayoutConstant EAST = new DockLayoutConstant();
    public static final DockLayoutConstant NORTH = new DockLayoutConstant();
    public static final DockLayoutConstant SOUTH = new DockLayoutConstant();
    public static final DockLayoutConstant WEST = new DockLayoutConstant();
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign = ALIGN_DEFAULT;
    private HasVerticalAlignment.VerticalAlignmentConstant vertAlign = ALIGN_TOP;
    private Widget center;

    private static String generateDebugId(DockLayoutConstant direction, int count) {
        if (direction == NORTH) {
            return new StringBuilder(16).append("north").append(count).toString();
        }
        if (direction == SOUTH) {
            return new StringBuilder(16).append("south").append(count).toString();
        }
        if (direction == WEST) {
            return new StringBuilder(15).append("west").append(count).toString();
        }
        if (direction == EAST) {
            return new StringBuilder(15).append("east").append(count).toString();
        }
        if (direction == LINE_START) {
            return new StringBuilder(20).append("linestart").append(count).toString();
        }
        if (direction == LINE_END) {
            return new StringBuilder(18).append("lineend").append(count).toString();
        }
        return "center";
    }

    public DockPanel() {
        this.getTable().setPropertyInt("cellSpacing", 0);
        this.getTable().setPropertyInt("cellPadding", 0);
    }

    public void add(Widget widget, DockLayoutConstant direction) {
        if (direction == CENTER) {
            if (widget == this.center) {
                return;
            }
            if (this.center != null) {
                throw new IllegalArgumentException("Only one CENTER widget may be added");
            }
        }
        widget.removeFromParent();
        this.getChildren().add(widget);
        if (direction == CENTER) {
            this.center = widget;
        }
        LayoutData layout = new LayoutData(direction);
        widget.setLayoutData(layout);
        this.setCellHorizontalAlignment(widget, this.horzAlign);
        this.setCellVerticalAlignment(widget, this.vertAlign);
        this.realizeTable();
        this.adopt(widget);
    }

    public void add(IsWidget widget, DockLayoutConstant direction) {
        this.add(widget.asWidget(), direction);
    }

    @Override
    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    @Override
    public HasVerticalAlignment.VerticalAlignmentConstant getVerticalAlignment() {
        return this.vertAlign;
    }

    public DockLayoutConstant getWidgetDirection(Widget w) {
        if (w.getParent() != this) {
            return null;
        }
        return ((LayoutData)w.getLayoutData()).direction;
    }

    @Override
    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            if (w == this.center) {
                this.center = null;
            }
            this.realizeTable();
        }
        return removed;
    }

    @Override
    public void setCellHeight(Widget w, String height) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.height = height;
        if (data.td != null) {
            data.td.getStyle().setProperty("height", data.height);
        }
    }

    @Override
    public void setCellHorizontalAlignment(Widget w, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.hAlign = align.getTextAlignString();
        if (data.td != null) {
            this.setCellHorizontalAlignment(data.td, align);
        }
    }

    @Override
    public void setCellVerticalAlignment(Widget w, HasVerticalAlignment.VerticalAlignmentConstant align) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.vAlign = align.getVerticalAlignString();
        if (data.td != null) {
            this.setCellVerticalAlignment(data.td, align);
        }
    }

    @Override
    public void setCellWidth(Widget w, String width) {
        LayoutData data = (LayoutData)w.getLayoutData();
        data.width = width;
        if (data.td != null) {
            data.td.getStyle().setProperty("width", data.width);
        }
    }

    @Override
    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
    }

    @Override
    public void setVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant align) {
        this.vertAlign = align;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        HashMap<DockLayoutConstant, Integer> dirCount = new HashMap<DockLayoutConstant, Integer>();
        for (Widget child : this.getChildren()) {
            DockLayoutConstant dir = ((LayoutData)child.getLayoutData()).direction;
            Integer countObj = (Integer)dirCount.get(dir);
            int count = countObj == null ? 1 : countObj;
            String debugID = DockPanel.generateDebugId(dir, count);
            DockPanel.ensureDebugId(DOM.getParent(child.getElement()), baseID, debugID);
            dirCount.put(dir, count + 1);
        }
    }

    private void realizeTable() {
        Element bodyElem = this.getBody();
        while (DOM.getChildCount(bodyElem) > 0) {
            bodyElem.removeChild(DOM.getChild(bodyElem, 0));
        }
        int rowCount = 1;
        int colCount = 1;
        for (Widget child : this.getChildren()) {
            DockLayoutConstant dir = ((LayoutData)child.getLayoutData()).direction;
            if (dir == NORTH || dir == SOUTH) {
                ++rowCount;
                continue;
            }
            if (dir != EAST && dir != WEST && dir != LINE_START && dir != LINE_END) continue;
            ++colCount;
        }
        TmpRow[] rows = new TmpRow[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = new TmpRow();
            rows[i].tr = DOM.createTR();
            DOM.appendChild(bodyElem, rows[i].tr);
        }
        int logicalLeftCol = 0;
        int logicalRightCol = colCount - 1;
        int northRow = 0;
        int southRow = rowCount - 1;
        Element centerTd = null;
        for (Widget child : this.getChildren()) {
            TmpRow row;
            LayoutData layout = (LayoutData)child.getLayoutData();
            Element td = DOM.createTD();
            layout.td = td;
            layout.td.setPropertyString("align", layout.hAlign);
            layout.td.getStyle().setProperty("verticalAlign", layout.vAlign);
            layout.td.setPropertyString("width", layout.width);
            layout.td.setPropertyString("height", layout.height);
            if (layout.direction == NORTH) {
                DOM.insertChild(rows[northRow].tr, td, rows[northRow].center);
                DOM.appendChild(td, child.getElement());
                td.setPropertyInt("colSpan", logicalRightCol - logicalLeftCol + 1);
                ++northRow;
                continue;
            }
            if (layout.direction == SOUTH) {
                DOM.insertChild(rows[southRow].tr, td, rows[southRow].center);
                DOM.appendChild(td, child.getElement());
                td.setPropertyInt("colSpan", logicalRightCol - logicalLeftCol + 1);
                --southRow;
                continue;
            }
            if (layout.direction == CENTER) {
                centerTd = td;
                continue;
            }
            if (this.shouldAddToLogicalLeftOfTable(layout.direction)) {
                row = rows[northRow];
                DOM.insertChild(row.tr, td, row.center++);
                DOM.appendChild(td, child.getElement());
                td.setPropertyInt("rowSpan", southRow - northRow + 1);
                ++logicalLeftCol;
                continue;
            }
            if (!this.shouldAddToLogicalRightOfTable(layout.direction)) continue;
            row = rows[northRow];
            DOM.insertChild(row.tr, td, row.center);
            DOM.appendChild(td, child.getElement());
            td.setPropertyInt("rowSpan", southRow - northRow + 1);
            --logicalRightCol;
        }
        if (this.center != null) {
            TmpRow row = rows[northRow];
            DOM.insertChild(row.tr, centerTd, row.center);
            DOM.appendChild(centerTd, this.center.getElement());
        }
    }

    private boolean shouldAddToLogicalLeftOfTable(DockLayoutConstant widgetDirection) {
        assert (widgetDirection == LINE_START || widgetDirection == LINE_END || widgetDirection == EAST || widgetDirection == WEST);
        if (widgetDirection == LINE_START) {
            return true;
        }
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            return widgetDirection == EAST;
        }
        return widgetDirection == WEST;
    }

    private boolean shouldAddToLogicalRightOfTable(DockLayoutConstant widgetDirection) {
        assert (widgetDirection == LINE_START || widgetDirection == LINE_END || widgetDirection == EAST || widgetDirection == WEST);
        if (widgetDirection == LINE_END) {
            return true;
        }
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            return widgetDirection == WEST;
        }
        return widgetDirection == EAST;
    }

    private static class TmpRow {
        public int center;
        public com.google.gwt.dom.client.Element tr;

        private TmpRow() {
        }
    }

    static class LayoutData {
        public DockLayoutConstant direction;
        public String hAlign = HasHorizontalAlignment.ALIGN_DEFAULT.getTextAlignString();
        public String height = "";
        public com.google.gwt.dom.client.Element td;
        public String vAlign = HasVerticalAlignment.ALIGN_TOP.getVerticalAlignString();
        public String width = "";

        public LayoutData(DockLayoutConstant dir) {
            this.direction = dir;
        }
    }

    public static class DockLayoutConstant {
        private DockLayoutConstant() {
        }
    }
}

