/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiRenderer;
import java.util.HashMap;

public abstract class AbstractUiRenderer
implements UiRenderer {
    public static final String RENDERED_ATTRIBUTE = "gwtuirendered";
    public static final String ROOT_FAKE_NAME = "^";
    public static final String UI_ID_SEPARATOR = ":";
    private static final int NO_HANDLER_FOUND = -1;
    protected String uiId;

    protected static String buildInnerId(String fieldName, String uiId) {
        String string = String.valueOf(UI_ID_SEPARATOR);
        return new StringBuilder(0 + String.valueOf(uiId).length() + String.valueOf(string).length() + String.valueOf(fieldName).length()).append(uiId).append(string).append(fieldName).toString();
    }

    protected static Element findInnerField(Element parent, String fieldName, String attribute) {
        Element root = AbstractUiRenderer.findRootElement(parent, attribute);
        if (parent != root && !AbstractUiRenderer.isRenderedElementSingleChild(root)) {
            String string = String.valueOf("Parent Element of previously rendered element contains more than one child while getting \"");
            throw new IllegalArgumentException(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(fieldName).length()).append(string).append(fieldName).append("\"").toString());
        }
        String uiId = root.getAttribute(attribute);
        String renderedId = AbstractUiRenderer.buildInnerId(fieldName, uiId);
        Element elementById = Document.get().getElementById(renderedId);
        if (elementById == null) {
            if (!AbstractUiRenderer.isAttachedToDom(root)) {
                throw new RuntimeException(new StringBuilder(58 + String.valueOf(fieldName).length()).append("UiRendered element is not attached to DOM while getting \"").append(fieldName).append("\"").toString());
            }
            if (!GWT.isProdMode()) {
                throw new IllegalStateException(new StringBuilder(36 + String.valueOf(fieldName).length()).append("\"").append(fieldName).append("\" not found within rendered element").toString());
            }
            throw new IllegalArgumentException(new StringBuilder(82 + String.valueOf(fieldName).length()).append("UiRendered element is not attached to DOM, or \"").append(fieldName).append("\" not found within rendered element").toString());
        }
        return elementById;
    }

    protected static Element findRootElement(Element parent, String attribute) {
        Element root = AbstractUiRenderer.findRootElementOrNull(parent, attribute);
        if (root == null) {
            throw new IllegalArgumentException("Parent element does not contain a previously rendered element");
        }
        return root;
    }

    protected static SafeHtml stampUiRendererAttribute(SafeHtml safeHtml, String attributeName, String attributeValue) {
        String html = safeHtml.asString();
        int endOfFirstTag = html.indexOf(">");
        assert (endOfFirstTag > 1) : "Safe html template does not start with an HTML open tag";
        if (html.charAt(endOfFirstTag - 1) == '/') {
            --endOfFirstTag;
        }
        String string = String.valueOf(html.substring(0, endOfFirstTag));
        String string2 = String.valueOf(html.substring(endOfFirstTag));
        html = new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(attributeName).length() + String.valueOf(attributeValue).length() + String.valueOf(string2).length()).append(string).append(" ").append(attributeName).append("=\"").append(attributeValue).append("\"").append(string2).toString();
        return SafeHtmlUtils.fromTrustedString(html);
    }

    private static HashMap<String, Integer> buildDispatchMap(String[] keys, Integer[] values) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], values[i]);
        }
        return result;
    }

    private static int computeDispatchEvent(HashMap<String, Integer> table, Element root, NativeEvent event) {
        String string;
        String string2;
        String uiId = root.getAttribute(RENDERED_ATTRIBUTE);
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return -1;
        }
        Element cursor = Element.as(eventTarget);
        while (cursor != null && cursor != root && cursor.getNodeType() != 9) {
            String fieldName = AbstractUiRenderer.getFieldName(uiId, cursor);
            if (fieldName == null) {
                cursor = cursor.getParentElement();
                continue;
            }
            string2 = event.getType();
            string = String.valueOf(UI_ID_SEPARATOR);
            String key = new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string).length() + String.valueOf(fieldName).length()).append(string2).append(string).append(fieldName).toString();
            if (table.containsKey(key)) {
                return table.get(key);
            }
            cursor = cursor.getParentElement();
        }
        if (cursor == root) {
            String string3 = event.getType();
            string2 = String.valueOf(UI_ID_SEPARATOR);
            string = String.valueOf(ROOT_FAKE_NAME);
            String key = new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append(string3).append(string2).append(string).toString();
            if (table.containsKey(key)) {
                return table.get(key);
            }
        }
        return -1;
    }

    private static Element findRootElementOrNull(Element parent, String attribute) {
        if (parent == null) {
            throw new NullPointerException("parent argument is null");
        }
        if (parent.hasAttribute(attribute)) {
            return parent;
        }
        Element rendered = parent.getFirstChildElement();
        if (rendered != null && rendered.hasAttribute(attribute)) {
            return rendered;
        }
        return null;
    }

    private static String getFieldName(String uiId, Element element) {
        String id = element.getId();
        if (id == null) {
            return null;
        }
        int split = id.indexOf(UI_ID_SEPARATOR);
        return split != -1 && uiId.length() == split && id.startsWith(uiId) ? id.substring(split + 1) : null;
    }

    private static boolean isAttachedToDom(Element rendered) {
        if (GWT.isProdMode()) {
            return true;
        }
        BodyElement body = Document.get().getBody();
        while (rendered != null && rendered.hasParentElement() && !body.equals(rendered)) {
            rendered = rendered.getParentElement();
        }
        return body.equals(rendered);
    }

    private static boolean isParentOrRenderer(Element parent, String attribute) {
        if (parent == null) {
            return false;
        }
        Element root = AbstractUiRenderer.findRootElementOrNull(parent, attribute);
        return root != null && AbstractUiRenderer.isAttachedToDom(root) && AbstractUiRenderer.isRenderedElementSingleChild(root);
    }

    private static boolean isRenderedElementSingleChild(Element rendered) {
        return GWT.isProdMode() || rendered.getParentElement().getChildCount() == 1;
    }

    @Override
    public boolean isParentOrRenderer(Element parent) {
        return AbstractUiRenderer.isParentOrRenderer(parent, RENDERED_ATTRIBUTE);
    }

    protected static abstract class UiRendererDispatcher<T>
    implements HasHandlers {
        private T eventTarget;
        private int methodIndex;
        private Element root;
        private HashMap<String, Integer> table;

        protected UiRendererDispatcher() {
        }

        protected void fireEvent(T target, NativeEvent event, Element parentOrRoot) {
            if (target == null) {
                throw new NullPointerException("Null event handler received");
            }
            if (event == null) {
                throw new NullPointerException("Null event object received");
            }
            if (parentOrRoot == null) {
                throw new NullPointerException("Null parent received");
            }
            if (!AbstractUiRenderer.isParentOrRenderer(parentOrRoot, AbstractUiRenderer.RENDERED_ATTRIBUTE)) {
                return;
            }
            this.eventTarget = target;
            this.root = AbstractUiRenderer.findRootElementOrNull(parentOrRoot, AbstractUiRenderer.RENDERED_ATTRIBUTE);
            this.methodIndex = AbstractUiRenderer.computeDispatchEvent(this.table, this.root, event);
            DomEvent.fireNativeEvent(event, this);
        }

        protected T getEventTarget() {
            return this.eventTarget;
        }

        protected int getMethodIndex() {
            return this.methodIndex;
        }

        protected Element getRoot() {
            return this.root;
        }

        protected void initDispatchTable(String[] keys, Integer[] values) {
            this.table = AbstractUiRenderer.buildDispatchMap(keys, values);
        }
    }
}

