/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;

public class SafeUriHostedModeUtils {
    static final String HREF_DISCRETE_UCSCHAR = ":/?#[]@!$&'()*+,;=-._~ <>\"{}|\\^`%";
    public static final String FORCE_CHECK_VALID_URI = "com.google.gwt.safehtml.ForceCheckValidUri";
    private static boolean forceCheckValidUri;

    public static boolean isValidUriCharset(String uri) {
        int codePoint;
        int len = uri.length();
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = uri.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint) || HREF_DISCRETE_UCSCHAR.indexOf(codePoint) >= 0 || 97 <= codePoint && codePoint <= 122 || 65 <= codePoint && codePoint <= 90 || 48 <= codePoint && codePoint <= 57 || 0 <= codePoint && codePoint <= 31 || 127 <= codePoint && codePoint <= 55295 || 57344 <= codePoint && codePoint <= 65533) continue;
            return false;
        }
        return true;
    }

    public static void maybeCheckValidUri(String uri) {
        if (GWT.isClient() || forceCheckValidUri) {
            Preconditions.checkArgument(SafeUriHostedModeUtils.isValidUri(uri), "String is not a valid URI: %s", uri);
        } else if (!$assertionsDisabled && !SafeUriHostedModeUtils.isValidUri(uri)) {
            String string = String.valueOf(uri);
            throw new AssertionError((Object)(string.length() != 0 ? "String is not a valid URI: ".concat(string) : new String("String is not a valid URI: ")));
        }
    }

    public static void setForceCheckValidUri(boolean check) {
        forceCheckValidUri = check;
    }

    public static void setForceCheckValidUriFromProperty() {
        forceCheckValidUri = System.getProperty(FORCE_CHECK_VALID_URI) != null;
    }

    private static boolean isValidUri(String uri) {
        if (!SafeUriHostedModeUtils.isValidUriCharset(uri)) {
            return false;
        }
        uri = UriUtils.encodeAllowEscapes(uri);
        try {
            new URI(uri);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    static {
        SafeUriHostedModeUtils.setForceCheckValidUriFromProperty();
    }
}

