/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.ext;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.impl.ResourceGeneratorUtilImpl;
import com.google.gwt.core.ext.impl.ResourceLocatorImpl;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.DefaultExtensions;
import com.google.gwt.resources.ext.ResourceContext;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ResourceGeneratorUtil {
    private static final String[] DEPRECATED_ANNOTATION_NAMES = new String[]{"com.google.gwt.libideas.resources.client.ImmutableResourceBundle$Resource", "com.google.gwt.user.client.ui.ImageBundle$Resource"};
    private static final List<Class<? extends Annotation>> DEPRECATED_ANNOTATION_CLASSES;

    public static void addNamedFile(String resourceName, File file) {
        ResourceGeneratorUtilImpl.addGeneratedFile((String)resourceName, (File)file);
    }

    public static String baseName(URL resource) {
        String path = resource.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        JClassType returnType = method.getReturnType().isClassOrInterface();
        assert (returnType != null);
        DefaultExtensions annotation = (DefaultExtensions)returnType.findAnnotationInTypeHierarchy(DefaultExtensions.class);
        String[] extensions = annotation != null ? annotation.value() : new String[]{};
        return ResourceGeneratorUtil.findResources(logger, context, method, extensions);
    }

    public static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        Locator[] locators = ResourceGeneratorUtil.getDefaultLocators(logger, context.getGeneratorContext());
        URL[] toReturn = ResourceGeneratorUtil.findResources(logger, locators, context, method, defaultSuffixes);
        return toReturn;
    }

    public static long getLastModified(URL[] resources, TreeLogger logger) {
        long lastModificationDate = 0L;
        for (URL url : resources) {
            long lastModified = 0L;
            try {
                lastModified = url.openConnection().getLastModified();
            }
            catch (IOException e) {
                logger.log(TreeLogger.DEBUG, "Could not determine cached time", (Throwable)e);
            }
            if (lastModified == 0L) {
                return 0L;
            }
            lastModificationDate = Math.max(lastModificationDate, lastModified);
        }
        return lastModificationDate;
    }

    public static JMethod getMethodByPath(JClassType rootType, List<String> pathElements, JType expectedReturnType) throws NotFoundException {
        Object object;
        if (pathElements.isEmpty()) {
            throw new NotFoundException("No path specified");
        }
        JMethod currentMethod = null;
        JClassType currentType = rootType;
        for (String pathElement : pathElements) {
            JClassType referenceType = currentType.isClassOrInterface();
            if (referenceType == null) {
                object = String.valueOf(currentType.getQualifiedSourceName());
                throw new NotFoundException(new StringBuilder(31 + String.valueOf(pathElement).length() + String.valueOf(object).length()).append("Cannot resolve member ").append(pathElement).append(" on type ").append((String)object).toString());
            }
            currentMethod = null;
            block1: for (JClassType searchType : referenceType.getFlattenedSupertypeHierarchy()) {
                for (JMethod method : searchType.getOverloads(pathElement)) {
                    if (method.getParameters().length != 0) continue;
                    currentMethod = method;
                    break block1;
                }
            }
            if (currentMethod == null) {
                object = String.valueOf(currentType.getQualifiedSourceName());
                throw new NotFoundException(new StringBuilder(44 + String.valueOf(pathElement).length() + String.valueOf(object).length()).append("Could not find no-arg method named ").append(pathElement).append(" in type ").append((String)object).toString());
            }
            currentType = currentMethod.getReturnType();
        }
        if (expectedReturnType != null) {
            JPrimitiveType expectedIsPrimitive = expectedReturnType.isPrimitive();
            JClassType expectedIsClassType = expectedReturnType.isClassOrInterface();
            boolean error = false;
            if (expectedIsPrimitive != null) {
                if (!expectedIsPrimitive.equals((Object)currentMethod.getReturnType())) {
                    error = true;
                }
            } else {
                JClassType returnIsClassType = currentMethod.getReturnType().isClassOrInterface();
                if (returnIsClassType == null) {
                    error = true;
                } else if (!expectedIsClassType.isAssignableFrom(returnIsClassType)) {
                    error = true;
                }
            }
            if (error) {
                object = String.valueOf(expectedReturnType.getQualifiedSourceName());
                String string = String.valueOf(currentMethod.getReturnType().getQualifiedSourceName());
                throw new NotFoundException(new StringBuilder(29 + String.valueOf(object).length() + String.valueOf(string).length()).append("Expecting return type ").append((String)object).append(" found ").append(string).toString());
            }
        }
        return currentMethod;
    }

    public static URL tryFindResource(TreeLogger logger, GeneratorContext genContext, ResourceContext resourceContext, String resourceName) {
        Locator[] locators;
        String locale = ResourceGeneratorUtil.getLocale(logger, genContext);
        for (Locator locator : locators = ResourceGeneratorUtil.getDefaultLocators(logger, genContext)) {
            URL toReturn = ResourceGeneratorUtil.tryFindResource(locator, resourceContext, resourceName, locale);
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    private static void addTypeRequirementsForMethod(ResourceContext context, JMethod method) {
        ClientBundleRequirements reqs = context.getRequirements();
        if (reqs != null) {
            reqs.addTypeHierarchy(method.getEnclosingType());
            reqs.addTypeHierarchy((JClassType)method.getReturnType());
        }
    }

    private static void checkForDeprecatedAnnotations(TreeLogger logger, JMethod method) {
        for (Class<? extends Annotation> annotationClass : DEPRECATED_ANNOTATION_CLASSES) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            String string = String.valueOf(ClientBundle.Source.class.getCanonicalName());
            String string2 = String.valueOf(annotationClass.getName());
            logger.log(TreeLogger.WARN, new StringBuilder(109 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Deprecated annotation used; expecting ").append(string).append(" but found ").append(string2).append(" instead.  It is likely ").append("that undesired operation will occur.").toString());
        }
    }

    private static URL[] findResources(TreeLogger logger, Locator[] locators, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        URL[] toReturn;
        logger = logger.branch(TreeLogger.DEBUG, "Finding resources");
        String locale = ResourceGeneratorUtil.getLocale(logger, context.getGeneratorContext());
        ResourceGeneratorUtil.checkForDeprecatedAnnotations(logger, method);
        boolean error = false;
        ClientBundle.Source resourceAnnotation = (ClientBundle.Source)method.getAnnotation(ClientBundle.Source.class);
        if (resourceAnnotation == null) {
            if (defaultSuffixes != null) {
                for (String extension : defaultSuffixes) {
                    if (logger.isLoggable(TreeLogger.SPAM)) {
                        String string = String.valueOf(extension);
                        logger.log(TreeLogger.SPAM, string.length() != 0 ? "Trying default extension ".concat(string) : new String("Trying default extension "));
                    }
                    for (Locator locator : locators) {
                        String string = String.valueOf(method.getName());
                        String string2 = String.valueOf(extension);
                        URL resourceUrl = ResourceGeneratorUtil.tryFindResource(locator, context, ResourceGeneratorUtil.getPathRelativeToPackage(method.getEnclosingType().getPackage(), string2.length() != 0 ? string.concat(string2) : new String(string)), locale);
                        if (resourceUrl == null) continue;
                        ResourceGeneratorUtil.addTypeRequirementsForMethod(context, method);
                        return new URL[]{resourceUrl};
                    }
                }
            }
            String string = String.valueOf(ClientBundle.Source.class.getName());
            logger.log(TreeLogger.ERROR, new StringBuilder(61 + String.valueOf(string).length()).append("No ").append(string).append(" annotation and no resources found with default extensions").toString());
            toReturn = null;
            error = true;
        } else {
            String[] stringArray = resourceAnnotation.value();
            toReturn = new URL[stringArray.length];
            int tagIndex = 0;
            for (String resource : stringArray) {
                URL resourceURL = null;
                for (Locator locator : locators) {
                    resourceURL = ResourceGeneratorUtil.tryFindResource(locator, context, ResourceGeneratorUtil.getPathRelativeToPackage(method.getEnclosingType().getPackage(), resource), locale);
                    if (resourceURL == null) {
                        resourceURL = ResourceGeneratorUtil.tryFindResource(locator, context, resource, locale);
                    }
                    if (resourceURL != null) break;
                }
                if (resourceURL == null) {
                    error = true;
                    logger.log(TreeLogger.ERROR, new StringBuilder(85 + String.valueOf(resource).length()).append("Resource ").append(resource).append(" not found. Is the name specified as ClassLoader.getResource()").append(" would expect?").toString());
                }
                toReturn[tagIndex++] = resourceURL;
            }
        }
        if (error) {
            throw new UnableToCompleteException();
        }
        ResourceGeneratorUtil.addTypeRequirementsForMethod(context, method);
        return toReturn;
    }

    private static Locator[] getDefaultLocators(TreeLogger logger, GeneratorContext genContext) {
        return new Locator[]{NamedFileLocator.INSTANCE, new GeneralLocator(logger, genContext.getResourcesOracle())};
    }

    private static String getLocale(TreeLogger logger, GeneratorContext genContext) {
        String locale;
        try {
            PropertyOracle oracle = genContext.getPropertyOracle();
            SelectionProperty prop = oracle.getSelectionProperty(logger, "locale");
            locale = prop.getCurrentValue();
        }
        catch (BadPropertyValueException e) {
            locale = null;
        }
        return locale;
    }

    private static String getPathRelativeToPackage(JPackage pkg, String path) {
        String string = String.valueOf(pkg.getName().replace('.', '/'));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(path).length()).append(string).append("/").append(path).toString();
    }

    private static URL tryFindResource(Locator locator, String resourceName, String locale) {
        URL toReturn = null;
        if (locale != null) {
            String[] localeSegments = locale.split("_");
            int lastDot = resourceName.lastIndexOf(".");
            String prefix = lastDot == -1 ? resourceName : resourceName.substring(0, lastDot);
            String extension = lastDot == -1 ? "" : resourceName.substring(lastDot);
            for (int i = localeSegments.length - 1; i >= -1; --i) {
                String localeInsert = "";
                for (int j = 0; j <= i; ++j) {
                    String string = String.valueOf(localeInsert);
                    String string2 = localeSegments[j];
                    localeInsert = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
                }
                String string = localeInsert;
                toReturn = locator.locate(new StringBuilder(0 + String.valueOf(prefix).length() + String.valueOf(string).length() + String.valueOf(extension).length()).append(prefix).append(string).append(extension).toString());
                if (toReturn == null) {
                    continue;
                }
                break;
            }
        } else {
            toReturn = locator.locate(resourceName);
        }
        return toReturn;
    }

    private static URL tryFindResource(Locator locator, ResourceContext context, String resourceName, String locale) {
        ClientBundleRequirements reqs;
        URL toReturn = ResourceGeneratorUtil.tryFindResource(locator, resourceName, locale);
        if (context != null && (reqs = context.getRequirements()) != null) {
            reqs.addResolvedResource(resourceName, toReturn);
        }
        return toReturn;
    }

    private ResourceGeneratorUtil() {
    }

    static {
        ArrayList<Class<Annotation>> classes = new ArrayList<Class<Annotation>>(DEPRECATED_ANNOTATION_NAMES.length);
        for (String name : DEPRECATED_ANNOTATION_NAMES) {
            try {
                Class<?> maybeAnnotation = Class.forName(name, false, ResourceGeneratorUtil.class.getClassLoader());
                Class<Annotation> annotationClass = maybeAnnotation.asSubclass(Annotation.class);
                classes.add(annotationClass);
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        DEPRECATED_ANNOTATION_CLASSES = classes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(classes);
    }

    private static interface Locator {
        public URL locate(String var1);
    }

    private static class NamedFileLocator
    implements Locator {
        public static final NamedFileLocator INSTANCE = new NamedFileLocator();

        private NamedFileLocator() {
        }

        @Override
        public URL locate(String resourceName) {
            File f = ResourceGeneratorUtilImpl.getGeneratedFile((String)resourceName);
            if (f != null && f.isFile() && f.canRead()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    String string = String.valueOf(f.getName());
                    throw new RuntimeException(string.length() != 0 ? "Unable to make a URL for file ".concat(string) : new String("Unable to make a URL for file "));
                }
            }
            return null;
        }
    }

    private static class GeneralLocator
    implements Locator {
        private final ResourceOracle resourceOracle;
        private final TreeLogger logger;

        public GeneralLocator(TreeLogger logger, ResourceOracle resourceOracle) {
            this.logger = logger;
            this.resourceOracle = resourceOracle;
        }

        @Override
        public URL locate(String resourceName) {
            return ResourceLocatorImpl.tryFindResourceUrl((TreeLogger)this.logger, (ResourceOracle)this.resourceOracle, (String)resourceName);
        }
    }
}

