/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.ui.AnimatedLayout;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.LayoutCommand;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;

public class LayoutPanel
extends ComplexPanel
implements AnimatedLayout,
RequiresResize,
ProvidesResize {
    private final Layout layout;
    private final LayoutCommand layoutCmd;

    public LayoutPanel() {
        this.setElement(Document.get().createDivElement());
        this.layout = new Layout(this.getElement());
        this.layoutCmd = new LayoutCommand(this.layout);
    }

    public void add(Widget widget) {
        this.insert(widget, this.getWidgetCount());
    }

    public void animate(int duration) {
        this.animate(duration, null);
    }

    public void animate(int duration, Layout.AnimationCallback callback) {
        this.layoutCmd.schedule(duration, callback);
    }

    public void forceLayout() {
        this.layoutCmd.cancel();
        this.layout.layout();
        this.onResize();
    }

    public Element getWidgetContainerElement(Widget child) {
        this.assertIsChild(child);
        return this.getLayer(child).getContainerElement();
    }

    public void insert(Widget widget, int beforeIndex) {
        widget.removeFromParent();
        this.getChildren().insert(widget, beforeIndex);
        Layout.Layer layer = this.layout.attachChild((Element)widget.getElement(), widget);
        widget.setLayoutData(layer);
        this.adopt(widget);
        this.animate(0);
    }

    public void onResize() {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof RequiresResize)) continue;
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            this.layout.removeChild((Layout.Layer)w.getLayoutData());
        }
        return removed;
    }

    public void setWidgetBottomHeight(Widget child, double bottom, Style.Unit bottomUnit, double height, Style.Unit heightUnit) {
        this.assertIsChild(child);
        this.getLayer(child).setBottomHeight(bottom, bottomUnit, height, heightUnit);
        this.animate(0);
    }

    public void setWidgetHorizontalPosition(Widget child, Layout.Alignment position) {
        this.assertIsChild(child);
        this.getLayer(child).setChildHorizontalPosition(position);
        this.animate(0);
    }

    public void setWidgetLeftRight(Widget child, double left, Style.Unit leftUnit, double right, Style.Unit rightUnit) {
        this.assertIsChild(child);
        this.getLayer(child).setLeftRight(left, leftUnit, right, rightUnit);
        this.animate(0);
    }

    public void setWidgetLeftWidth(Widget child, double left, Style.Unit leftUnit, double width, Style.Unit widthUnit) {
        this.assertIsChild(child);
        this.getLayer(child).setLeftWidth(left, leftUnit, width, widthUnit);
        this.animate(0);
    }

    public void setWidgetRightWidth(Widget child, double right, Style.Unit rightUnit, double width, Style.Unit widthUnit) {
        this.assertIsChild(child);
        this.getLayer(child).setRightWidth(right, rightUnit, width, widthUnit);
        this.animate(0);
    }

    public void setWidgetTopBottom(Widget child, double top, Style.Unit topUnit, double bottom, Style.Unit bottomUnit) {
        this.assertIsChild(child);
        this.getLayer(child).setTopBottom(top, topUnit, bottom, bottomUnit);
        this.animate(0);
    }

    public void setWidgetTopHeight(Widget child, double top, Style.Unit topUnit, double height, Style.Unit heightUnit) {
        this.assertIsChild(child);
        this.getLayer(child).setTopHeight(top, topUnit, height, heightUnit);
        this.animate(0);
    }

    public void setWidgetVerticalPosition(Widget child, Layout.Alignment position) {
        this.assertIsChild(child);
        this.getLayer(child).setChildVerticalPosition(position);
        this.animate(0);
    }

    public void setWidgetVisible(Widget child, boolean visible) {
        this.assertIsChild(child);
        this.getLayer(child).setVisible(visible);
        child.setVisible(visible);
        this.animate(0);
    }

    protected void onLoad() {
        this.layout.onAttach();
    }

    protected void onUnload() {
        this.layout.onDetach();
    }

    Layout getLayout() {
        return this.layout;
    }

    private void assertIsChild(Widget widget) {
        assert (widget == null || widget.getParent() == this) : "The specified widget is not a child of this panel";
    }

    private Layout.Layer getLayer(Widget child) {
        assert (child.getParent() == this) : "The requested widget is not a child of this panel";
        return (Layout.Layer)child.getLayoutData();
    }
}

