/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

class CharVector {
    private int capacityIncrement;
    private char[] chars;
    private int size;

    public CharVector(int initialCapacity, int capacityIncrement) {
        assert (initialCapacity >= 0);
        assert (capacityIncrement >= 0);
        this.capacityIncrement = capacityIncrement;
        this.chars = new char[initialCapacity];
    }

    public void add(char ch) {
        if (this.size >= this.chars.length) {
            int growBy = this.capacityIncrement == 0 ? this.chars.length * 2 : this.capacityIncrement;
            char[] newChars = new char[this.chars.length + growBy];
            System.arraycopy(this.chars, 0, newChars, 0, this.size);
            this.chars = newChars;
        }
        this.chars[this.size++] = ch;
    }

    public char[] asArray() {
        return this.chars;
    }

    public char get(int index) {
        assert (index < this.size);
        return this.chars[index];
    }

    public int getSize() {
        return this.size;
    }

    public void set(int index, char ch) {
        assert (index >= 0 && index < this.size);
        this.chars[index] = ch;
        ++this.size;
    }
}

