/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui.impl;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.impl.RichTextAreaImpl;

public abstract class RichTextAreaImplStandard
extends RichTextAreaImpl
implements RichTextArea.BasicFormatter,
RichTextArea.ExtendedFormatter {
    private Element beforeInitPlaceholder = DOM.createDiv();
    protected boolean initializing;

    public native Element createElement();

    public void createLink(String url) {
        this.execCommand("CreateLink", url);
    }

    public String getBackColor() {
        return this.queryCommandValue("BackColor");
    }

    public String getForeColor() {
        return this.queryCommandValue("ForeColor");
    }

    public final String getHTML() {
        return this.beforeInitPlaceholder == null ? this.getHTMLImpl() : DOM.getInnerHTML(this.beforeInitPlaceholder);
    }

    public final String getText() {
        return this.beforeInitPlaceholder == null ? this.getTextImpl() : DOM.getInnerText(this.beforeInitPlaceholder);
    }

    public native void initElement();

    public void insertHorizontalRule() {
        this.execCommand("InsertHorizontalRule", null);
    }

    public void insertImage(String url) {
        this.execCommand("InsertImage", url);
    }

    public void insertOrderedList() {
        this.execCommand("InsertOrderedList", null);
    }

    public void insertUnorderedList() {
        this.execCommand("InsertUnorderedList", null);
    }

    public boolean isBasicEditingSupported() {
        return true;
    }

    public boolean isBold() {
        return this.queryCommandState("Bold");
    }

    public boolean isExtendedEditingSupported() {
        return true;
    }

    public boolean isItalic() {
        return this.queryCommandState("Italic");
    }

    public boolean isStrikethrough() {
        return this.queryCommandState("Strikethrough");
    }

    public boolean isSubscript() {
        return this.queryCommandState("Subscript");
    }

    public boolean isSuperscript() {
        return this.queryCommandState("Superscript");
    }

    public boolean isUnderlined() {
        return this.queryCommandState("Underline");
    }

    public void leftIndent() {
        this.execCommand("Outdent", null);
    }

    public void removeFormat() {
        this.execCommand("RemoveFormat", null);
    }

    public void removeLink() {
        this.execCommand("Unlink", "false");
    }

    public void rightIndent() {
        this.execCommand("Indent", null);
    }

    public void selectAll() {
        this.execCommand("SelectAll", null);
    }

    public void setBackColor(String color) {
        this.execCommand("BackColor", color);
    }

    public native void setFocus(boolean var1);

    public void setFontName(String name) {
        this.execCommand("FontName", name);
    }

    public void setFontSize(RichTextArea.FontSize fontSize) {
        this.execCommand("FontSize", Integer.toString(fontSize.getNumber()));
    }

    public void setForeColor(String color) {
        this.execCommand("ForeColor", color);
    }

    public final void setHTML(String html) {
        if (this.beforeInitPlaceholder == null) {
            this.setHTMLImpl(html);
        } else {
            DOM.setInnerHTML(this.beforeInitPlaceholder, html);
        }
    }

    public void setJustification(RichTextArea.Justification justification) {
        if (justification == RichTextArea.Justification.CENTER) {
            this.execCommand("JustifyCenter", null);
        } else if (justification == RichTextArea.Justification.LEFT) {
            this.execCommand("JustifyLeft", null);
        } else if (justification == RichTextArea.Justification.RIGHT) {
            this.execCommand("JustifyRight", null);
        }
    }

    public final void setText(String text) {
        if (this.beforeInitPlaceholder == null) {
            this.setTextImpl(text);
        } else {
            DOM.setInnerText(this.beforeInitPlaceholder, text);
        }
    }

    public void toggleBold() {
        this.execCommand("Bold", "false");
    }

    public void toggleItalic() {
        this.execCommand("Italic", "false");
    }

    public void toggleStrikethrough() {
        this.execCommand("Strikethrough", "false");
    }

    public void toggleSubscript() {
        this.execCommand("Subscript", "false");
    }

    public void toggleSuperscript() {
        this.execCommand("Superscript", "false");
    }

    public void toggleUnderline() {
        this.execCommand("Underline", "False");
    }

    public void uninitElement() {
        if (this.initializing) {
            this.initializing = false;
            return;
        }
        this.unhookEvents();
        String html = this.getHTML();
        this.beforeInitPlaceholder = DOM.createDiv();
        DOM.setInnerHTML(this.beforeInitPlaceholder, html);
    }

    protected native String getHTMLImpl();

    protected native String getTextImpl();

    protected native void hookEvents();

    protected void onElementInitialized() {
        if (!this.initializing) {
            return;
        }
        this.initializing = false;
        super.onElementInitialized();
        if (this.beforeInitPlaceholder != null) {
            this.setHTMLImpl(DOM.getInnerHTML(this.beforeInitPlaceholder));
            this.beforeInitPlaceholder = null;
        }
    }

    protected native void setHTMLImpl(String var1);

    protected native void setTextImpl(String var1);

    protected native void unhookEvents();

    void execCommand(String cmd, String param) {
        if (this.isRichEditingActive(this.elem)) {
            this.setFocus(true);
            this.execCommandAssumingFocus(cmd, param);
        }
    }

    native void execCommandAssumingFocus(String var1, String var2);

    native boolean isRichEditingActive(Element var1);

    boolean queryCommandState(String cmd) {
        if (this.isRichEditingActive(this.elem)) {
            this.setFocus(true);
            return this.queryCommandStateAssumingFocus(cmd);
        }
        return false;
    }

    native boolean queryCommandStateAssumingFocus(String var1);

    String queryCommandValue(String cmd) {
        this.setFocus(true);
        return this.queryCommandValueAssumingFocus(cmd);
    }

    native String queryCommandValueAssumingFocus(String var1);
}

