/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.server.CompilationResult;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.SysInfo;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PooledSjavac
implements Sjavac {
    final Sjavac delegate;
    final ExecutorService pool;

    public PooledSjavac(Sjavac delegate, int poolsize) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.pool = Executors.newFixedThreadPool(poolsize);
    }

    @Override
    public SysInfo getSysInfo() {
        try {
            return this.pool.submit(() -> this.delegate.getSysInfo()).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error during getSysInfo", e);
        }
    }

    @Override
    public CompilationResult compile(String protocolId, String invocationId, String[] args, List<File> explicitSources, Set<URI> sourcesToCompile, Set<URI> visibleSources) {
        try {
            return this.pool.submit(() -> this.delegate.compile(protocolId, invocationId, args, explicitSources, sourcesToCompile, visibleSources)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error during compile", e);
        }
    }

    @Override
    public void shutdown() {
        Log.debug("Shutting down PooledSjavac");
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Log.error("ThreadPool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.delegate.shutdown();
    }

    @Override
    public String serverSettings() {
        return this.delegate.serverSettings();
    }
}

