/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.tools.JavaFileManager;

public class Main {
    String ownName;
    PrintWriter out;
    public Log log;
    boolean apiMode;
    private JavaFileManager fileManager;
    public static final String javacBundleName = "com.sun.tools.javac.resources.javac";

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void error(String key, Object ... args) {
        if (this.apiMode) {
            String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void warning(String key, Object ... args) {
        String string = String.valueOf(String.valueOf(this.ownName));
        String string2 = String.valueOf(String.valueOf(this.log.localize(Log.PrefixKind.JAVAC, key, args)));
        this.log.printRawLines(new StringBuilder(2 + string.length() + string2.length()).append(string).append(": ").append(string2).toString());
    }

    public Result compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(String[] argv, Context context) {
        List<String> docLintOpts;
        boolean ok;
        String showClass;
        boolean batchMode;
        context.put(Log.outKey, this.out);
        this.log = Log.instance(context);
        if (argv.length == 0) {
            Option.HELP.process(new OptionHelper.GrumpyHelper(this.log){

                @Override
                public String getOwnName() {
                    return Main.this.ownName;
                }
            }, "-help");
            return Result.CMDERR;
        }
        try {
            argv = CommandLine.parse(argv);
        }
        catch (FileNotFoundException e) {
            this.warning("err.file.not.found", e.getMessage());
            return Result.SYSERR;
        }
        catch (IOException ex) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
            ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
            return Result.SYSERR;
        }
        Arguments args = Arguments.instance(context);
        args.init(this.ownName, argv);
        if (this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        Options options = Options.instance(context);
        boolean forceStdOut = options.isSet("stdout");
        if (forceStdOut) {
            this.log.flush();
            this.log.setWriters(new PrintWriter(System.out, true));
        }
        boolean bl = batchMode = options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
        if (batchMode) {
            CacheFSInfo.preRegister(context);
        }
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager instanceof BaseFileManager) {
            ((BaseFileManager)this.fileManager).setContext(context);
            ((BaseFileManager)this.fileManager).handleOptions(args.getDeferredFileManagerOptions());
        }
        if ((showClass = options.get("showClass")) != null) {
            if (showClass.equals("showClass")) {
                showClass = "com.sun.tools.javac.Main";
            }
            this.showClass(showClass);
        }
        if (!(ok = args.validate()) || this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        if (args.isEmpty()) {
            return Result.OK;
        }
        Set<List<String>> pluginOpts = args.getPluginOpts();
        if (!pluginOpts.isEmpty()) {
            BasicJavacTask t = (BasicJavacTask)BasicJavacTask.instance(context);
            t.initPlugins(pluginOpts);
        }
        if (!(docLintOpts = args.getDocLintOpts()).isEmpty()) {
            BasicJavacTask t = (BasicJavacTask)BasicJavacTask.instance(context);
            t.initDocLint(docLintOpts);
        }
        if (options.isSet("completionDeps")) {
            Dependencies.GraphDependencies.preRegister(context);
        }
        JavaCompiler comp = JavaCompiler.instance(context);
        if (options.get(Option.XSTDOUT) != null) {
            comp.closeables = comp.closeables.prepend(this.log.getWriter(Log.WriterKind.NOTICE));
        }
        try {
            comp.compile(args.getFileObjects(), args.getClassNames(), null);
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    Result result = Result.OK;
                    return result;
                }
                String string = String.valueOf(String.valueOf(this.log.expectDiagKeys));
                this.log.printRawLines(new StringBuilder(36 + string.length()).append("expected diagnostic keys not found: ").append(string).toString());
                Result ex = Result.ERROR;
                return ex;
            }
            Result result = comp.errorCount() == 0 ? Result.OK : Result.ERROR;
            return result;
        }
        catch (OutOfMemoryError | StackOverflowError ex) {
            this.resourceMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError ex) {
            this.feMessage(ex, options);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || options.isSet("dev")) {
                this.bugMessage(ex);
            }
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (comp != null) {
                try {
                    comp.close();
                }
                catch (ClientCodeException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
        }
    }

    void bugMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable ex, Options options) {
        this.log.printRawLines(ex.getMessage());
        if (ex.getCause() != null && options.isSet("dev")) {
            ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void showClass(String className) {
        PrintWriter pw = this.log.getWriter(Log.WriterKind.NOTICE);
        String string = String.valueOf(className);
        pw.println(string.length() != 0 ? "javac: show class: ".concat(string) : new String("javac: show class: "));
        String string2 = String.valueOf(String.valueOf(className.replace('.', '/')));
        URL url = this.getClass().getResource(new StringBuilder(7 + string2.length()).append("/").append(string2).append(".class").toString());
        if (url == null) {
            pw.println("  class not found");
        } else {
            String string3 = String.valueOf(String.valueOf(url));
            pw.println(new StringBuilder(2 + string3.length()).append("  ").append(string3).toString());
            try {
                byte[] digest;
                String algorithm = "MD5";
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestInputStream in = new DigestInputStream(url.openStream(), md);
                Object object = null;
                try {
                    int n;
                    byte[] buf = new byte[8192];
                    while ((n = in.read(buf)) > 0) {
                    }
                    digest = md.digest();
                }
                catch (Throwable x2) {
                    object = x2;
                    throw x2;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)object).addSuppressed(x2);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (byte b : digest) {
                    sb.append(String.format("%02x", b));
                }
                object = String.valueOf(String.valueOf("  MD5 checksum: "));
                String string4 = String.valueOf(String.valueOf(sb));
                pw.println(new StringBuilder(0 + ((String)object).length() + string4.length()).append((String)object).append(string4).toString());
            }
            catch (IOException | NoSuchAlgorithmException e) {
                String string5 = String.valueOf(String.valueOf(e));
                pw.println(new StringBuilder(25 + string5.length()).append("  cannot compute digest: ").append(string5).toString());
            }
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int exitCode) {
            this.exitCode = exitCode;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

