/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class Locations {
    private Log log;
    private FSInfo fsInfo;
    private boolean warn;
    Map<JavaFileManager.Location, LocationHandler> handlersForLocation;
    Map<Option, LocationHandler> handlersForOption;

    public Locations() {
        this.initHandlers();
    }

    public void update(Log log, Lint lint, FSInfo fsInfo) {
        this.log = log;
        this.warn = lint.isEnabled(Lint.LintCategory.PATH);
        this.fsInfo = fsInfo;
    }

    public Collection<File> bootClassPath() {
        return this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
    }

    public boolean isDefaultBootClassPath() {
        BootClassPathLocationHandler h = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return h.isDefault();
    }

    boolean isDefaultBootClassPathRtJar(File file) {
        BootClassPathLocationHandler h = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return h.isDefaultRtJar(file);
    }

    public Collection<File> userClassPath() {
        return this.getLocation(StandardLocation.CLASS_PATH);
    }

    public Collection<File> sourcePath() {
        Collection<File> p = this.getLocation(StandardLocation.SOURCE_PATH);
        return p == null || p.isEmpty() ? null : p;
    }

    private static Iterable<File> getPathEntries(String path) {
        return Locations.getPathEntries(path, null);
    }

    private static Iterable<File> getPathEntries(String path, File emptyPathDefault) {
        ListBuffer<File> entries = new ListBuffer<File>();
        int start = 0;
        while (start <= path.length()) {
            int sep = path.indexOf(File.pathSeparatorChar, start);
            if (sep == -1) {
                sep = path.length();
            }
            if (start < sep) {
                entries.add(new File(path.substring(start, sep)));
            } else if (emptyPathDefault != null) {
                entries.add(emptyPathDefault);
            }
            start = sep + 1;
        }
        return entries;
    }

    void initHandlers() {
        LocationHandler[] handlers;
        this.handlersForLocation = new HashMap<JavaFileManager.Location, LocationHandler>();
        this.handlersForOption = new EnumMap<Option, LocationHandler>(Option.class);
        for (LocationHandler h : handlers = new LocationHandler[]{new BootClassPathLocationHandler(), new ClassPathLocationHandler(), new SimpleLocationHandler(StandardLocation.SOURCE_PATH, Option.SOURCEPATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_PATH, Option.PROCESSORPATH), new OutputLocationHandler(StandardLocation.CLASS_OUTPUT, Option.D), new OutputLocationHandler(StandardLocation.SOURCE_OUTPUT, Option.S), new OutputLocationHandler(StandardLocation.NATIVE_HEADER_OUTPUT, Option.H)}) {
            this.handlersForLocation.put(h.location, h);
            for (Option o : h.options) {
                this.handlersForOption.put(o, h);
            }
        }
    }

    public boolean handleOption(Option option, String value) {
        LocationHandler h = this.handlersForOption.get((Object)option);
        return h == null ? false : h.handleOption(option, value);
    }

    Collection<File> getLocation(JavaFileManager.Location location) {
        LocationHandler h = this.getHandler(location);
        return h == null ? null : h.getLocation();
    }

    File getOutputLocation(JavaFileManager.Location location) {
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException();
        }
        LocationHandler h = this.getHandler(location);
        return ((OutputLocationHandler)h).outputDir;
    }

    void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
        LocationHandler h = this.getHandler(location);
        if (h == null) {
            h = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new SimpleLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, h);
        }
        h.setLocation(files);
    }

    protected LocationHandler getHandler(JavaFileManager.Location location) {
        location.getClass();
        return this.handlersForLocation.get(location);
    }

    private boolean isArchive(File file) {
        String n = StringUtils.toLowerCase(file.getName());
        return this.fsInfo.isFile(file) && (n.endsWith(".jar") || n.endsWith(".zip"));
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = Locations.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        urls = Arrays.copyOf(urls, count);
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            String string = String.valueOf(name);
            String string2 = name = string.length() != 0 ? "/".concat(string) : new String("/");
        }
        if (!file.isFile()) {
            name = String.valueOf(name).concat("/");
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(file.toString());
        }
    }

    private class BootClassPathLocationHandler
    extends LocationHandler {
        private Collection<File> searchPath;
        final Map<Option, String> optionValues;
        private File defaultBootClassPathRtJar;
        private boolean isDefaultBootClassPath;

        BootClassPathLocationHandler() {
            super(StandardLocation.PLATFORM_CLASS_PATH, Option.BOOTCLASSPATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS);
            this.optionValues = new EnumMap<Option, String>(Option.class);
            this.defaultBootClassPathRtJar = null;
        }

        boolean isDefault() {
            this.lazy();
            return this.isDefaultBootClassPath;
        }

        boolean isDefaultRtJar(File file) {
            this.lazy();
            return file.equals(this.defaultBootClassPathRtJar);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            option = this.canonicalize(option);
            this.optionValues.put(option, value);
            if (option == Option.BOOTCLASSPATH) {
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_PREPEND);
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_APPEND);
            }
            this.searchPath = null;
            return true;
        }

        private Option canonicalize(Option option) {
            switch (option) {
                case XBOOTCLASSPATH: {
                    return Option.BOOTCLASSPATH;
                }
                case DJAVA_ENDORSED_DIRS: {
                    return Option.ENDORSEDDIRS;
                }
                case DJAVA_EXT_DIRS: {
                    return Option.EXTDIRS;
                }
            }
            return option;
        }

        @Override
        Collection<File> getLocation() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        void setLocation(Iterable<? extends File> files) {
            if (files == null) {
                this.searchPath = null;
            } else {
                this.defaultBootClassPathRtJar = null;
                this.isDefaultBootClassPath = false;
                Path p = new Path().addFiles(files, false);
                this.searchPath = Collections.unmodifiableCollection(p);
                this.optionValues.clear();
            }
        }

        Path computePath() {
            this.defaultBootClassPathRtJar = null;
            Path path = new Path();
            String bootclasspathOpt = this.optionValues.get((Object)Option.BOOTCLASSPATH);
            String endorseddirsOpt = this.optionValues.get((Object)Option.ENDORSEDDIRS);
            String extdirsOpt = this.optionValues.get((Object)Option.EXTDIRS);
            String xbootclasspathPrependOpt = this.optionValues.get((Object)Option.XBOOTCLASSPATH_PREPEND);
            String xbootclasspathAppendOpt = this.optionValues.get((Object)Option.XBOOTCLASSPATH_APPEND);
            path.addFiles(xbootclasspathPrependOpt);
            if (endorseddirsOpt != null) {
                path.addDirectories(endorseddirsOpt);
            } else {
                path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
            }
            if (bootclasspathOpt != null) {
                path.addFiles(bootclasspathOpt);
            } else {
                String files = System.getProperty("sun.boot.class.path");
                path.addFiles(files, false);
                File rt_jar = new File("rt.jar");
                for (File file : Locations.getPathEntries(files)) {
                    if (!new File(file.getName()).equals(rt_jar)) continue;
                    this.defaultBootClassPathRtJar = file;
                }
            }
            path.addFiles(xbootclasspathAppendOpt);
            if (extdirsOpt != null) {
                path.addDirectories(extdirsOpt);
            } else {
                path.addDirectories(System.getProperty("java.ext.dirs"), false);
            }
            this.isDefaultBootClassPath = xbootclasspathPrependOpt == null && bootclasspathOpt == null && xbootclasspathAppendOpt == null;
            return path;
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.searchPath = Collections.unmodifiableCollection(this.computePath());
            }
        }
    }

    private class ClassPathLocationHandler
    extends SimpleLocationHandler {
        ClassPathLocationHandler() {
            super(StandardLocation.CLASS_PATH, Option.CLASSPATH, Option.CP);
        }

        @Override
        Collection<File> getLocation() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        protected Path computePath(String value) {
            String cp = value;
            if (cp == null) {
                cp = System.getProperty("env.class.path");
            }
            if (cp == null && System.getProperty("application.home") == null) {
                cp = System.getProperty("java.class.path");
            }
            if (cp == null) {
                cp = ".";
            }
            return this.createPath().addFiles(cp);
        }

        @Override
        protected Path createPath() {
            return new Path().expandJarClassPaths(true).emptyPathDefault(new File("."));
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.setLocation(null);
            }
        }
    }

    private class SimpleLocationHandler
    extends LocationHandler {
        protected Collection<File> searchPath;

        SimpleLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.searchPath = value == null ? null : Collections.unmodifiableCollection(this.createPath().addFiles(value));
            return true;
        }

        @Override
        Collection<File> getLocation() {
            return this.searchPath;
        }

        @Override
        void setLocation(Iterable<? extends File> files) {
            Path p = files == null ? this.computePath(null) : this.createPath().addFiles(files);
            this.searchPath = Collections.unmodifiableCollection(p);
        }

        protected Path computePath(String value) {
            return this.createPath().addFiles(value);
        }

        protected Path createPath() {
            return new Path();
        }
    }

    private class OutputLocationHandler
    extends LocationHandler {
        private File outputDir;

        OutputLocationHandler(JavaFileManager.Location location, Option ... options) {
            super(location, options);
        }

        @Override
        boolean handleOption(Option option, String value) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.outputDir = value == null ? null : new File(value);
            return true;
        }

        @Override
        Collection<File> getLocation() {
            return this.outputDir == null ? null : Collections.singleton(this.outputDir);
        }

        @Override
        void setLocation(Iterable<? extends File> files) throws IOException {
            if (files == null) {
                this.outputDir = null;
            } else {
                Iterator<? extends File> pathIter = files.iterator();
                if (!pathIter.hasNext()) {
                    throw new IllegalArgumentException("empty path for directory");
                }
                File dir = pathIter.next();
                if (pathIter.hasNext()) {
                    throw new IllegalArgumentException("path too long for directory");
                }
                if (!dir.exists()) {
                    String string = String.valueOf(String.valueOf(dir));
                    throw new FileNotFoundException(new StringBuilder(16 + string.length()).append(string).append(": does not exist").toString());
                }
                if (!dir.isDirectory()) {
                    String string = String.valueOf(String.valueOf(dir));
                    throw new IOException(new StringBuilder(17 + string.length()).append(string).append(": not a directory").toString());
                }
                this.outputDir = dir;
            }
        }
    }

    protected abstract class LocationHandler {
        final JavaFileManager.Location location;
        final Set<Option> options;

        protected LocationHandler(JavaFileManager.Location location, Option ... options) {
            this.location = location;
            this.options = options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options));
        }

        abstract boolean handleOption(Option var1, String var2);

        abstract Collection<File> getLocation();

        abstract void setLocation(Iterable<? extends File> var1) throws IOException;
    }

    private class Path
    extends LinkedHashSet<File> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private final Set<File> canonicalValues = new HashSet<File>();
        private File emptyPathDefault = null;

        private Path() {
        }

        public Path expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public Path emptyPathDefault(File x) {
            this.emptyPathDefault = x;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path addDirectories(String dirs, boolean warn) {
            boolean prev = this.expandJarClassPaths;
            this.expandJarClassPaths = true;
            try {
                if (dirs != null) {
                    for (File dir : Locations.getPathEntries(dirs)) {
                        this.addDirectory(dir, warn);
                    }
                }
                Path path = this;
                return path;
            }
            finally {
                this.expandJarClassPaths = prev;
            }
        }

        public Path addDirectories(String dirs) {
            return this.addDirectories(dirs, Locations.this.warn);
        }

        private void addDirectory(File dir, boolean warn) {
            if (!dir.isDirectory()) {
                if (warn) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, "dir.path.element.not.found", dir);
                }
                return;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File direntry : files) {
                if (!Locations.this.isArchive(direntry)) continue;
                this.addFile(direntry, warn);
            }
        }

        public Path addFiles(String files, boolean warn) {
            if (files != null) {
                this.addFiles(Locations.getPathEntries(files, this.emptyPathDefault), warn);
            }
            return this;
        }

        public Path addFiles(String files) {
            return this.addFiles(files, Locations.this.warn);
        }

        public Path addFiles(Iterable<? extends File> files, boolean warn) {
            if (files != null) {
                for (File file : files) {
                    this.addFile(file, warn);
                }
            }
            return this;
        }

        public Path addFiles(Iterable<? extends File> files) {
            return this.addFiles(files, Locations.this.warn);
        }

        public void addFile(File file, boolean warn) {
            if (this.contains(file)) {
                return;
            }
            if (!Locations.this.fsInfo.exists(file)) {
                if (warn) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, "path.element.not.found", file);
                }
                super.add(file);
                return;
            }
            File canonFile = Locations.this.fsInfo.getCanonicalFile(file);
            if (this.canonicalValues.contains(canonFile)) {
                return;
            }
            if (Locations.this.fsInfo.isFile(file) && !Locations.this.isArchive(file)) {
                try {
                    ZipFile z = new ZipFile(file);
                    z.close();
                    if (warn) {
                        Locations.this.log.warning(Lint.LintCategory.PATH, "unexpected.archive.file", file);
                    }
                }
                catch (IOException e) {
                    if (warn) {
                        Locations.this.log.warning(Lint.LintCategory.PATH, "invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(canonFile);
            if (this.expandJarClassPaths && Locations.this.fsInfo.isFile(file)) {
                this.addJarClassPath(file, warn);
            }
        }

        private void addJarClassPath(File jarFile, boolean warn) {
            try {
                for (File f : Locations.this.fsInfo.getJarClassPath(jarFile)) {
                    this.addFile(f, warn);
                }
            }
            catch (IOException e) {
                Locations.this.log.error("error.reading.file", jarFile, JavacFileManager.getMessage(e));
            }
        }
    }
}

