/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Join;
import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return AlwaysTruePredicate.INSTANCE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return AlwaysFalsePredicate.INSTANCE;
    }

    public static <T> Predicate<T> isNull() {
        return IsNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> notNull() {
        return NotNullPredicate.INSTANCE;
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(components);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return Predicates.and(Arrays.asList(components));
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return Predicates.and(Arrays.asList(first, second));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(components);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return Predicates.or(Arrays.asList(components));
    }

    public static <T> Predicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return Predicates.or(Arrays.asList(first, second));
    }

    public static <T> Predicate<T> isEqualTo(@Nullable T target) {
        return target == null ? Predicates.isNull() : new IsEqualToPredicate(target);
    }

    public static Predicate<Object> isSameAs(@Nullable Object target) {
        return target == null ? Predicates.isNull() : new IsSameAsPredicate(target);
    }

    public static <T> Predicate<T> in(Collection<?> target) {
        return new InPredicate(target);
    }

    public static <A, B> Predicate<A> compose(Predicate<? super B> predicate, Function<? super A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    private static boolean iterableElementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> iterator1 = iterable1.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator1.next().equals(iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        private static final long serialVersionUID = -6029206722887771572L;
        final Predicate<? super B> p;
        final Function<? super A, ? extends B> f;

        private CompositionPredicate(Predicate<? super B> p, Function<? super A, ? extends B> f) {
            this.p = Preconditions.checkNotNull(p);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        public boolean apply(A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CompositionPredicate) {
                CompositionPredicate that = (CompositionPredicate)obj;
                return ((Object)this.f).equals(that.f) && ((Object)this.p).equals(that.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            return this.p.toString() + "(" + this.f.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 8423798306294600396L;
        private final Collection<?> target;

        private InPredicate(Collection<?> target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InPredicate) {
                InPredicate that = (InPredicate)obj;
                return ((Object)this.target).equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.target).hashCode();
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotNullPredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = -1450999195742675143L;
        static final NotNullPredicate INSTANCE = new NotNullPredicate();

        private NotNullPredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return o != null;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public int hashCode() {
            return -1128035029;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == INSTANCE;
        }

        public String toString() {
            return "NotNull";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsNullPredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = -2507344851931204908L;
        static final IsNullPredicate INSTANCE = new IsNullPredicate();

        private IsNullPredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return o == null;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public int hashCode() {
            return 1128035028;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == INSTANCE;
        }

        public String toString() {
            return "IsNull";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsSameAsPredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = -6693499628919249233L;
        private final Object target;

        private IsSameAsPredicate(Object target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(Object o) {
            return this.target == o;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsSameAsPredicate) {
                IsSameAsPredicate that = (IsSameAsPredicate)obj;
                return this.target == that.target;
            }
            return false;
        }

        public String toString() {
            return "IsSameAs(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 6457380537065200145L;
        private final T target;

        private IsEqualToPredicate(T target) {
            this.target = Preconditions.checkNotNull(target);
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -7942366790698074803L;
        private final Iterable<? extends Predicate<? super T>> components;

        private OrPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = Preconditions.checkContentsNotNull(components);
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int result = 0;
            for (Predicate<T> predicate : this.components) {
                result |= predicate.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OrPredicate) {
                OrPredicate that = (OrPredicate)obj;
                return Predicates.iterableElementsEqual(this.components, that.components);
            }
            return false;
        }

        public String toString() {
            return "Or(" + Join.join(",", this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = 1022358602593297546L;
        private final Iterable<? extends Predicate<? super T>> components;

        private AndPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = Preconditions.checkContentsNotNull(components);
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = -1;
            for (Predicate<T> predicate : this.components) {
                result &= predicate.hashCode();
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AndPredicate) {
                AndPredicate that = (AndPredicate)obj;
                return Predicates.iterableElementsEqual(this.components, that.components);
            }
            return false;
        }

        public String toString() {
            return "And(" + Join.join(",", this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private static final long serialVersionUID = -5113445916422049953L;
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NotPredicate) {
                NotPredicate that = (NotPredicate)obj;
                return ((Object)this.predicate).equals(that.predicate);
            }
            return false;
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysFalsePredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = -565481022115659695L;
        static final AlwaysFalsePredicate INSTANCE = new AlwaysFalsePredicate();

        private AlwaysFalsePredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return false;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == INSTANCE;
        }

        public String toString() {
            return "AlwaysFalse";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlwaysTruePredicate
    implements Predicate<Object>,
    Serializable {
        private static final long serialVersionUID = 8759914710239461322L;
        static final AlwaysTruePredicate INSTANCE = new AlwaysTruePredicate();

        private AlwaysTruePredicate() {
        }

        @Override
        public boolean apply(Object o) {
            return true;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public int hashCode() {
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == INSTANCE;
        }

        public String toString() {
            return "AlwaysTrue";
        }
    }
}

