/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageFormat, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageFormat, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMessageFormat, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessageFormat, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessageFormat, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessageFormat, errorMessageArgs));
        }
        return reference;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable) {
        for (Object element : iterable) {
            Preconditions.checkNotNull(element);
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable, Object errorMessage) {
        Preconditions.checkNotNull(iterable, errorMessage);
        for (Object element : iterable) {
            Preconditions.checkNotNull(element, errorMessage);
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable, String errorMessageFormat, Object ... errorMessageArgs) {
        Preconditions.checkNotNull(iterable, errorMessageFormat, errorMessageArgs);
        for (Object element : iterable) {
            Preconditions.checkNotNull(element, errorMessageFormat, errorMessageArgs);
        }
        return iterable;
    }
}

