/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSplitter {
    private static final String EXT = ".jar";
    private static final String INDEX_FILE = "INDEX.LIST";
    private static Logger logger = Logger.getLogger(JarSplitter.class.getName());
    private final File inputJar;
    private final File outputDirectory;
    private final int maximumSize;
    private final boolean replicateManifests;
    private final Set<String> excludes;
    private int nextFileIndex = 0;
    private long currentSize = 0L;
    private JarOutputStream currentStream;
    private int outputDigits;

    public JarSplitter(File inputJar, File outputDirectory, int maximumSize, boolean replicateManifests, int outputDigits, Set<String> excludes) {
        this.inputJar = inputJar;
        this.outputDirectory = outputDirectory;
        this.maximumSize = maximumSize;
        this.replicateManifests = replicateManifests;
        this.outputDigits = outputDigits;
        this.excludes = excludes;
    }

    public void run() throws IOException {
        JarEntry entry;
        this.outputDirectory.mkdirs();
        JarInputStream inputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(this.inputJar)));
        Manifest manifest = inputStream.getManifest();
        long manifestSize = 0L;
        if (manifest != null && this.replicateManifests) {
            manifestSize = this.getManifestSize(manifest);
        }
        this.currentStream = this.newJarOutputStream(manifest);
        this.currentSize = manifestSize;
        while ((entry = inputStream.getNextJarEntry()) != null) {
            String name = entry.getName();
            if (!this.shouldIncludeFile(name)) continue;
            JarEntry newEntry = new JarEntry(entry.getName());
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            long size = this.readIntoBuffers(inputStream, buffers);
            if (this.currentSize + size >= (long)this.maximumSize) {
                logger.info("Closing file after writing " + this.currentSize + " bytes.");
                this.beginNewOutputStream(manifest, manifestSize);
            }
            logger.fine("Copying entry: " + name + " (" + size + " bytes)");
            this.currentStream.putNextEntry(newEntry);
            for (byte[] writeBuffer : buffers) {
                logger.finer("Writing " + writeBuffer.length + " bytes from a buffer.");
                this.currentStream.write(writeBuffer, 0, writeBuffer.length);
            }
            this.currentSize += size;
        }
        inputStream.close();
        logger.info("Closing file after writing " + this.currentSize + " bytes.");
        this.currentStream.close();
    }

    private boolean shouldIncludeFile(String fileName) {
        if (fileName.endsWith(INDEX_FILE)) {
            logger.info("Skipping jar index file: " + fileName);
            return false;
        }
        for (String suffix : this.excludes) {
            if (!fileName.endsWith(suffix)) continue;
            logger.info("Skipping file matching excluded suffix '" + suffix + "': " + fileName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getManifestSize(Manifest manifest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            long l = baos.size();
            return l;
        }
        finally {
            baos.close();
        }
    }

    private JarOutputStream newJarOutputStream(Manifest manifest) throws IOException {
        if (manifest == null || !this.replicateManifests) {
            return new JarOutputStream(this.createOutFile(this.nextFileIndex++));
        }
        return new JarOutputStream(this.createOutFile(this.nextFileIndex++), manifest);
    }

    private void beginNewOutputStream(Manifest manifest, long manifestSize) throws IOException {
        this.currentStream.close();
        this.currentStream = this.newJarOutputStream(manifest);
        this.currentSize = manifestSize;
    }

    private long readIntoBuffers(InputStream inputStream, List<byte[]> buffers) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        long size = 0L;
        while ((count = inputStream.read(buffer, 0, buffer.length)) != -1) {
            byte[] bufferCopy = new byte[count];
            System.arraycopy(buffer, 0, bufferCopy, 0, count);
            buffers.add(bufferCopy);
            logger.finer("Read " + count + " bytes into a buffer, total size is now " + (size += (long)count));
        }
        return size;
    }

    private OutputStream createOutFile(int index) throws IOException {
        String name = this.inputJar.getName();
        if (name.endsWith(EXT)) {
            name = name.substring(0, name.length() - EXT.length());
        }
        String formatString = "%s-%0" + this.outputDigits + "d%s";
        String newName = String.format(formatString, name, index, EXT);
        File newFile = new File(this.outputDirectory, newName);
        logger.info("Opening new file: " + newFile);
        return new BufferedOutputStream(new FileOutputStream(newFile));
    }
}

