/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.ReadWritableInterval;
import com.google.appengine.repackaged.org.joda.time.ReadWritablePeriod;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.convert.AbstractConverter;
import com.google.appengine.repackaged.org.joda.time.convert.DurationConverter;
import com.google.appengine.repackaged.org.joda.time.convert.InstantConverter;
import com.google.appengine.repackaged.org.joda.time.convert.IntervalConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PartialConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PeriodConverter;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.ISOPeriodFormat;
import com.google.appengine.repackaged.org.joda.time.format.PeriodFormatter;

class StringConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter,
DurationConverter,
PeriodConverter,
IntervalConverter {
    static final StringConverter INSTANCE = new StringConverter();
    static /* synthetic */ Class class$java$lang$String;

    protected StringConverter() {
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        String string = (String)object;
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        return dateTimeFormatter.withChronology(chronology).parseMillis(string);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter.getZone() != null) {
            chronology = chronology.withZone(dateTimeFormatter.getZone());
        }
        long l = dateTimeFormatter.withChronology(chronology).parseMillis((String)object);
        return chronology.get(readablePartial, l);
    }

    public long getDurationMillis(Object object) {
        String string = (String)object;
        String string2 = string;
        int n = string2.length();
        if (n < 4 || string2.charAt(0) != 'P' && string2.charAt(0) != 'p' || string2.charAt(1) != 'T' && string2.charAt(1) != 't' || string2.charAt(n - 1) != 'S' && string2.charAt(n - 1) != 's') {
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
        string2 = string2.substring(2, n - 1);
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) >= '0' && string2.charAt(i) <= '9' || i == 0 && string2.charAt(0) == '-') continue;
            if (i > 0 && string2.charAt(i) == '.' && n2 == -1) {
                n2 = i;
                continue;
            }
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
        long l = 0L;
        long l2 = 0L;
        if (n2 > 0) {
            l2 = Long.parseLong(string2.substring(0, n2));
            if ((string2 = string2.substring(n2 + 1)).length() != 3) {
                string2 = (string2 + "000").substring(0, 3);
            }
            l = Integer.parseInt(string2);
        } else {
            l2 = Long.parseLong(string2);
        }
        if (l2 < 0L) {
            return FieldUtils.safeAdd(FieldUtils.safeMultiply(l2, 1000), -l);
        }
        return FieldUtils.safeAdd(FieldUtils.safeMultiply(l2, 1000), l);
    }

    public void setInto(ReadWritablePeriod readWritablePeriod, Object object, Chronology chronology) {
        String string = (String)object;
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        readWritablePeriod.clear();
        int n = periodFormatter.parseInto(readWritablePeriod, string, 0);
        if (n < string.length()) {
            if (n < 0) {
                periodFormatter.withParseType(readWritablePeriod.getPeriodType()).parseMutablePeriod(string);
            }
            throw new IllegalArgumentException("Invalid format: \"" + string + '\"');
        }
    }

    public void setInto(ReadWritableInterval readWritableInterval, Object object, Chronology chronology) {
        DateTime dateTime;
        String string = (String)object;
        int n = string.indexOf(47);
        if (n < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + string);
        }
        String string2 = string.substring(0, n);
        if (string2.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string);
        }
        String string3 = string.substring(n + 1);
        if (string3.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string);
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        dateTimeFormatter = dateTimeFormatter.withChronology(chronology);
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        long l = 0L;
        long l2 = 0L;
        Period period = null;
        Chronology chronology2 = null;
        char c = string2.charAt(0);
        if (c == 'P' || c == 'p') {
            period = periodFormatter.withParseType(this.getPeriodType(string2)).parsePeriod(string2);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string2);
            l = dateTime.getMillis();
            chronology2 = dateTime.getChronology();
        }
        c = string3.charAt(0);
        if (c == 'P' || c == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + string);
            }
            period = periodFormatter.withParseType(this.getPeriodType(string3)).parsePeriod(string3);
            chronology = chronology != null ? chronology : chronology2;
            l2 = chronology.add(period, l, 1);
        } else {
            dateTime = dateTimeFormatter.parseDateTime(string3);
            l2 = dateTime.getMillis();
            chronology2 = chronology2 != null ? chronology2 : dateTime.getChronology();
            Chronology chronology3 = chronology = chronology != null ? chronology : chronology2;
            if (period != null) {
                l = chronology.add(period, l2, -1);
            }
        }
        readWritableInterval.setInterval(l, l2);
        readWritableInterval.setChronology(chronology);
    }

    public Class getSupportedType() {
        return class$java$lang$String == null ? (class$java$lang$String = StringConverter.class$("java.lang.String")) : class$java$lang$String;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

