/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.standard;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.LowerCaseFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopAnalyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.WordlistLoader;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;

public class StandardAnalyzer
extends Analyzer {
    private Set stopSet;
    private boolean replaceInvalidAcronym = defaultReplaceInvalidAcronym;
    private static boolean defaultReplaceInvalidAcronym;
    private boolean enableStopPositionIncrements;
    private boolean useDefaultStopPositionIncrements;
    public static final String[] STOP_WORDS;
    public static final Set STOP_WORDS_SET;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public static boolean getDefaultReplaceInvalidAcronym() {
        return defaultReplaceInvalidAcronym;
    }

    public static void setDefaultReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        defaultReplaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer() {
        this(Version.LUCENE_24, STOP_WORDS_SET);
    }

    public StandardAnalyzer(Version matchVersion) {
        this(matchVersion, STOP_WORDS_SET);
    }

    public StandardAnalyzer(Set stopWords) {
        this(Version.LUCENE_24, stopWords);
    }

    public StandardAnalyzer(Version matchVersion, Set stopWords) {
        this.stopSet = stopWords;
        this.init(matchVersion);
    }

    public StandardAnalyzer(String[] stopWords) {
        this(Version.LUCENE_24, StopFilter.makeStopSet(stopWords));
    }

    public StandardAnalyzer(File stopwords) throws IOException {
        this(Version.LUCENE_24, stopwords);
    }

    public StandardAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
        this.init(matchVersion);
    }

    public StandardAnalyzer(Reader stopwords) throws IOException {
        this(Version.LUCENE_24, stopwords);
    }

    public StandardAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet(stopwords);
        this.init(matchVersion);
    }

    public StandardAnalyzer(boolean replaceInvalidAcronym) {
        this(Version.LUCENE_24, STOP_WORDS_SET);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
        this.useDefaultStopPositionIncrements = true;
    }

    public StandardAnalyzer(Reader stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(Version.LUCENE_24, stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(File stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(Version.LUCENE_24, stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(String[] stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(Version.LUCENE_24, StopFilter.makeStopSet(stopwords));
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    public StandardAnalyzer(Set stopwords, boolean replaceInvalidAcronym) throws IOException {
        this(Version.LUCENE_24, stopwords);
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    private final void init(Version matchVersion) {
        this.setOverridesTokenStreamMethod(StandardAnalyzer.class);
        if (matchVersion.onOrAfter(Version.LUCENE_29)) {
            this.enableStopPositionIncrements = true;
        } else {
            this.useDefaultStopPositionIncrements = true;
        }
        this.replaceInvalidAcronym = matchVersion.onOrAfter(Version.LUCENE_24) ? defaultReplaceInvalidAcronym : false;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer tokenStream = new StandardTokenizer(reader, this.replaceInvalidAcronym);
        tokenStream.setMaxTokenLength(this.maxTokenLength);
        TokenFilter result = new StandardFilter(tokenStream);
        result = new LowerCaseFilter(result);
        result = this.useDefaultStopPositionIncrements ? new StopFilter((TokenStream)result, this.stopSet) : new StopFilter(this.enableStopPositionIncrements, (TokenStream)result, this.stopSet);
        return result;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new StandardTokenizer(reader);
            streams.filteredTokenStream = new StandardFilter(streams.tokenStream);
            streams.filteredTokenStream = new LowerCaseFilter(streams.filteredTokenStream);
            streams.filteredTokenStream = this.useDefaultStopPositionIncrements ? new StopFilter(streams.filteredTokenStream, this.stopSet) : new StopFilter(this.enableStopPositionIncrements, streams.filteredTokenStream, this.stopSet);
        } else {
            streams.tokenStream.reset(reader);
        }
        streams.tokenStream.setMaxTokenLength(this.maxTokenLength);
        streams.tokenStream.setReplaceInvalidAcronym(this.replaceInvalidAcronym);
        return streams.filteredTokenStream;
    }

    public boolean isReplaceInvalidAcronym() {
        return this.replaceInvalidAcronym;
    }

    public void setReplaceInvalidAcronym(boolean replaceInvalidAcronym) {
        this.replaceInvalidAcronym = replaceInvalidAcronym;
    }

    static {
        String v = System.getProperty("com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardAnalyzer.replaceInvalidAcronym");
        defaultReplaceInvalidAcronym = v == null || v.equals("true");
        STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;
        STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    }

    private static final class SavedStreams {
        StandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

