/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.dev.Channel;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelManager {
    public static final String TOKEN_PREFIX = "channel";
    private static final Logger logger = Logger.getLogger(ChannelManager.class.getName());
    private final Map<String, Channel> channels;
    private LocalURLFetchService fetchService;
    private final LocalServerEnvironment localServerEnvironment;
    private Random rng = new SecureRandom();
    private Clock clock = Clock.DEFAULT;

    public ChannelManager(LocalServerEnvironment localServerEnvironment, LocalURLFetchService fetchService) {
        this.channels = new ConcurrentHashMap<String, Channel>();
        this.localServerEnvironment = localServerEnvironment;
        this.fetchService = fetchService;
    }

    void setRng(Random rng) {
        this.rng = rng;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    void setFetchService(LocalURLFetchService fetchService) {
        this.fetchService = fetchService;
    }

    Channel getChannel(String clientId) {
        if (clientId != null && this.channels.containsKey(clientId)) {
            return this.channels.get(clientId);
        }
        throw new LocalChannelFailureException("Channel for client id " + clientId + " not found.");
    }

    TokenValidationResult checkTokenValidityAndDecode(String token) {
        String rawToken;
        boolean syntaxValid = false;
        boolean timeValid = false;
        String clientId = null;
        String[] pieces = token.split("-", 2);
        if (pieces.length == 2 && ChannelManager.generateTokenHash(pieces[1]).equals(pieces[0]) && (pieces = (rawToken = pieces[1]).split("-", 4)).length == 4 && TOKEN_PREFIX.equals(pieces[0])) {
            try {
                long expirationMillis = Long.parseLong(pieces[2]);
                syntaxValid = true;
                if (expirationMillis > this.clock.getCurrentTime()) {
                    timeValid = true;
                    clientId = pieces[3];
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new TokenValidationResult(syntaxValid, timeValid, clientId);
    }

    String getClientIdFromToken(String token) {
        return this.checkTokenValidityAndDecode((String)token).clientId;
    }

    Channel getClientChannelFromToken(String token) {
        String clientId = this.getClientIdFromToken(token);
        return this.getChannel(clientId);
    }

    static String generateTokenHash(String token) {
        try {
            return new BigInteger(1, MessageDigest.getInstance("MD5").digest(token.getBytes())).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            return "deadc0de";
        }
    }

    public String createChannel(String clientId, int durationMinutes) {
        String randomNoise = Integer.toString(Math.abs(this.rng.nextInt()), 36);
        String expirationMillis = Long.toString((long)(durationMinutes * 60 * 1000) + this.clock.getCurrentTime());
        String rawToken = Joiner.on((String)"-").join((Object)TOKEN_PREFIX, (Object)randomNoise, new Object[]{expirationMillis, clientId});
        String token = Joiner.on((String)"-").join((Object)ChannelManager.generateTokenHash(rawToken), (Object)rawToken, new Object[0]);
        if (!this.channels.containsKey(clientId)) {
            this.channels.put(clientId, new Channel(clientId));
        }
        return token;
    }

    public void sendMessage(String clientId, String message) {
        if (null == clientId) {
            throw new IllegalArgumentException("clientId cannot be null");
        }
        String clientIdFromToken = this.getClientIdFromToken(clientId);
        if (clientIdFromToken != null) {
            clientId = clientIdFromToken;
        }
        if (this.channels.containsKey(clientId)) {
            this.getChannel(clientId).sendMessage(message);
        } else {
            logger.log(Level.WARNING, "Skipping message to unconnected channel: " + clientId);
        }
    }

    public String connectClient(String token) {
        Channel channel = this.getClientChannelFromToken(token);
        String id = channel.connectClient();
        this.sendChannelPost("connected/", channel.getClientId());
        return id;
    }

    public void disconnectClient(String token, String connectionId) {
        Channel channel = this.getClientChannelFromToken(token);
        channel.disconnectClient(connectionId);
        this.sendChannelPost("disconnected/", channel.getClientId());
    }

    public String getNextClientMessage(String token, String connectionId) {
        Channel channel = this.getClientChannelFromToken(token);
        return channel.getClientMessageQueue(connectionId).poll();
    }

    private void sendChannelPost(String path, String clientId) {
        if (this.fetchService == null) {
            return;
        }
        String url = String.format("http://%s:%d/_ah/channel/%s", this.localServerEnvironment.getAddress(), this.localServerEnvironment.getPort(), path);
        String boundary = "+++";
        String payload = "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"from\"\r\n\r\n" + clientId + "\r\n" + "--" + boundary + "\r\n";
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder().setUrl(url).setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.POST).setPayload(ByteString.copyFrom((byte[])payload.getBytes()));
        requestProto.addHeaderBuilder().setKey("Content-Type").setValue("multipart/form-data; boundary=" + boundary);
        LocalRpcService.Status status = new LocalRpcService.Status();
        this.fetchService.fetch(status, requestProto.build());
    }

    static class TokenValidationResult {
        final boolean syntaxValid;
        final boolean timeValid;
        final String clientId;

        TokenValidationResult(boolean syntaxValid, boolean timeValid, String clientId) {
            this.syntaxValid = syntaxValid;
            this.timeValid = timeValid;
            this.clientId = clientId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TokenValidationResult)) {
                return false;
            }
            TokenValidationResult other = (TokenValidationResult)obj;
            if (this.syntaxValid != other.syntaxValid || this.timeValid != other.timeValid) {
                return false;
            }
            if (this.clientId == null && other.clientId != null) {
                return false;
            }
            return this.clientId == null || this.clientId.equals(other.clientId);
        }
    }
}

