/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/auth.proto

// Protobuf Java Version: 3.25.2
package com.google.api;

/**
 *
 *
 * <pre>
 * Configuration for an authentication provider, including support for
 * [JSON Web Token
 * (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
 * </pre>
 *
 * Protobuf type {@code google.api.AuthProvider}
 */
public final class AuthProvider extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.AuthProvider)
    AuthProviderOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuthProvider.newBuilder() to construct.
  private AuthProvider(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuthProvider() {
    id_ = "";
    issuer_ = "";
    jwksUri_ = "";
    audiences_ = "";
    authorizationUrl_ = "";
    jwtLocations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuthProvider();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.AuthProto.internal_static_google_api_AuthProvider_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.AuthProto.internal_static_google_api_AuthProvider_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.AuthProvider.class, com.google.api.AuthProvider.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the auth provider. It will be referred to by
   * `AuthRequirement.provider_id`.
   *
   * Example: "bookstore_auth".
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the auth provider. It will be referred to by
   * `AuthRequirement.provider_id`.
   *
   * Example: "bookstore_auth".
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ISSUER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object issuer_ = "";
  /**
   *
   *
   * <pre>
   * Identifies the principal that issued the JWT. See
   * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
   * Usually a URL or an email address.
   *
   * Example: https://securetoken.google.com
   * Example: 1234567-compute&#64;developer.gserviceaccount.com
   * </pre>
   *
   * <code>string issuer = 2;</code>
   *
   * @return The issuer.
   */
  @java.lang.Override
  public java.lang.String getIssuer() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issuer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifies the principal that issued the JWT. See
   * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
   * Usually a URL or an email address.
   *
   * Example: https://securetoken.google.com
   * Example: 1234567-compute&#64;developer.gserviceaccount.com
   * </pre>
   *
   * <code>string issuer = 2;</code>
   *
   * @return The bytes for issuer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIssuerBytes() {
    java.lang.Object ref = issuer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      issuer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JWKS_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jwksUri_ = "";
  /**
   *
   *
   * <pre>
   * URL of the provider's public key set to validate signature of the JWT. See
   * [OpenID
   * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
   * Optional if the key set document:
   *  - can be retrieved from
   *    [OpenID
   *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
   *    of the issuer.
   *  - can be inferred from the email domain of the issuer (e.g. a Google
   *  service account).
   *
   * Example: https://www.googleapis.com/oauth2/v1/certs
   * </pre>
   *
   * <code>string jwks_uri = 3;</code>
   *
   * @return The jwksUri.
   */
  @java.lang.Override
  public java.lang.String getJwksUri() {
    java.lang.Object ref = jwksUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jwksUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the provider's public key set to validate signature of the JWT. See
   * [OpenID
   * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
   * Optional if the key set document:
   *  - can be retrieved from
   *    [OpenID
   *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
   *    of the issuer.
   *  - can be inferred from the email domain of the issuer (e.g. a Google
   *  service account).
   *
   * Example: https://www.googleapis.com/oauth2/v1/certs
   * </pre>
   *
   * <code>string jwks_uri = 3;</code>
   *
   * @return The bytes for jwksUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJwksUriBytes() {
    java.lang.Object ref = jwksUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jwksUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIENCES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object audiences_ = "";
  /**
   *
   *
   * <pre>
   * The list of JWT
   * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
   * that are allowed to access. A JWT containing any of these audiences will
   * be accepted. When this setting is absent, JWTs with audiences:
   *   - "https://[service.name]/[google.protobuf.Api.name]"
   *   - "https://[service.name]/"
   * will be accepted.
   * For example, if no audiences are in the setting, LibraryService API will
   * accept JWTs with the following audiences:
   *   -
   *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
   *   - https://library-example.googleapis.com/
   *
   * Example:
   *
   *     audiences: bookstore_android.apps.googleusercontent.com,
   *                bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>string audiences = 4;</code>
   *
   * @return The audiences.
   */
  @java.lang.Override
  public java.lang.String getAudiences() {
    java.lang.Object ref = audiences_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audiences_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The list of JWT
   * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
   * that are allowed to access. A JWT containing any of these audiences will
   * be accepted. When this setting is absent, JWTs with audiences:
   *   - "https://[service.name]/[google.protobuf.Api.name]"
   *   - "https://[service.name]/"
   * will be accepted.
   * For example, if no audiences are in the setting, LibraryService API will
   * accept JWTs with the following audiences:
   *   -
   *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
   *   - https://library-example.googleapis.com/
   *
   * Example:
   *
   *     audiences: bookstore_android.apps.googleusercontent.com,
   *                bookstore_web.apps.googleusercontent.com
   * </pre>
   *
   * <code>string audiences = 4;</code>
   *
   * @return The bytes for audiences.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudiencesBytes() {
    java.lang.Object ref = audiences_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audiences_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHORIZATION_URL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authorizationUrl_ = "";
  /**
   *
   *
   * <pre>
   * Redirect URL if JWT token is required but not present or is expired.
   * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
   * </pre>
   *
   * <code>string authorization_url = 5;</code>
   *
   * @return The authorizationUrl.
   */
  @java.lang.Override
  public java.lang.String getAuthorizationUrl() {
    java.lang.Object ref = authorizationUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authorizationUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Redirect URL if JWT token is required but not present or is expired.
   * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
   * </pre>
   *
   * <code>string authorization_url = 5;</code>
   *
   * @return The bytes for authorizationUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorizationUrlBytes() {
    java.lang.Object ref = authorizationUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authorizationUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JWT_LOCATIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.JwtLocation> jwtLocations_;
  /**
   *
   *
   * <pre>
   * Defines the locations to extract the JWT.  For now it is only used by the
   * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
   * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
   *
   * JWT locations can be one of HTTP headers, URL query parameters or
   * cookies. The rule is that the first match wins.
   *
   * If not specified,  default to use following 3 locations:
   *    1) Authorization: Bearer
   *    2) x-goog-iap-jwt-assertion
   *    3) access_token query parameter
   *
   * Default locations can be specified as followings:
   *    jwt_locations:
   *    - header: Authorization
   *      value_prefix: "Bearer "
   *    - header: x-goog-iap-jwt-assertion
   *    - query: access_token
   * </pre>
   *
   * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.JwtLocation> getJwtLocationsList() {
    return jwtLocations_;
  }
  /**
   *
   *
   * <pre>
   * Defines the locations to extract the JWT.  For now it is only used by the
   * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
   * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
   *
   * JWT locations can be one of HTTP headers, URL query parameters or
   * cookies. The rule is that the first match wins.
   *
   * If not specified,  default to use following 3 locations:
   *    1) Authorization: Bearer
   *    2) x-goog-iap-jwt-assertion
   *    3) access_token query parameter
   *
   * Default locations can be specified as followings:
   *    jwt_locations:
   *    - header: Authorization
   *      value_prefix: "Bearer "
   *    - header: x-goog-iap-jwt-assertion
   *    - query: access_token
   * </pre>
   *
   * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.JwtLocationOrBuilder>
      getJwtLocationsOrBuilderList() {
    return jwtLocations_;
  }
  /**
   *
   *
   * <pre>
   * Defines the locations to extract the JWT.  For now it is only used by the
   * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
   * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
   *
   * JWT locations can be one of HTTP headers, URL query parameters or
   * cookies. The rule is that the first match wins.
   *
   * If not specified,  default to use following 3 locations:
   *    1) Authorization: Bearer
   *    2) x-goog-iap-jwt-assertion
   *    3) access_token query parameter
   *
   * Default locations can be specified as followings:
   *    jwt_locations:
   *    - header: Authorization
   *      value_prefix: "Bearer "
   *    - header: x-goog-iap-jwt-assertion
   *    - query: access_token
   * </pre>
   *
   * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
   */
  @java.lang.Override
  public int getJwtLocationsCount() {
    return jwtLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * Defines the locations to extract the JWT.  For now it is only used by the
   * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
   * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
   *
   * JWT locations can be one of HTTP headers, URL query parameters or
   * cookies. The rule is that the first match wins.
   *
   * If not specified,  default to use following 3 locations:
   *    1) Authorization: Bearer
   *    2) x-goog-iap-jwt-assertion
   *    3) access_token query parameter
   *
   * Default locations can be specified as followings:
   *    jwt_locations:
   *    - header: Authorization
   *      value_prefix: "Bearer "
   *    - header: x-goog-iap-jwt-assertion
   *    - query: access_token
   * </pre>
   *
   * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
   */
  @java.lang.Override
  public com.google.api.JwtLocation getJwtLocations(int index) {
    return jwtLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Defines the locations to extract the JWT.  For now it is only used by the
   * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
   * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
   *
   * JWT locations can be one of HTTP headers, URL query parameters or
   * cookies. The rule is that the first match wins.
   *
   * If not specified,  default to use following 3 locations:
   *    1) Authorization: Bearer
   *    2) x-goog-iap-jwt-assertion
   *    3) access_token query parameter
   *
   * Default locations can be specified as followings:
   *    jwt_locations:
   *    - header: Authorization
   *      value_prefix: "Bearer "
   *    - header: x-goog-iap-jwt-assertion
   *    - query: access_token
   * </pre>
   *
   * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
   */
  @java.lang.Override
  public com.google.api.JwtLocationOrBuilder getJwtLocationsOrBuilder(int index) {
    return jwtLocations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jwksUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, jwksUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audiences_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, audiences_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizationUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, authorizationUrl_);
    }
    for (int i = 0; i < jwtLocations_.size(); i++) {
      output.writeMessage(6, jwtLocations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, issuer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jwksUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, jwksUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audiences_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, audiences_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizationUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, authorizationUrl_);
    }
    for (int i = 0; i < jwtLocations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, jwtLocations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.AuthProvider)) {
      return super.equals(obj);
    }
    com.google.api.AuthProvider other = (com.google.api.AuthProvider) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getIssuer().equals(other.getIssuer())) return false;
    if (!getJwksUri().equals(other.getJwksUri())) return false;
    if (!getAudiences().equals(other.getAudiences())) return false;
    if (!getAuthorizationUrl().equals(other.getAuthorizationUrl())) return false;
    if (!getJwtLocationsList().equals(other.getJwtLocationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + ISSUER_FIELD_NUMBER;
    hash = (53 * hash) + getIssuer().hashCode();
    hash = (37 * hash) + JWKS_URI_FIELD_NUMBER;
    hash = (53 * hash) + getJwksUri().hashCode();
    hash = (37 * hash) + AUDIENCES_FIELD_NUMBER;
    hash = (53 * hash) + getAudiences().hashCode();
    hash = (37 * hash) + AUTHORIZATION_URL_FIELD_NUMBER;
    hash = (53 * hash) + getAuthorizationUrl().hashCode();
    if (getJwtLocationsCount() > 0) {
      hash = (37 * hash) + JWT_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getJwtLocationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.AuthProvider parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.AuthProvider parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.AuthProvider parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.AuthProvider parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.AuthProvider parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.AuthProvider parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.AuthProvider parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.AuthProvider parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.AuthProvider parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.AuthProvider parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.AuthProvider parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.AuthProvider parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.AuthProvider prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for an authentication provider, including support for
   * [JSON Web Token
   * (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
   * </pre>
   *
   * Protobuf type {@code google.api.AuthProvider}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.AuthProvider)
      com.google.api.AuthProviderOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.AuthProto.internal_static_google_api_AuthProvider_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.AuthProto.internal_static_google_api_AuthProvider_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.AuthProvider.class, com.google.api.AuthProvider.Builder.class);
    }

    // Construct using com.google.api.AuthProvider.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      issuer_ = "";
      jwksUri_ = "";
      audiences_ = "";
      authorizationUrl_ = "";
      if (jwtLocationsBuilder_ == null) {
        jwtLocations_ = java.util.Collections.emptyList();
      } else {
        jwtLocations_ = null;
        jwtLocationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.AuthProto.internal_static_google_api_AuthProvider_descriptor;
    }

    @java.lang.Override
    public com.google.api.AuthProvider getDefaultInstanceForType() {
      return com.google.api.AuthProvider.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.AuthProvider build() {
      com.google.api.AuthProvider result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.AuthProvider buildPartial() {
      com.google.api.AuthProvider result = new com.google.api.AuthProvider(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.AuthProvider result) {
      if (jwtLocationsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          jwtLocations_ = java.util.Collections.unmodifiableList(jwtLocations_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.jwtLocations_ = jwtLocations_;
      } else {
        result.jwtLocations_ = jwtLocationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.AuthProvider result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.issuer_ = issuer_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.jwksUri_ = jwksUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.audiences_ = audiences_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.authorizationUrl_ = authorizationUrl_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.AuthProvider) {
        return mergeFrom((com.google.api.AuthProvider) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.AuthProvider other) {
      if (other == com.google.api.AuthProvider.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getIssuer().isEmpty()) {
        issuer_ = other.issuer_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getJwksUri().isEmpty()) {
        jwksUri_ = other.jwksUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getAudiences().isEmpty()) {
        audiences_ = other.audiences_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getAuthorizationUrl().isEmpty()) {
        authorizationUrl_ = other.authorizationUrl_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (jwtLocationsBuilder_ == null) {
        if (!other.jwtLocations_.isEmpty()) {
          if (jwtLocations_.isEmpty()) {
            jwtLocations_ = other.jwtLocations_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureJwtLocationsIsMutable();
            jwtLocations_.addAll(other.jwtLocations_);
          }
          onChanged();
        }
      } else {
        if (!other.jwtLocations_.isEmpty()) {
          if (jwtLocationsBuilder_.isEmpty()) {
            jwtLocationsBuilder_.dispose();
            jwtLocationsBuilder_ = null;
            jwtLocations_ = other.jwtLocations_;
            bitField0_ = (bitField0_ & ~0x00000020);
            jwtLocationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getJwtLocationsFieldBuilder()
                    : null;
          } else {
            jwtLocationsBuilder_.addAllMessages(other.jwtLocations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                issuer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                jwksUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                audiences_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                authorizationUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.api.JwtLocation m =
                    input.readMessage(com.google.api.JwtLocation.parser(), extensionRegistry);
                if (jwtLocationsBuilder_ == null) {
                  ensureJwtLocationsIsMutable();
                  jwtLocations_.add(m);
                } else {
                  jwtLocationsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the auth provider. It will be referred to by
     * `AuthRequirement.provider_id`.
     *
     * Example: "bookstore_auth".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the auth provider. It will be referred to by
     * `AuthRequirement.provider_id`.
     *
     * Example: "bookstore_auth".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the auth provider. It will be referred to by
     * `AuthRequirement.provider_id`.
     *
     * Example: "bookstore_auth".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the auth provider. It will be referred to by
     * `AuthRequirement.provider_id`.
     *
     * Example: "bookstore_auth".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the auth provider. It will be referred to by
     * `AuthRequirement.provider_id`.
     *
     * Example: "bookstore_auth".
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object issuer_ = "";
    /**
     *
     *
     * <pre>
     * Identifies the principal that issued the JWT. See
     * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
     * Usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 2;</code>
     *
     * @return The issuer.
     */
    public java.lang.String getIssuer() {
      java.lang.Object ref = issuer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issuer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the principal that issued the JWT. See
     * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
     * Usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 2;</code>
     *
     * @return The bytes for issuer.
     */
    public com.google.protobuf.ByteString getIssuerBytes() {
      java.lang.Object ref = issuer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issuer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the principal that issued the JWT. See
     * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
     * Usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 2;</code>
     *
     * @param value The issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      issuer_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the principal that issued the JWT. See
     * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
     * Usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssuer() {
      issuer_ = getDefaultInstance().getIssuer();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the principal that issued the JWT. See
     * https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
     * Usually a URL or an email address.
     *
     * Example: https://securetoken.google.com
     * Example: 1234567-compute&#64;developer.gserviceaccount.com
     * </pre>
     *
     * <code>string issuer = 2;</code>
     *
     * @param value The bytes for issuer to set.
     * @return This builder for chaining.
     */
    public Builder setIssuerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      issuer_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object jwksUri_ = "";
    /**
     *
     *
     * <pre>
     * URL of the provider's public key set to validate signature of the JWT. See
     * [OpenID
     * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
     * Optional if the key set document:
     *  - can be retrieved from
     *    [OpenID
     *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
     *    of the issuer.
     *  - can be inferred from the email domain of the issuer (e.g. a Google
     *  service account).
     *
     * Example: https://www.googleapis.com/oauth2/v1/certs
     * </pre>
     *
     * <code>string jwks_uri = 3;</code>
     *
     * @return The jwksUri.
     */
    public java.lang.String getJwksUri() {
      java.lang.Object ref = jwksUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jwksUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the provider's public key set to validate signature of the JWT. See
     * [OpenID
     * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
     * Optional if the key set document:
     *  - can be retrieved from
     *    [OpenID
     *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
     *    of the issuer.
     *  - can be inferred from the email domain of the issuer (e.g. a Google
     *  service account).
     *
     * Example: https://www.googleapis.com/oauth2/v1/certs
     * </pre>
     *
     * <code>string jwks_uri = 3;</code>
     *
     * @return The bytes for jwksUri.
     */
    public com.google.protobuf.ByteString getJwksUriBytes() {
      java.lang.Object ref = jwksUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jwksUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the provider's public key set to validate signature of the JWT. See
     * [OpenID
     * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
     * Optional if the key set document:
     *  - can be retrieved from
     *    [OpenID
     *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
     *    of the issuer.
     *  - can be inferred from the email domain of the issuer (e.g. a Google
     *  service account).
     *
     * Example: https://www.googleapis.com/oauth2/v1/certs
     * </pre>
     *
     * <code>string jwks_uri = 3;</code>
     *
     * @param value The jwksUri to set.
     * @return This builder for chaining.
     */
    public Builder setJwksUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jwksUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the provider's public key set to validate signature of the JWT. See
     * [OpenID
     * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
     * Optional if the key set document:
     *  - can be retrieved from
     *    [OpenID
     *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
     *    of the issuer.
     *  - can be inferred from the email domain of the issuer (e.g. a Google
     *  service account).
     *
     * Example: https://www.googleapis.com/oauth2/v1/certs
     * </pre>
     *
     * <code>string jwks_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJwksUri() {
      jwksUri_ = getDefaultInstance().getJwksUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the provider's public key set to validate signature of the JWT. See
     * [OpenID
     * Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
     * Optional if the key set document:
     *  - can be retrieved from
     *    [OpenID
     *    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
     *    of the issuer.
     *  - can be inferred from the email domain of the issuer (e.g. a Google
     *  service account).
     *
     * Example: https://www.googleapis.com/oauth2/v1/certs
     * </pre>
     *
     * <code>string jwks_uri = 3;</code>
     *
     * @param value The bytes for jwksUri to set.
     * @return This builder for chaining.
     */
    public Builder setJwksUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jwksUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object audiences_ = "";
    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted. When this setting is absent, JWTs with audiences:
     *   - "https://[service.name]/[google.protobuf.Api.name]"
     *   - "https://[service.name]/"
     * will be accepted.
     * For example, if no audiences are in the setting, LibraryService API will
     * accept JWTs with the following audiences:
     *   -
     *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
     *   - https://library-example.googleapis.com/
     *
     * Example:
     *
     *     audiences: bookstore_android.apps.googleusercontent.com,
     *                bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>string audiences = 4;</code>
     *
     * @return The audiences.
     */
    public java.lang.String getAudiences() {
      java.lang.Object ref = audiences_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audiences_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted. When this setting is absent, JWTs with audiences:
     *   - "https://[service.name]/[google.protobuf.Api.name]"
     *   - "https://[service.name]/"
     * will be accepted.
     * For example, if no audiences are in the setting, LibraryService API will
     * accept JWTs with the following audiences:
     *   -
     *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
     *   - https://library-example.googleapis.com/
     *
     * Example:
     *
     *     audiences: bookstore_android.apps.googleusercontent.com,
     *                bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>string audiences = 4;</code>
     *
     * @return The bytes for audiences.
     */
    public com.google.protobuf.ByteString getAudiencesBytes() {
      java.lang.Object ref = audiences_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audiences_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted. When this setting is absent, JWTs with audiences:
     *   - "https://[service.name]/[google.protobuf.Api.name]"
     *   - "https://[service.name]/"
     * will be accepted.
     * For example, if no audiences are in the setting, LibraryService API will
     * accept JWTs with the following audiences:
     *   -
     *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
     *   - https://library-example.googleapis.com/
     *
     * Example:
     *
     *     audiences: bookstore_android.apps.googleusercontent.com,
     *                bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>string audiences = 4;</code>
     *
     * @param value The audiences to set.
     * @return This builder for chaining.
     */
    public Builder setAudiences(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audiences_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted. When this setting is absent, JWTs with audiences:
     *   - "https://[service.name]/[google.protobuf.Api.name]"
     *   - "https://[service.name]/"
     * will be accepted.
     * For example, if no audiences are in the setting, LibraryService API will
     * accept JWTs with the following audiences:
     *   -
     *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
     *   - https://library-example.googleapis.com/
     *
     * Example:
     *
     *     audiences: bookstore_android.apps.googleusercontent.com,
     *                bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>string audiences = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudiences() {
      audiences_ = getDefaultInstance().getAudiences();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted. When this setting is absent, JWTs with audiences:
     *   - "https://[service.name]/[google.protobuf.Api.name]"
     *   - "https://[service.name]/"
     * will be accepted.
     * For example, if no audiences are in the setting, LibraryService API will
     * accept JWTs with the following audiences:
     *   -
     *   https://library-example.googleapis.com/google.example.library.v1.LibraryService
     *   - https://library-example.googleapis.com/
     *
     * Example:
     *
     *     audiences: bookstore_android.apps.googleusercontent.com,
     *                bookstore_web.apps.googleusercontent.com
     * </pre>
     *
     * <code>string audiences = 4;</code>
     *
     * @param value The bytes for audiences to set.
     * @return This builder for chaining.
     */
    public Builder setAudiencesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audiences_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object authorizationUrl_ = "";
    /**
     *
     *
     * <pre>
     * Redirect URL if JWT token is required but not present or is expired.
     * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
     * </pre>
     *
     * <code>string authorization_url = 5;</code>
     *
     * @return The authorizationUrl.
     */
    public java.lang.String getAuthorizationUrl() {
      java.lang.Object ref = authorizationUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authorizationUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Redirect URL if JWT token is required but not present or is expired.
     * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
     * </pre>
     *
     * <code>string authorization_url = 5;</code>
     *
     * @return The bytes for authorizationUrl.
     */
    public com.google.protobuf.ByteString getAuthorizationUrlBytes() {
      java.lang.Object ref = authorizationUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authorizationUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Redirect URL if JWT token is required but not present or is expired.
     * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
     * </pre>
     *
     * <code>string authorization_url = 5;</code>
     *
     * @param value The authorizationUrl to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizationUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authorizationUrl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Redirect URL if JWT token is required but not present or is expired.
     * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
     * </pre>
     *
     * <code>string authorization_url = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizationUrl() {
      authorizationUrl_ = getDefaultInstance().getAuthorizationUrl();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Redirect URL if JWT token is required but not present or is expired.
     * Implement authorizationUrl of securityDefinitions in OpenAPI spec.
     * </pre>
     *
     * <code>string authorization_url = 5;</code>
     *
     * @param value The bytes for authorizationUrl to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizationUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authorizationUrl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.JwtLocation> jwtLocations_ =
        java.util.Collections.emptyList();

    private void ensureJwtLocationsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        jwtLocations_ = new java.util.ArrayList<com.google.api.JwtLocation>(jwtLocations_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.JwtLocation,
            com.google.api.JwtLocation.Builder,
            com.google.api.JwtLocationOrBuilder>
        jwtLocationsBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public java.util.List<com.google.api.JwtLocation> getJwtLocationsList() {
      if (jwtLocationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(jwtLocations_);
      } else {
        return jwtLocationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public int getJwtLocationsCount() {
      if (jwtLocationsBuilder_ == null) {
        return jwtLocations_.size();
      } else {
        return jwtLocationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public com.google.api.JwtLocation getJwtLocations(int index) {
      if (jwtLocationsBuilder_ == null) {
        return jwtLocations_.get(index);
      } else {
        return jwtLocationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder setJwtLocations(int index, com.google.api.JwtLocation value) {
      if (jwtLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJwtLocationsIsMutable();
        jwtLocations_.set(index, value);
        onChanged();
      } else {
        jwtLocationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder setJwtLocations(int index, com.google.api.JwtLocation.Builder builderForValue) {
      if (jwtLocationsBuilder_ == null) {
        ensureJwtLocationsIsMutable();
        jwtLocations_.set(index, builderForValue.build());
        onChanged();
      } else {
        jwtLocationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder addJwtLocations(com.google.api.JwtLocation value) {
      if (jwtLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJwtLocationsIsMutable();
        jwtLocations_.add(value);
        onChanged();
      } else {
        jwtLocationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder addJwtLocations(int index, com.google.api.JwtLocation value) {
      if (jwtLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJwtLocationsIsMutable();
        jwtLocations_.add(index, value);
        onChanged();
      } else {
        jwtLocationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder addJwtLocations(com.google.api.JwtLocation.Builder builderForValue) {
      if (jwtLocationsBuilder_ == null) {
        ensureJwtLocationsIsMutable();
        jwtLocations_.add(builderForValue.build());
        onChanged();
      } else {
        jwtLocationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder addJwtLocations(int index, com.google.api.JwtLocation.Builder builderForValue) {
      if (jwtLocationsBuilder_ == null) {
        ensureJwtLocationsIsMutable();
        jwtLocations_.add(index, builderForValue.build());
        onChanged();
      } else {
        jwtLocationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder addAllJwtLocations(
        java.lang.Iterable<? extends com.google.api.JwtLocation> values) {
      if (jwtLocationsBuilder_ == null) {
        ensureJwtLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jwtLocations_);
        onChanged();
      } else {
        jwtLocationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder clearJwtLocations() {
      if (jwtLocationsBuilder_ == null) {
        jwtLocations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        jwtLocationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public Builder removeJwtLocations(int index) {
      if (jwtLocationsBuilder_ == null) {
        ensureJwtLocationsIsMutable();
        jwtLocations_.remove(index);
        onChanged();
      } else {
        jwtLocationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public com.google.api.JwtLocation.Builder getJwtLocationsBuilder(int index) {
      return getJwtLocationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public com.google.api.JwtLocationOrBuilder getJwtLocationsOrBuilder(int index) {
      if (jwtLocationsBuilder_ == null) {
        return jwtLocations_.get(index);
      } else {
        return jwtLocationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public java.util.List<? extends com.google.api.JwtLocationOrBuilder>
        getJwtLocationsOrBuilderList() {
      if (jwtLocationsBuilder_ != null) {
        return jwtLocationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(jwtLocations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public com.google.api.JwtLocation.Builder addJwtLocationsBuilder() {
      return getJwtLocationsFieldBuilder()
          .addBuilder(com.google.api.JwtLocation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public com.google.api.JwtLocation.Builder addJwtLocationsBuilder(int index) {
      return getJwtLocationsFieldBuilder()
          .addBuilder(index, com.google.api.JwtLocation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the locations to extract the JWT.  For now it is only used by the
     * Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations]
     * (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations)
     *
     * JWT locations can be one of HTTP headers, URL query parameters or
     * cookies. The rule is that the first match wins.
     *
     * If not specified,  default to use following 3 locations:
     *    1) Authorization: Bearer
     *    2) x-goog-iap-jwt-assertion
     *    3) access_token query parameter
     *
     * Default locations can be specified as followings:
     *    jwt_locations:
     *    - header: Authorization
     *      value_prefix: "Bearer "
     *    - header: x-goog-iap-jwt-assertion
     *    - query: access_token
     * </pre>
     *
     * <code>repeated .google.api.JwtLocation jwt_locations = 6;</code>
     */
    public java.util.List<com.google.api.JwtLocation.Builder> getJwtLocationsBuilderList() {
      return getJwtLocationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.JwtLocation,
            com.google.api.JwtLocation.Builder,
            com.google.api.JwtLocationOrBuilder>
        getJwtLocationsFieldBuilder() {
      if (jwtLocationsBuilder_ == null) {
        jwtLocationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.JwtLocation,
                com.google.api.JwtLocation.Builder,
                com.google.api.JwtLocationOrBuilder>(
                jwtLocations_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        jwtLocations_ = null;
      }
      return jwtLocationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.AuthProvider)
  }

  // @@protoc_insertion_point(class_scope:google.api.AuthProvider)
  private static final com.google.api.AuthProvider DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.AuthProvider();
  }

  public static com.google.api.AuthProvider getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuthProvider> PARSER =
      new com.google.protobuf.AbstractParser<AuthProvider>() {
        @java.lang.Override
        public AuthProvider parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuthProvider> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuthProvider> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.AuthProvider getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
