package com.cybelia.sandra.entities.sig;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.Lieu;
import com.cybelia.sandra.entities.LieuDAO;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PointGPSDAOAbstract<E extends PointGPS> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)PointGPS.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.PointGPS;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<InfoAccess> list = getContext()
                                                    .getDAO(InfoAccess.class)
                                                    .findAllByProperties(InfoAccess.PROPERTY_GPS, entity);
                                            for (InfoAccess item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getGps())) {
                                                    item.setGps(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Lieu> list = getContext()
                                                    .getDAO(Lieu.class)
                                                    .findAllByProperties(Lieu.PROPERTY_TOMTOM_GPS, entity);
                                            for (Lieu item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTomtomGPS())) {
                                                    item.setTomtomGPS(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByOrdre(int v) throws TopiaException {
        E result = findByProperty(PointGPS.PROPERTY_ORDRE, v);
        return result;
    }

    public List<E> findAllByOrdre(int v) throws TopiaException {
        List<E> result = findAllByProperty(PointGPS.PROPERTY_ORDRE, v);
        return result;
    }

    public E findByPoint(Point v) throws TopiaException {
        E result = findByProperty(PointGPS.PROPERTY_POINT, v);
        return result;
    }

    public List<E> findAllByPoint(Point v) throws TopiaException {
        List<E> result = findAllByProperty(PointGPS.PROPERTY_POINT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == InfoAccess.class) {
            InfoAccessDAO dao = (InfoAccessDAO)
                getContext().getDAO(InfoAccess.class);
            tmp = dao.findAllByGps(entity);
            result.addAll(tmp);
        }

        if (type == TraceGPS.class) {
            TraceGPSDAO dao = (TraceGPSDAO)
                getContext().getDAO(TraceGPS.class);
            tmp = dao.findAllContainsListePoints(entity);
            result.addAll(tmp);
        }

        if (type == Lieu.class) {
            LieuDAO dao = (LieuDAO)
                getContext().getDAO(Lieu.class);
            tmp = dao.findAllByTomtomGPS(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(InfoAccess.class, entity);
        if (!list.isEmpty()) {
            result.put(InfoAccess.class, list);
        }

        list = findUsages(TraceGPS.class, entity);
        if (!list.isEmpty()) {
            result.put(TraceGPS.class, list);
        }

        list = findUsages(Lieu.class, entity);
        if (!list.isEmpty()) {
            result.put(Lieu.class, list);
        }

        return result;
    }

} //PointGPSDAOAbstract<E extends PointGPS>
