package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SocieteAbstract extends TopiaEntityAbstract implements Societe {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    private static final long serialVersionUID = 7147882638104356144L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CODE, this.code).
         toString();
        return result;
    }

} //SocieteAbstract
