package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class LabelAbstract extends TopiaEntityAbstract implements Label {

    /**
     * Nom de l'attribut en BD : id
     */
    protected String id;

    /**
     * Nom de l'attribut en BD : valeur
     */
    protected String valeur;

    /**
     * Nom de l'attribut en BD : categorie
     */
    protected String categorie;

    private static final long serialVersionUID = 3702298867813986866L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ID, String.class, id);
        visitor.visit(this, PROPERTY_VALEUR, String.class, valeur);
        visitor.visit(this, PROPERTY_CATEGORIE, String.class, categorie);
        visitor.end(this);
    }

    @Override
    public void setId(String id) {
        String oldValue = this.id;
        fireOnPreWrite(PROPERTY_ID, oldValue, id);
        this.id = id;
        fireOnPostWrite(PROPERTY_ID, oldValue, id);
    }

    @Override
    public String getId() {
        fireOnPreRead(PROPERTY_ID, id);
        String result = this.id;
        fireOnPostRead(PROPERTY_ID, id);
        return result;
    }

    @Override
    public void setValeur(String valeur) {
        String oldValue = this.valeur;
        fireOnPreWrite(PROPERTY_VALEUR, oldValue, valeur);
        this.valeur = valeur;
        fireOnPostWrite(PROPERTY_VALEUR, oldValue, valeur);
    }

    @Override
    public String getValeur() {
        fireOnPreRead(PROPERTY_VALEUR, valeur);
        String result = this.valeur;
        fireOnPostRead(PROPERTY_VALEUR, valeur);
        return result;
    }

    @Override
    public void setCategorie(String categorie) {
        String oldValue = this.categorie;
        fireOnPreWrite(PROPERTY_CATEGORIE, oldValue, categorie);
        this.categorie = categorie;
        fireOnPostWrite(PROPERTY_CATEGORIE, oldValue, categorie);
    }

    @Override
    public String getCategorie() {
        fireOnPreRead(PROPERTY_CATEGORIE, categorie);
        String result = this.categorie;
        fireOnPostRead(PROPERTY_CATEGORIE, categorie);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ID, this.id).
            append(PROPERTY_VALEUR, this.valeur).
            append(PROPERTY_CATEGORIE, this.categorie).
         toString();
        return result;
    }

} //LabelAbstract
