package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class InfoChargementDAOAbstract<E extends InfoChargement> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)InfoChargement.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.InfoChargement;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<LigneProduit> list = getContext()
                                                    .getDAO(LigneProduit.class)
                                                    .findAllByProperties(LigneProduit.PROPERTY_INFO_CHARGEMENT, entity);
                                            for (LigneProduit item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getInfoChargement())) {
                                                    item.setInfoChargement(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByDate(Date v) throws TopiaException {
        E result = findByProperty(InfoChargement.PROPERTY_DATE, v);
        return result;
    }

    public List<E> findAllByDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(InfoChargement.PROPERTY_DATE, v);
        return result;
    }

    public E findByQuantite(int v) throws TopiaException {
        E result = findByProperty(InfoChargement.PROPERTY_QUANTITE, v);
        return result;
    }

    public List<E> findAllByQuantite(int v) throws TopiaException {
        List<E> result = findAllByProperty(InfoChargement.PROPERTY_QUANTITE, v);
        return result;
    }

    public E findByCompartiments(String v) throws TopiaException {
        E result = findByProperty(InfoChargement.PROPERTY_COMPARTIMENTS, v);
        return result;
    }

    public List<E> findAllByCompartiments(String v) throws TopiaException {
        List<E> result = findAllByProperty(InfoChargement.PROPERTY_COMPARTIMENTS, v);
        return result;
    }

    public E findByNotifier(boolean v) throws TopiaException {
        E result = findByProperty(InfoChargement.PROPERTY_NOTIFIER, v);
        return result;
    }

    public List<E> findAllByNotifier(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(InfoChargement.PROPERTY_NOTIFIER, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == LigneProduit.class) {
            LigneProduitDAO dao = (LigneProduitDAO)
                getContext().getDAO(LigneProduit.class);
            tmp = dao.findAllByInfoChargement(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(LigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(LigneProduit.class, list);
        }

        return result;
    }

} //InfoChargementDAOAbstract<E extends InfoChargement>
