package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;

public interface InfoAccess extends TopiaEntity {

    String PROPERTY_ACCES_SILO = "accesSilo";

    String PROPERTY_MODE_CHARGEMENT = "modeChargement";

    String PROPERTY_NOM_ACCES = "nomAcces";

    String PROPERTY_TYPE = "type";

    String PROPERTY_NIVEAU_SECURITE = "niveauSecurite";

    String PROPERTY_COMMENTAIRE_SECURITE = "commentaireSecurite";

    String PROPERTY_RISQUES = "risques";

    String PROPERTY_ETAT = "etat";

    String PROPERTY_ELEVEUR = "eleveur";

    String PROPERTY_GPS = "gps";

    String PROPERTY_TRACE = "trace";

    String PROPERTY_USERS_VERROUILLAGE = "usersVerrouillage";

    void setAccesSilo(String accesSilo);

    String getAccesSilo();

    void setModeChargement(String modeChargement);

    String getModeChargement();

    void setNomAcces(String nomAcces);

    String getNomAcces();

    void setType(int type);

    int getType();

    void setNiveauSecurite(int niveauSecurite);

    int getNiveauSecurite();

    void setCommentaireSecurite(String commentaireSecurite);

    String getCommentaireSecurite();

    void addRisques(String risques);

    void addAllRisques(Collection<String> risques);

    void setRisques(Collection<String> risques);

    void removeRisques(String risques);

    void clearRisques();

    Collection<String> getRisques();

    int sizeRisques();

    boolean isRisquesEmpty();

    void setEtat(int etat);

    int getEtat();

    void setEleveur(Eleveur eleveur);

    Eleveur getEleveur();

    void setGps(PointGPS gps);

    PointGPS getGps();

    void setTrace(TraceGPS trace);

    TraceGPS getTrace();

    void addUsersVerrouillage(TaasUser usersVerrouillage);

    void addAllUsersVerrouillage(Collection<TaasUser> usersVerrouillage);

    void setUsersVerrouillage(Collection<TaasUser> usersVerrouillage);

    void removeUsersVerrouillage(TaasUser usersVerrouillage);

    void clearUsersVerrouillage();

    Collection<TaasUser> getUsersVerrouillage();

    TaasUser getUsersVerrouillageByTopiaId(String topiaId);

    int sizeUsersVerrouillage();

    boolean isUsersVerrouillageEmpty();

} //InfoAccess
