package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.sig.PointGPS;
import com.vividsolutions.jts.geom.Point;

/**
 * @author sletellier
 */
public enum GPSStateEnum {

    // Les differentes valeurs que peuvent prendre le GPS dans l'index
    GPS_LOCKED("gpsLocked"),
    GPS_EMPTY("gpsEmpty"),
    GPS_OK("gpsOk");

    private final String key;

    private GPSStateEnum(String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    public static GPSStateEnum getGPSState(Eleveur eleveur) {
        PointGPS gps = eleveur.getTomtomGPS();
        if (gps == null || gps.getPoint() == null) {
            return GPS_EMPTY;
        }
        Point gpsPoint = gps.getPoint();
        if (gpsPoint.getX() == 0 && gpsPoint.getY() == 0) {
            return GPS_EMPTY;
        }
        if (eleveur.getNbTomTomGPSModif() > 3) {
            return GPS_LOCKED;
        }
        return GPS_OK;
    }

    public static GPSStateEnum getGPSState(String key) {
        for (GPSStateEnum anEnum : values()) {
            if (anEnum.getKey().equals(key)) {
                return anEnum;
            }
        }
        return null;
    }
}
