package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CommandeAbstract extends TopiaEntityAbstract implements Commande {

    /**
     * Nom de l'attribut en BD : numero
     */
    protected String numero;

    /**
     * Nom de l'attribut en BD : commentaire
     */
    protected String commentaire;

    /**
     * Nom de l'attribut en BD : contrainteHoraire
     */
    protected String contrainteHoraire;

    /**
     * Nom de l'attribut en BD : actif
     */
    protected boolean actif;

    private static final long serialVersionUID = 7089851526750036535L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NUMERO, String.class, numero);
        visitor.visit(this, PROPERTY_COMMENTAIRE, String.class, commentaire);
        visitor.visit(this, PROPERTY_CONTRAINTE_HORAIRE, String.class, contrainteHoraire);
        visitor.visit(this, PROPERTY_ACTIF, boolean.class, actif);
        visitor.end(this);
    }

    @Override
    public void setNumero(String numero) {
        String oldValue = this.numero;
        fireOnPreWrite(PROPERTY_NUMERO, oldValue, numero);
        this.numero = numero;
        fireOnPostWrite(PROPERTY_NUMERO, oldValue, numero);
    }

    @Override
    public String getNumero() {
        fireOnPreRead(PROPERTY_NUMERO, numero);
        String result = this.numero;
        fireOnPostRead(PROPERTY_NUMERO, numero);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        fireOnPreWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
        this.commentaire = commentaire;
        fireOnPostWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        fireOnPreRead(PROPERTY_COMMENTAIRE, commentaire);
        String result = this.commentaire;
        fireOnPostRead(PROPERTY_COMMENTAIRE, commentaire);
        return result;
    }

    @Override
    public void setContrainteHoraire(String contrainteHoraire) {
        String oldValue = this.contrainteHoraire;
        fireOnPreWrite(PROPERTY_CONTRAINTE_HORAIRE, oldValue, contrainteHoraire);
        this.contrainteHoraire = contrainteHoraire;
        fireOnPostWrite(PROPERTY_CONTRAINTE_HORAIRE, oldValue, contrainteHoraire);
    }

    @Override
    public String getContrainteHoraire() {
        fireOnPreRead(PROPERTY_CONTRAINTE_HORAIRE, contrainteHoraire);
        String result = this.contrainteHoraire;
        fireOnPostRead(PROPERTY_CONTRAINTE_HORAIRE, contrainteHoraire);
        return result;
    }

    @Override
    public void setActif(boolean actif) {
        boolean oldValue = this.actif;
        fireOnPreWrite(PROPERTY_ACTIF, oldValue, actif);
        this.actif = actif;
        fireOnPostWrite(PROPERTY_ACTIF, oldValue, actif);
    }

    @Override
    public boolean isActif() {
        fireOnPreRead(PROPERTY_ACTIF, actif);
        boolean result = this.actif;
        fireOnPostRead(PROPERTY_ACTIF, actif);
        return result;
    }

    @Override
    public boolean getActif() {
        fireOnPreRead(PROPERTY_ACTIF, actif);
        boolean result = this.actif;
        fireOnPostRead(PROPERTY_ACTIF, actif);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NUMERO, this.numero).
            append(PROPERTY_COMMENTAIRE, this.commentaire).
            append(PROPERTY_CONTRAINTE_HORAIRE, this.contrainteHoraire).
            append(PROPERTY_ACTIF, this.actif).
         toString();
        return result;
    }

} //CommandeAbstract
