/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ConcurrencyUtils {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static long THREADS_BEGIN_N_1D_FFT_2THREADS = 8192L;
    private static long THREADS_BEGIN_N_1D_FFT_4THREADS = 65536L;
    private static long THREADS_BEGIN_N_2D = 65536L;
    private static long LARGE_ARAYS_BEGIN_N = 0x10000000L;
    private static long THREADS_BEGIN_N_3D = 65536L;
    private static int NTHREADS = ConcurrencyUtils.prevPow2(ConcurrencyUtils.getNumberOfProcessors());

    private ConcurrencyUtils() {
    }

    public static int getNumberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfThreads() {
        return NTHREADS;
    }

    public static void setNumberOfThreads(int n) {
        NTHREADS = ConcurrencyUtils.prevPow2(n);
    }

    public static long getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static long getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static long getThreadsBeginN_2D() {
        return THREADS_BEGIN_N_2D;
    }

    public static long getThreadsBeginN_3D() {
        return THREADS_BEGIN_N_3D;
    }

    public static long getLargeArraysBeginN() {
        return LARGE_ARAYS_BEGIN_N;
    }

    public static void setThreadsBeginN_1D_FFT_2Threads(long l) {
        THREADS_BEGIN_N_1D_FFT_2THREADS = l < 1024L ? 1024L : l;
    }

    public static void setThreadsBeginN_1D_FFT_4Threads(long l) {
        THREADS_BEGIN_N_1D_FFT_4THREADS = l < 1024L ? 1024L : l;
    }

    public static void setThreadsBeginN_2D(long l) {
        THREADS_BEGIN_N_2D = l < 4096L ? 4096L : l;
    }

    public static void setThreadsBeginN_3D(long l) {
        THREADS_BEGIN_N_3D = l;
    }

    public static void resetThreadsBeginN_FFT() {
        THREADS_BEGIN_N_1D_FFT_2THREADS = 8192L;
        THREADS_BEGIN_N_1D_FFT_4THREADS = 65536L;
    }

    public static void resetThreadsBeginN() {
        THREADS_BEGIN_N_2D = 65536L;
        THREADS_BEGIN_N_3D = 65536L;
    }

    public static void setLargeArraysBeginN(long l) {
        LARGE_ARAYS_BEGIN_N = l < 1L ? 1L : (l > 0x10000000L ? 0x10000000L : l);
    }

    public static int nextPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n + 1;
    }

    public static long nextPow2(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((l & l - 1L) == 0L) {
            return l;
        }
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return l + 1L;
    }

    public static int prevPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(n) / Math.log(2.0)));
    }

    public static long prevPow2(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (long)Math.pow(2.0, Math.floor(Math.log(l) / Math.log(2.0)));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public static boolean isPowerOf2(long l) {
        if (l <= 0L) {
            return false;
        }
        return (l & l - 1L) == 0L;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static Future<?> submit(Runnable runnable) {
        return THREAD_POOL.submit(runnable);
    }

    public static void waitForCompletion(Future<?>[] futureArray) {
        int n = futureArray.length;
        try {
            for (int i = 0; i < n; ++i) {
                futureArray[i].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.handler = uncaughtExceptionHandler;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = defaultFactory.newThread(runnable);
            thread.setUncaughtExceptionHandler(this.handler);
            return thread;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

