/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.dataset;

import com.github.springtestdbunit.dataset.AbstractDataSetLoader;
import java.io.InputStream;
import java.net.URL;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.springframework.core.io.Resource;

public class FlatXmlDataSetLoader
extends AbstractDataSetLoader {
    protected IDataSet createDataSet(Resource resource) throws Exception {
        FlatXmlDataSetBuilder builder = new FlatXmlDataSetBuilder();
        builder.setColumnSensing(true);
        return this.buildDataSet(builder, resource);
    }

    private IDataSet buildDataSet(FlatXmlDataSetBuilder builder, Resource resource) throws Exception {
        try {
            return this.buildDataSetFromUrl(builder, resource.getURL());
        }
        catch (Exception ex) {
            return this.buildDataSetFromStream(builder, resource);
        }
    }

    private IDataSet buildDataSetFromUrl(FlatXmlDataSetBuilder builder, URL url) throws Exception {
        return builder.build(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataSet buildDataSetFromStream(FlatXmlDataSetBuilder builder, Resource resource) throws Exception {
        InputStream inputStream = resource.getInputStream();
        try {
            FlatXmlDataSet flatXmlDataSet = builder.build(inputStream);
            return flatXmlDataSet;
        }
        finally {
            inputStream.close();
        }
    }
}

